/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.monster;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Random;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.monster.WeightedRandomEntity;
import xiroc.dungeoncrawl.dungeon.treasure.Loot;

public class RandomMonster {
    public static final Hashtable<EntityType<?>, MobNBTPatcher> NBT_PATCHERS = new Hashtable();
    public static WeightedRandomEntity[] COMMON;
    public static WeightedRandomEntity[] RARE;
    private static final CompoundNBT VILLAGER_OFFERS;

    private static CompoundNBT offer(String buy, byte buyCount, String buyB, byte buyBCount, String sell, byte sellCount) {
        CompoundNBT offer = new CompoundNBT();
        CompoundNBT buyNbt = new CompoundNBT();
        buyNbt.func_74778_a("id", buy);
        buyNbt.func_74757_a("Count", true);
        buyNbt.func_74768_a("MaxUses", 3);
        buyNbt.func_74774_a("Count", buyCount);
        CompoundNBT buyTag = new CompoundNBT();
        buyTag.func_74768_a("Damage", 0);
        buyNbt.func_218657_a("tag", (INBT)buyTag);
        CompoundNBT buyBNbt = new CompoundNBT();
        buyBNbt.func_74778_a("id", buyB);
        buyBNbt.func_74757_a("Count", true);
        buyBNbt.func_74768_a("MaxUses", 3);
        buyBNbt.func_74774_a("Count", buyBCount);
        CompoundNBT buyBTag = new CompoundNBT();
        buyBTag.func_74768_a("Damage", 0);
        buyBNbt.func_218657_a("tag", (INBT)buyBTag);
        CompoundNBT sellNbt = new CompoundNBT();
        sellNbt.func_74778_a("id", sell);
        sellNbt.func_74757_a("Count", true);
        sellNbt.func_74768_a("MaxUses", 3);
        sellNbt.func_74774_a("Count", sellCount);
        CompoundNBT sellTag = new CompoundNBT();
        sellTag.func_74768_a("Damage", 0);
        sellNbt.func_218657_a("tag", (INBT)sellTag);
        offer.func_218657_a("buy", (INBT)buyNbt);
        offer.func_218657_a("buyB", (INBT)buyBNbt);
        offer.func_218657_a("sell", (INBT)sellNbt);
        offer.func_74768_a("uses", 0);
        offer.func_74768_a("xp", 0);
        offer.func_74776_a("priceMultiplier", 0.0f);
        offer.func_74768_a("demand", 0);
        offer.func_74768_a("specialPrice", 0);
        offer.func_74757_a("rewardXp", false);
        return offer;
    }

    public static void loadJson(IResourceManager resourceManager) {
        COMMON = new WeightedRandomEntity[5];
        RARE = new WeightedRandomEntity[5];
        JsonParser parser = new JsonParser();
        try {
            RandomMonster.loadEntityFile(resourceManager, DungeonCrawl.locate("monster/entities/stage_1.json"), parser, 0);
            RandomMonster.loadEntityFile(resourceManager, DungeonCrawl.locate("monster/entities/stage_2.json"), parser, 1);
            RandomMonster.loadEntityFile(resourceManager, DungeonCrawl.locate("monster/entities/stage_3.json"), parser, 2);
            RandomMonster.loadEntityFile(resourceManager, DungeonCrawl.locate("monster/entities/stage_4.json"), parser, 3);
            RandomMonster.loadEntityFile(resourceManager, DungeonCrawl.locate("monster/entities/stage_5.json"), parser, 4);
        }
        catch (IOException e) {
            DungeonCrawl.LOGGER.error("Failed to load the monster entity files.");
            e.printStackTrace();
        }
    }

    private static void loadEntityFile(IResourceManager resourceManager, ResourceLocation file, JsonParser parser, int stage) throws IOException {
        if (resourceManager.func_219533_b(file)) {
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)file.toString());
            JsonObject object = parser.parse(new JsonReader((Reader)new InputStreamReader(resourceManager.func_199002_a(file).func_199027_b()))).getAsJsonObject();
            if (object.has("common")) {
                RandomMonster.COMMON[stage] = WeightedRandomEntity.fromJson(object.getAsJsonArray("common"));
            } else {
                DungeonCrawl.LOGGER.warn("Missing entry 'common' in {}", (Object)file.toString());
                RandomMonster.COMMON[stage] = WeightedRandomEntity.EMPTY;
            }
            if (object.has("rare")) {
                RandomMonster.RARE[stage] = WeightedRandomEntity.fromJson(object.getAsJsonArray("rare"));
            } else {
                DungeonCrawl.LOGGER.warn("Missing entry 'rare' in {}", (Object)file.toString());
                RandomMonster.RARE[stage] = WeightedRandomEntity.EMPTY;
            }
        } else {
            throw new FileNotFoundException("Missing file: " + file.toString());
        }
    }

    public static EntityType<?> randomMonster(Random rand, int stage) {
        if (stage > 4) {
            stage = 4;
        }
        if ((double)rand.nextFloat() < 0.1) {
            EntityType<?> monster = RARE[stage].roll(rand);
            if (monster != null) {
                return monster;
            }
            return COMMON[stage].roll(rand);
        }
        return COMMON[stage].roll(rand);
    }

    static {
        VILLAGER_OFFERS = new CompoundNBT();
        ListNBT recipes = new ListNBT();
        recipes.add((Object)RandomMonster.offer("minecraft:paper", (byte)1, "minecraft:air", (byte)0, "minecraft:paper", (byte)1));
        VILLAGER_OFFERS.func_218657_a("Recipes", (INBT)recipes);
        NBT_PATCHERS.put(EntityType.field_200722_aA, (nbt, rand, stage) -> {
            nbt.func_74778_a("DeathLootTable", Loot.WITHER_SKELETON.toString());
            nbt.func_74772_a("DeathLootTableSeed", (long)rand.nextInt());
        });
        NBT_PATCHERS.put(EntityType.field_200727_aF, (nbt, rand, stage) -> {
            nbt.func_218657_a("Offers", (INBT)VILLAGER_OFFERS.func_74737_b());
            nbt.func_74768_a("Xp", 1);
            nbt.func_74757_a("Willing", false);
            CompoundNBT villagerData = nbt.func_74775_l("villagerData");
            villagerData.func_74768_a("level", 5);
        });
    }

    @FunctionalInterface
    public static interface MobNBTPatcher {
        public void patch(CompoundNBT var1, Random var2, int var3);
    }
}

