/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.decoration;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.block.DungeonBlocks;
import xiroc.dungeoncrawl.dungeon.block.provider.BlockStateProvider;
import xiroc.dungeoncrawl.dungeon.decoration.DungeonDecoration;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;

public class ScatteredDecoration
implements DungeonDecoration {
    private final BlockStateProvider blockStateProvider;
    private final float chance;

    public ScatteredDecoration(BlockStateProvider blockStateProvider, float chance) {
        this.blockStateProvider = blockStateProvider;
        this.chance = chance;
    }

    @Override
    public void decorate(DungeonModel model, IWorld world, BlockPos pos, int width, int height, int length, MutableBoundingBox worldGenBounds, MutableBoundingBox structureBounds, DungeonPiece piece, int stage, boolean worldGen) {
        boolean ew = piece.field_186169_c == Rotation.NONE || piece.field_186169_c == Rotation.CLOCKWISE_180;
        int maxX = ew ? width : length;
        int maxZ = ew ? length : width;
        for (int x = 1; x < maxX - 1; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 1; z < maxZ - 1; ++z) {
                    boolean _up;
                    BlockPos currentPos = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                    if (!worldGenBounds.func_175898_b((Vector3i)currentPos) || !structureBounds.func_175898_b((Vector3i)currentPos) || DungeonBuilder.isBlockProtected(world, currentPos) || !world.func_175623_d(currentPos) || !(DungeonBlocks.RANDOM.nextFloat() < this.chance)) continue;
                    BlockPos north = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z - 1);
                    BlockPos east = new BlockPos(north.func_177958_n() + 1, north.func_177956_o(), pos.func_177952_p() + z);
                    BlockPos south = new BlockPos(north.func_177958_n(), north.func_177956_o(), east.func_177952_p() + 1);
                    BlockPos west = new BlockPos(north.func_177958_n() - 1, north.func_177956_o(), east.func_177952_p());
                    BlockPos up = new BlockPos(north.func_177958_n(), north.func_177956_o() + 1, east.func_177952_p());
                    boolean _north = worldGenBounds.func_175898_b((Vector3i)north) && structureBounds.func_175898_b((Vector3i)north) && world.func_180495_p(north).func_200132_m();
                    boolean _east = worldGenBounds.func_175898_b((Vector3i)east) && structureBounds.func_175898_b((Vector3i)east) && world.func_180495_p(east).func_200132_m();
                    boolean _south = worldGenBounds.func_175898_b((Vector3i)south) && structureBounds.func_175898_b((Vector3i)south) && world.func_180495_p(south).func_200132_m();
                    boolean _west = worldGenBounds.func_175898_b((Vector3i)west) && structureBounds.func_175898_b((Vector3i)west) && world.func_180495_p(west).func_200132_m();
                    boolean bl = _up = worldGenBounds.func_175898_b((Vector3i)up) && structureBounds.func_175898_b((Vector3i)up) && world.func_180495_p(up).func_200132_m();
                    if (!_north && !_east && !_south && !_west && !_up) continue;
                    world.func_180501_a(currentPos, this.blockStateProvider.get(world, currentPos), 2);
                }
            }
        }
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", "scattered");
        object.addProperty("chance", (Number)Float.valueOf(this.chance));
        object.add("block", (JsonElement)this.blockStateProvider.serialize());
        return object;
    }
}

