/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.DungeonLayer;
import xiroc.dungeoncrawl.dungeon.Tile;
import xiroc.dungeoncrawl.dungeon.piece.room.DungeonSideRoom;
import xiroc.dungeoncrawl.util.Position2D;

public class DungeonFeatures {
    public static final List<CorridorFeature> CORRIDOR_FEATURES = Lists.newArrayList();

    public static void processCorridor(DungeonBuilder builder, DungeonLayer layer, int x, int z, Random rand, int lyr, int stage, BlockPos startPos) {
        for (CorridorFeature corridorFeature : CORRIDOR_FEATURES) {
            if (!corridorFeature.process(builder, layer, x, z, rand, lyr, stage, startPos)) continue;
            return;
        }
    }

    static {
        CORRIDOR_FEATURES.add((builder, layer, x, z, rand, lyr, stage, startPos) -> {
            Tuple<Position2D, Rotation> sideRoomData;
            if (layer.grid[x][z].piece.connectedSides < 4 && (double)rand.nextFloat() < 0.075 && (sideRoomData = layer.findSideRoomData(new Position2D(x, z), rand)) != null) {
                DungeonSideRoom sideRoom = new DungeonSideRoom();
                Direction dir = ((Rotation)sideRoomData.func_76340_b()).func_185831_a(Direction.WEST);
                sideRoom.openSide(dir);
                sideRoom.setGridPosition((Position2D)sideRoomData.func_76341_a());
                sideRoom.setRotation((Rotation)sideRoomData.func_76340_b());
                sideRoom.stage = stage;
                layer.grid[((Position2D)sideRoomData.func_76341_a()).x][((Position2D)sideRoomData.func_76341_a()).z] = new Tile(sideRoom);
                layer.grid[x][z].piece.openSide(dir.func_176734_d());
                layer.map.markPositionAsOccupied((Position2D)sideRoomData.func_76341_a());
                layer.rotatePiece(layer.grid[x][z], rand);
                return true;
            }
            return false;
        });
    }

    @FunctionalInterface
    public static interface CorridorFeature {
        public boolean process(DungeonBuilder var1, DungeonLayer var2, int var3, int var4, Random var5, int var6, int var7, BlockPos var8);
    }
}

