/*
 * Decompiled with CFR 0.152.
 */
package com.baguchan.enchantwithmob.registry;

import com.baguchan.enchantwithmob.mobenchant.HealthBoostMobEnchant;
import com.baguchan.enchantwithmob.mobenchant.MobEnchant;
import com.baguchan.enchantwithmob.mobenchant.MultiShotMobEnchant;
import com.baguchan.enchantwithmob.mobenchant.ProtectionMobEnchant;
import com.baguchan.enchantwithmob.mobenchant.SpeedyMobEnchant;
import com.baguchan.enchantwithmob.mobenchant.StrongMobEnchant;
import com.baguchan.enchantwithmob.mobenchant.ThornEnchant;
import com.baguchan.enchantwithmob.mobenchant.ToughMobEnchant;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="enchantwithmob", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MobEnchants {
    public static final MobEnchant PROTECTION = new ProtectionMobEnchant(new MobEnchant.Properties(MobEnchant.Rarity.COMMON, 4));
    public static final MobEnchant TOUGH = new ToughMobEnchant(new MobEnchant.Properties(MobEnchant.Rarity.VERY_RARE, 2)).addAttributesModifier(Attributes.field_233826_i_, "313644c5-ead2-4670-b9eb-0b41d59ce5a2", 2.0, AttributeModifier.Operation.ADDITION).addAttributesModifier(Attributes.field_233827_j_, "8135df8f-38d9-490a-8d6f-c908fa973b34", 0.5, AttributeModifier.Operation.ADDITION);
    public static final MobEnchant SPEEDY = new SpeedyMobEnchant(new MobEnchant.Properties(MobEnchant.Rarity.UNCOMMON, 2)).addAttributesModifier(Attributes.field_233821_d_, "501f27a9-4a75-4c2e-a2ab-91eeed71d748", 0.05f, AttributeModifier.Operation.ADDITION);
    public static final MobEnchant STRONG = new StrongMobEnchant(new MobEnchant.Properties(MobEnchant.Rarity.COMMON, 3));
    public static final MobEnchant THORN = new ThornEnchant(new MobEnchant.Properties(MobEnchant.Rarity.VERY_RARE, 3));
    public static final MobEnchant HEALTH_BOOST = new HealthBoostMobEnchant(new MobEnchant.Properties(MobEnchant.Rarity.VERY_RARE, 5)).addAttributesModifier(Attributes.field_233818_a_, "f5d32c9f-2a3d-4157-bbf7-469d348ce097", 2.0, AttributeModifier.Operation.ADDITION);
    public static final MobEnchant MULTISHOT = new MultiShotMobEnchant(new MobEnchant.Properties(MobEnchant.Rarity.RARE, 1));
    private static ForgeRegistry<MobEnchant> registry;

    @SubscribeEvent
    public static void onNewRegistry(RegistryEvent.NewRegistry event) {
        registry = (ForgeRegistry)new RegistryBuilder().setType(MobEnchant.class).setName(new ResourceLocation("enchantwithmob", "mob_enchant")).setDefaultKey(new ResourceLocation("enchantwithmob", "protection")).create();
    }

    @SubscribeEvent
    public static void onRegisterEnchant(RegistryEvent.Register<MobEnchant> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new MobEnchant[]{(MobEnchant)PROTECTION.setRegistryName("protection"), (MobEnchant)TOUGH.setRegistryName("tough"), (MobEnchant)SPEEDY.setRegistryName("speedy"), (MobEnchant)STRONG.setRegistryName("strong"), (MobEnchant)THORN.setRegistryName("thorn"), (MobEnchant)HEALTH_BOOST.setRegistryName("health_boost"), (MobEnchant)MULTISHOT.setRegistryName("multishot")});
    }

    public static ForgeRegistry<MobEnchant> getRegistry() {
        if (registry == null) {
            throw new IllegalStateException("Registry not yet initialized");
        }
        return registry;
    }

    public static int getId(MobEnchant enchant) {
        return registry.getID((IForgeRegistryEntry)enchant);
    }

    public static MobEnchant byId(int id) {
        return (MobEnchant)registry.getValue(id);
    }
}

