/*
 * Decompiled with CFR 0.152.
 */
package com.baguchan.enchantwithmob.client;

import com.baguchan.enchantwithmob.EnchantWithMob;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.LightType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="enchantwithmob", value={Dist.CLIENT})
public class ClientEventHandler {
    private static final ResourceLocation ENCHANT_TEXTURE = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    protected static final RenderState.LightmapState LIGHTMAP = new RenderState.LightmapState(true);
    protected static final RenderState.TransparencyState ADDITIVE_TRANSPARENCY = new RenderState.TransparencyState("additive_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final RenderState.DiffuseLightingState DIFFUSE_LIGHTING_ENABLED = new RenderState.DiffuseLightingState(true);
    protected static final RenderState.FogState BLACK_FOG = new RenderState.FogState("black_fog", () -> {
        RenderSystem.fog((int)2918, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.enableFog();
    }, () -> {
        FogRenderer.func_228373_b_();
        RenderSystem.disableFog();
    });
    protected static final RenderState.AlphaState DEFAULT_ALPHA = new RenderState.AlphaState(0.003921569f);
    protected static final RenderState.OverlayState OVERLAY_ENABLED = new RenderState.OverlayState(true);
    protected static final RenderState.CullState CULL_DISABLED = new RenderState.CullState(false);

    @SubscribeEvent
    public static void renderEnchantBeam(RenderLivingEvent.Post<LivingEntity, EntityModel<LivingEntity>> event) {
        MatrixStack matrixStack = event.getMatrixStack();
        IRenderTypeBuffer bufferBuilder = event.getBuffers();
        float particalTick = event.getPartialRenderTick();
        event.getEntity().getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(cap -> {
            LivingEntity entity;
            if (cap.hasOwner() && (entity = cap.getEnchantOwner().get()) != null) {
                ClientEventHandler.renderBeam(event.getEntity(), particalTick, matrixStack, bufferBuilder, (Entity)entity, (LivingRenderer<LivingEntity, EntityModel<LivingEntity>>)event.getRenderer());
            }
        });
    }

    public static RenderType enchantBeamSwirl(ResourceLocation p_228636_0_, float p_228636_1_, float p_228636_2_) {
        return RenderType.func_228633_a_((String)"enchant_beam", (VertexFormat)DefaultVertexFormats.field_227852_q_, (int)7, (int)256, (boolean)false, (boolean)true, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(p_228636_0_, false, false)).func_228725_a_((RenderState.TexturingState)new RenderState.OffsetTexturingState(p_228636_1_, p_228636_2_)).func_228717_a_(BLACK_FOG).func_228726_a_(ADDITIVE_TRANSPARENCY).func_228716_a_(DIFFUSE_LIGHTING_ENABLED).func_228713_a_(DEFAULT_ALPHA).func_228714_a_(CULL_DISABLED).func_228719_a_(LIGHTMAP).func_228722_a_(OVERLAY_ENABLED).func_228728_a_(false));
    }

    private static void renderBeam(LivingEntity p_229118_1_, float p_229118_2_, MatrixStack p_229118_3_, IRenderTypeBuffer p_229118_4_, Entity p_229118_5_, LivingRenderer<LivingEntity, EntityModel<LivingEntity>> renderer) {
        float tick = (float)p_229118_1_.field_70173_aa + p_229118_2_;
        p_229118_3_.func_227860_a_();
        Vector3d vector3d = p_229118_5_.func_241843_o(p_229118_2_);
        double d0 = (double)(MathHelper.func_219799_g((float)p_229118_2_, (float)p_229118_1_.field_70761_aq, (float)p_229118_1_.field_70760_ar) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vector3d vector3d1 = new Vector3d(0.0, (double)p_229118_1_.func_70047_e() / 2.0, 0.0);
        double d1 = Math.cos(d0) * vector3d1.field_72449_c + Math.sin(d0) * vector3d1.field_72450_a;
        double d2 = Math.sin(d0) * vector3d1.field_72449_c - Math.cos(d0) * vector3d1.field_72450_a;
        double d3 = MathHelper.func_219803_d((double)p_229118_2_, (double)p_229118_1_.field_70169_q, (double)p_229118_1_.func_226277_ct_()) + d1;
        double d4 = MathHelper.func_219803_d((double)p_229118_2_, (double)p_229118_1_.field_70167_r, (double)p_229118_1_.func_226278_cu_()) + vector3d1.field_72448_b;
        double d5 = MathHelper.func_219803_d((double)p_229118_2_, (double)p_229118_1_.field_70166_s, (double)p_229118_1_.func_226281_cx_()) + d2;
        p_229118_3_.func_227861_a_(d1, vector3d1.field_72448_b, d2);
        float f = (float)(vector3d.field_72450_a - d3);
        float f1 = (float)(vector3d.field_72448_b - d4);
        float f2 = (float)(vector3d.field_72449_c - d5);
        float f3 = 0.1f;
        IVertexBuilder ivertexbuilder = p_229118_4_.getBuffer(ClientEventHandler.enchantBeamSwirl(ENCHANT_TEXTURE, tick * 0.01f, tick * 0.01f));
        Matrix4f matrix4f = p_229118_3_.func_227866_c_().func_227870_a_();
        float f4 = MathHelper.func_226165_i_((float)(f * f + f2 * f2)) * 0.1f / 2.0f;
        float f5 = f2 * f4;
        float f6 = f * f4;
        BlockPos blockpos = new BlockPos(p_229118_1_.func_174824_e(p_229118_2_));
        BlockPos blockpos1 = new BlockPos(p_229118_5_.func_174824_e(p_229118_2_));
        int i = ClientEventHandler.getBlockLightLevel((Entity)p_229118_1_, blockpos);
        int j = ClientEventHandler.getBlockLightLevel(p_229118_5_, blockpos1);
        int k = p_229118_1_.field_70170_p.func_226658_a_(LightType.SKY, blockpos);
        int l = p_229118_1_.field_70170_p.func_226658_a_(LightType.SKY, blockpos1);
        ClientEventHandler.renderSide(ivertexbuilder, matrix4f, f, f1, f2, i, j, k, l, 0.05f, 0.1f, f5, f6);
        ClientEventHandler.renderSide(ivertexbuilder, matrix4f, f, f1, f2, i, j, k, l, 0.1f, 0.0f, f5, f6);
        p_229118_3_.func_227865_b_();
    }

    public static void renderSide(IVertexBuilder p_229119_0_, Matrix4f p_229119_1_, float p_229119_2_, float p_229119_3_, float p_229119_4_, int p_229119_5_, int p_229119_6_, int p_229119_7_, int p_229119_8_, float p_229119_9_, float p_229119_10_, float p_229119_11_, float p_229119_12_) {
        int i = 24;
        for (int j = 0; j < 24; ++j) {
            float f = (float)j / 23.0f;
            int k = (int)MathHelper.func_219799_g((float)f, (float)p_229119_5_, (float)p_229119_6_);
            int l = (int)MathHelper.func_219799_g((float)f, (float)p_229119_7_, (float)p_229119_8_);
            int i1 = LightTexture.func_228451_a_((int)k, (int)l);
            ClientEventHandler.addVertexPair(p_229119_0_, p_229119_1_, i1, p_229119_2_, p_229119_3_, p_229119_4_, p_229119_9_, p_229119_10_, 24, j, false, p_229119_11_, p_229119_12_);
            ClientEventHandler.addVertexPair(p_229119_0_, p_229119_1_, i1, p_229119_2_, p_229119_3_, p_229119_4_, p_229119_9_, p_229119_10_, 24, j + 1, true, p_229119_11_, p_229119_12_);
        }
    }

    public static void addVertexPair(IVertexBuilder p_229120_0_, Matrix4f p_229120_1_, int p_229120_2_, float p_229120_3_, float p_229120_4_, float p_229120_5_, float p_229120_6_, float p_229120_7_, int p_229120_8_, int p_229120_9_, boolean p_229120_10_, float p_229120_11_, float p_229120_12_) {
        float f = 0.5f;
        float f1 = 0.4f;
        float f2 = 0.3f;
        if (p_229120_9_ % 2 == 0) {
            f *= 0.7f;
            f1 *= 0.7f;
            f2 *= 0.7f;
        }
        float f3 = (float)p_229120_9_ / (float)p_229120_8_;
        float f4 = p_229120_3_ * f3;
        float f5 = p_229120_4_ > 0.0f ? p_229120_4_ * f3 * f3 : p_229120_4_ - p_229120_4_ * (1.0f - f3) * (1.0f - f3);
        float f6 = p_229120_5_ * f3;
        if (!p_229120_10_) {
            p_229120_0_.func_227888_a_(p_229120_1_, f4 + p_229120_11_, f5 + p_229120_6_ - p_229120_7_, f6 - p_229120_12_).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(0.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(p_229120_2_).func_181675_d();
        }
        p_229120_0_.func_227888_a_(p_229120_1_, f4 - p_229120_11_, f5 + p_229120_7_, f6 + p_229120_12_).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(1.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(p_229120_2_).func_181675_d();
        if (p_229120_10_) {
            p_229120_0_.func_227888_a_(p_229120_1_, f4 + p_229120_11_, f5 + p_229120_6_ - p_229120_7_, f6 - p_229120_12_).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(1.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(p_229120_2_).func_181675_d();
        }
    }

    protected static int getSkyLightLevel(Entity p_239381_1_, BlockPos p_239381_2_) {
        return p_239381_1_.field_70170_p.func_226658_a_(LightType.SKY, p_239381_2_);
    }

    protected static int getBlockLightLevel(Entity p_225624_1_, BlockPos p_225624_2_) {
        return p_225624_1_.func_70027_ad() ? 15 : p_225624_1_.field_70170_p.func_226658_a_(LightType.BLOCK, p_225624_2_);
    }
}

