/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.world.gen.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import quek.undergarden.registry.UGBlocks;

public class SmogVentFeature
extends Feature<NoFeatureConfig> {
    public SmogVentFeature(Codec<NoFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean place(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        while (worldIn.func_175623_d(pos) && pos.func_177956_o() > 2) {
            pos = pos.func_177977_b();
        }
        if (worldIn.func_175623_d(pos.func_177984_a()) && worldIn.func_180495_p(pos).func_177230_c() == UGBlocks.ASHEN_DEEPTURF_BLOCK.get()) {
            pos = pos.func_177981_b(rand.nextInt(4));
            int ventHeight = 7;
            int j = ventHeight / 4 + rand.nextInt(2);
            for (int k = 0; k < ventHeight; ++k) {
                float f = (1.0f - (float)k / (float)ventHeight) * (float)j;
                int l = MathHelper.func_76123_f((float)f);
                for (int i1 = -l; i1 <= l; ++i1) {
                    float f1 = (float)MathHelper.func_76130_a((int)i1) - 0.25f;
                    for (int j1 = -l; j1 <= l; ++j1) {
                        float f2 = (float)MathHelper.func_76130_a((int)j1) - 0.25f;
                        if ((i1 != 0 || j1 != 0) && f1 * f1 + f2 * f2 > f * f || (i1 == -l || i1 == l || j1 == -l || j1 == l) && rand.nextFloat() > 0.75f) continue;
                        BlockState blockstate = worldIn.func_180495_p(pos.func_177982_a(i1, k, j1));
                        Block block = blockstate.func_177230_c();
                        BlockPos ventPos = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 7, pos.func_177952_p());
                        if (blockstate.isAir((IBlockReader)worldIn, pos.func_177982_a(i1, k, j1)) || block == UGBlocks.ASHEN_DEEPTURF_BLOCK.get()) {
                            this.func_230367_a_((IWorldWriter)worldIn, pos.func_177982_a(i1, k, j1), ((Block)UGBlocks.DEPTHROCK.get()).func_176223_P());
                        }
                        this.func_230367_a_((IWorldWriter)worldIn, ventPos, ((Block)UGBlocks.SMOG_VENT.get()).func_176223_P());
                        if (k == 0 || l <= 1) continue;
                        blockstate = worldIn.func_180495_p(pos.func_177982_a(i1, -k, j1));
                        block = blockstate.func_177230_c();
                        if (!blockstate.isAir((IBlockReader)worldIn, pos.func_177982_a(i1, -k, j1)) && block != UGBlocks.ASHEN_DEEPTURF_BLOCK.get()) continue;
                        this.func_230367_a_((IWorldWriter)worldIn, pos.func_177982_a(i1, -k, j1), ((Block)UGBlocks.DEPTHROCK.get()).func_176223_P());
                    }
                }
            }
            int k1 = j - 1;
            block4: for (int l1 = -k1; l1 <= k1; ++l1) {
                for (int i2 = -k1; i2 <= k1; ++i2) {
                    BlockPos blockpos = pos.func_177982_a(l1, -1, i2);
                    BlockState blockstate1 = worldIn.func_180495_p(blockpos);
                    Block block1 = blockstate1.func_177230_c();
                    if (!blockstate1.isAir((IBlockReader)worldIn, blockpos) && block1 != UGBlocks.ASHEN_DEEPTURF_BLOCK.get() && block1 != UGBlocks.DEEPSOIL.get() && block1 != UGBlocks.DEPTHROCK.get()) continue block4;
                    worldIn.func_180501_a(blockpos, ((Block)UGBlocks.DEPTHROCK.get()).func_176223_P(), 1);
                }
            }
            return true;
        }
        return false;
    }
}

