/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.item.tool;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.ShootableItem;
import net.minecraft.item.UseAction;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.eventbus.api.Event;
import quek.undergarden.entity.projectile.SlingshotAmmoEntity;
import quek.undergarden.item.DepthrockPebbleItem;
import quek.undergarden.registry.UGItemGroups;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGSoundEvents;

public class SlingshotItem
extends ShootableItem {
    public SlingshotItem() {
        super(new Item.Properties().func_200917_a(1).func_200918_c(192).func_200916_a(UGItemGroups.GROUP).func_208103_a(Rarity.UNCOMMON));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.slingshot").func_240699_a_(TextFormatting.GRAY));
    }

    public Predicate<ItemStack> func_220004_b() {
        return stack -> stack.func_77973_b() == UGItems.DEPTHROCK_PEBBLE.get();
    }

    public int func_230305_d_() {
        return 10;
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityLiving;
            boolean creativeOrInfinity = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            ItemStack itemstack = player.func_213356_f(stack);
            int i = this.func_77626_a(stack) - timeLeft;
            if ((i = SlingshotItem.onArrowLoose(stack, worldIn, player, i, !itemstack.func_190926_b() || creativeOrInfinity)) < 0) {
                return;
            }
            if (!itemstack.func_190926_b() || creativeOrInfinity) {
                float f;
                if (itemstack.func_190926_b()) {
                    itemstack = new ItemStack((IItemProvider)UGItems.DEPTHROCK_PEBBLE.get());
                }
                if (!((double)(f = SlingshotItem.getProjectileVelocity(i)) < 0.1)) {
                    boolean flag1;
                    boolean bl = flag1 = player.field_71075_bZ.field_75098_d || itemstack.func_77973_b() instanceof DepthrockPebbleItem && ((DepthrockPebbleItem)itemstack.func_77973_b()).isInfinite(itemstack, stack, player);
                    if (!worldIn.field_72995_K) {
                        SlingshotAmmoEntity ammoEntity = new SlingshotAmmoEntity(worldIn, entityLiving);
                        ammoEntity.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, f * 3.0f, 1.0f);
                        stack.func_222118_a(1, (LivingEntity)player, entity -> player.func_213334_d(player.func_184600_cs()));
                        worldIn.func_217376_c((Entity)ammoEntity);
                    }
                    worldIn.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (SoundEvent)UGSoundEvents.SLINGSHOT_SHOOT.get(), SoundCategory.PLAYERS, 0.5f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                    if (!flag1 && !player.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                        if (itemstack.func_190926_b()) {
                            player.field_71071_by.func_184437_d(itemstack);
                        }
                    }
                    player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                }
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity player, Hand handIn) {
        ItemStack itemstack;
        boolean hasAmmo = !player.func_213356_f(itemstack = player.func_184586_b(handIn)).func_190926_b();
        ActionResult<ItemStack> ret = SlingshotItem.onArrowNock(itemstack, worldIn, player, handIn, hasAmmo);
        if (ret != null) {
            return ret;
        }
        if (!player.field_71075_bZ.field_75098_d && !hasAmmo) {
            return ActionResult.func_226251_d_((Object)itemstack);
        }
        player.func_184598_c(handIn);
        worldIn.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (SoundEvent)UGSoundEvents.SLINGSHOT_DRAW.get(), SoundCategory.PLAYERS, 0.5f, 1.0f);
        return ActionResult.func_226249_b_((Object)itemstack);
    }

    public static ActionResult<ItemStack> onArrowNock(ItemStack item, World world, PlayerEntity player, Hand hand, boolean hasAmmo) {
        ArrowNockEvent event = new ArrowNockEvent(player, item, hand, world, hasAmmo);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return new ActionResult(ActionResultType.FAIL, (Object)item);
        }
        return event.getAction();
    }

    public static int onArrowLoose(ItemStack stack, World world, PlayerEntity player, int charge, boolean hasAmmo) {
        ArrowLooseEvent event = new ArrowLooseEvent(player, stack, world, charge, hasAmmo);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return -1;
        }
        return event.getCharge();
    }

    public static float getProjectileVelocity(int charge) {
        float f = (float)charge / 5.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int func_77626_a(ItemStack stack) {
        return 36000;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b().func_206844_a((ITag)ItemTags.field_199905_b);
    }
}

