/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.BoostHelper;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEquipable;
import net.minecraft.entity.IRideable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import quek.undergarden.entity.rotspawn.AbstractRotspawnEntity;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGSoundEvents;

public class DwellerEntity
extends AnimalEntity
implements IRideable,
IEquipable {
    private static final DataParameter<Boolean> SADDLE = EntityDataManager.func_187226_a(DwellerEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> BOOST_TIME = EntityDataManager.func_187226_a(DwellerEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private final BoostHelper steering;

    public DwellerEntity(EntityType<? extends DwellerEntity> type, World worldIn) {
        super(type, worldIn);
        this.steering = new BoostHelper(this.field_70180_af, BOOST_TIME, SADDLE);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 2.5));
        this.field_70714_bg.func_75776_a(1, (Goal)new TemptGoal((CreatureEntity)this, 1.5, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)UGItems.UNDERBEANS.get(), (IItemProvider)UGItems.UNDERBEAN_STICK.get()}), false));
        this.field_70714_bg.func_75776_a(1, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(1, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, AbstractRotspawnEntity.class, 12.0f, 2.0, 2.5));
        this.field_70714_bg.func_75776_a(3, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return AnimalEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 15.0).func_233815_a_(Attributes.field_233821_d_, 0.15);
    }

    public static boolean canDwellerSpawn(EntityType<? extends AnimalEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_203425_a((Block)UGBlocks.DEEPTURF_BLOCK.get()) || worldIn.func_180495_p(pos.func_177977_b()).func_203425_a((Block)UGBlocks.ASHEN_DEEPTURF_BLOCK.get());
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)UGSoundEvents.DWELLER_AMBIENT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return (SoundEvent)UGSoundEvents.DWELLER_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)UGSoundEvents.DWELLER_DEATH.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a((SoundEvent)UGSoundEvents.DWELLER_STEP.get(), 0.15f, 0.5f);
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return (AgeableEntity)((EntityType)UGEntityTypes.DWELLER.get()).func_200721_a(this.field_70170_p);
    }

    public boolean func_70877_b(ItemStack stack) {
        return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)UGItems.UNDERBEANS.get()}).test(stack);
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        this.steering.func_233618_a_(nbt);
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.steering.func_233621_b_(nbt);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SADDLE, (Object)false);
        this.field_70180_af.func_187214_a(BOOST_TIME, (Object)0);
    }

    public void func_184206_a(DataParameter<?> data) {
        if (BOOST_TIME.equals(data) && this.field_70170_p.field_72995_K) {
            this.steering.func_233616_a_();
        }
        super.func_184206_a(data);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        boolean isFood = this.func_70877_b(player.func_184586_b(hand));
        if (!isFood && this.func_110257_ck() && !this.func_184207_aI() && !player.func_226563_dT_()) {
            if (!this.field_70170_p.field_72995_K) {
                player.func_184220_m((Entity)this);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        ActionResultType actionresulttype = super.func_230254_b_(player, hand);
        if (!actionresulttype.func_226246_a_()) {
            ItemStack itemstack = player.func_184586_b(hand);
            return itemstack.func_77973_b() == Items.field_151141_av ? itemstack.func_111282_a_(player, (LivingEntity)this, hand) : ActionResultType.PASS;
        }
        return actionresulttype;
    }

    public boolean func_230264_L__() {
        return this.func_70089_S() && !this.func_70631_g_();
    }

    public void func_230266_a_(@Nullable SoundCategory sound) {
        this.steering.func_233619_a_(true);
        if (sound != null) {
            this.field_70170_p.func_217384_a(null, (Entity)this, SoundEvents.field_187706_dO, sound, 0.5f, 1.0f);
        }
    }

    public boolean func_110257_ck() {
        return this.steering.func_233620_b_();
    }

    public boolean func_184762_da() {
        return this.steering.func_233617_a_(this.func_70681_au());
    }

    public void func_213352_e(Vector3d vector) {
        this.func_233622_a_((MobEntity)this, this.steering, vector);
    }

    public void func_230267_a__(Vector3d vector) {
        super.func_213352_e(vector);
    }

    public float func_230265_N__() {
        return (float)this.func_233637_b_(Attributes.field_233821_d_) * 1.1f;
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_82171_bF() {
        Entity entity = this.func_184179_bs();
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity playerentity = (PlayerEntity)entity;
        return playerentity.func_184614_ca().func_77973_b() == UGItems.UNDERBEAN_STICK.get() || playerentity.func_184592_cb().func_77973_b() == UGItems.UNDERBEAN_STICK.get();
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        if (this.func_110257_ck()) {
            this.func_199703_a((IItemProvider)Items.field_151141_av);
        }
    }

    public void func_184232_k(Entity passenger) {
        float ySin = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        float yCos = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        passenger.func_70107_b(this.func_226277_ct_() + (double)(0.5f * ySin), this.func_226278_cu_() + this.func_70042_X() + passenger.func_70033_W() - (double)0.1f, this.func_226281_cx_() - (double)(0.5f * yCos));
    }
}

