/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.worldgen.treeplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.treedecorator.TreeDecorator;
import net.minecraft.world.gen.treedecorator.TreeDecoratorType;
import twilightforest.worldgen.TwilightFeatures;

public class TrunkSideDecorator
extends TreeDecorator {
    public static final Codec<TrunkSideDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)64).fieldOf("placement_count").forGetter(o -> o.count), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability_of_placement").forGetter(o -> Float.valueOf(o.probability)), (App)BlockStateProvider.field_236796_a_.fieldOf("deco_provider").forGetter(o -> o.decoration)).apply((Applicative)instance, TrunkSideDecorator::new));
    private final int count;
    private final float probability;
    private final BlockStateProvider decoration;

    public TrunkSideDecorator(int count, float probability, BlockStateProvider decorator) {
        this.count = count;
        this.probability = probability;
        this.decoration = decorator;
    }

    protected TreeDecoratorType<TrunkSideDecorator> func_230380_a_() {
        return TwilightFeatures.TRUNKSIDE_DECORATOR;
    }

    public void func_225576_a_(ISeedReader world, Random random, List<BlockPos> trunkBlocks, List<BlockPos> leafBlocks, Set<BlockPos> decorations, MutableBoundingBox mutableBoundingBox) {
        int blockCount = trunkBlocks.size();
        for (int attempt = 0; attempt < this.count; ++attempt) {
            if (random.nextFloat() >= this.probability) continue;
            Rotation rot = Rotation.func_222466_a((Random)random);
            BlockPos pos = trunkBlocks.get(random.nextInt(blockCount)).func_177972_a(rot.func_185831_a(Direction.NORTH));
            if (!Feature.func_236297_b_((IWorldGenerationBaseReader)world, (BlockPos)pos)) continue;
            this.func_227423_a_((IWorldWriter)world, pos, this.decoration.func_225574_a_(random, pos).func_185907_a(rot), decorations, mutableBoundingBox);
        }
    }
}

