/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.worldgen.treeplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;
import twilightforest.util.FeatureUtil;
import twilightforest.worldgen.TwilightFeatures;
import twilightforest.worldgen.treeplacers.BranchesConfig;

public class HollowTrunkPlacer
extends AbstractTrunkPlacer {
    public static final Codec<HollowTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> HollowTrunkPlacer.func_236915_a_((RecordCodecBuilder.Instance)instance).and(instance.group((App)Codec.floatRange((float)1.0f, (float)16.0f).fieldOf("outside_radius").forGetter(o -> Float.valueOf(o.outerRadius)), (App)Codec.intRange((int)0, (int)8).fieldOf("random_add_radius").forGetter(o -> o.randomAddRadius), (App)BranchesConfig.CODEC.fieldOf("branch_config").forGetter(o -> o.branchesConfig), (App)BlockStateProvider.field_236796_a_.fieldOf("eastside_ladder").forGetter(o -> o.ladder))).apply((Applicative)instance, HollowTrunkPlacer::new));
    private final float outerRadius;
    private final int randomAddRadius;
    private final BranchesConfig branchesConfig;
    private final BlockStateProvider ladder;

    public HollowTrunkPlacer(int baseHeight, int randomHeightA, int randomHeightB, float outerRadius, int randomAddRadius, BranchesConfig branchesConfig, BlockStateProvider ladder) {
        super(baseHeight, randomHeightA, randomHeightB);
        this.outerRadius = outerRadius;
        this.randomAddRadius = randomAddRadius;
        this.branchesConfig = branchesConfig;
        this.ladder = ladder;
    }

    protected TrunkPlacerType<HollowTrunkPlacer> func_230381_a_() {
        return TwilightFeatures.HOLLOW_TRUNK;
    }

    public List<FoliagePlacer.Foliage> func_230382_a_(IWorldGenerationReader world, Random random, int height, BlockPos pos, Set<BlockPos> trunkBlocks, MutableBoundingBox mutableBoundingBox, BaseTreeFeatureConfig baseTreeFeatureConfig) {
        float additionalRadius = random.nextInt(this.randomAddRadius + 1);
        float outerRadius = this.outerRadius + additionalRadius;
        float hollowRadius = outerRadius / 2.0f;
        float outerRadiusSquared = outerRadius * outerRadius;
        float hollowRadiusSquared = hollowRadius * hollowRadius;
        ArrayList<FoliagePlacer.Foliage> leaves = new ArrayList<FoliagePlacer.Foliage>();
        this.buildTrunk(world, random, height, pos, trunkBlocks, mutableBoundingBox, baseTreeFeatureConfig, outerRadius, outerRadiusSquared, hollowRadiusSquared);
        this.buildFullCrown(world, random, pos, leaves, trunkBlocks, outerRadius, height, mutableBoundingBox, baseTreeFeatureConfig);
        return leaves;
    }

    private void buildTrunk(IWorldGenerationReader world, Random random, int height, BlockPos startPos, Set<BlockPos> trunkBlocks, MutableBoundingBox mutableBoundingBox, BaseTreeFeatureConfig baseTreeFeatureConfig, float outerRadius, float outerRadiusSquared, float hollowRadiusSquared) {
        boolean notHollow = false;
        int z = 0;
        while ((float)z <= outerRadius) {
            for (int x = (int)outerRadius; x >= 0; --x) {
                int dist = x * x + z * z;
                if (!((float)dist < outerRadiusSquared)) continue;
                boolean trunkDelta = notHollow;
                notHollow = (float)dist >= hollowRadiusSquared;
                for (int y = 0; y <= height; ++y) {
                    BlockPos dPos = startPos.func_177982_a(x, y, z);
                    if (trunkDelta && !notHollow) {
                        world.func_180501_a(dPos, this.ladder.func_225574_a_(random, dPos), 3);
                        BlockPos opposite = startPos.func_177982_a(x, y, -z);
                        if (!dPos.equals((Object)opposite)) {
                            world.func_180501_a(opposite, this.ladder.func_225574_a_(random, opposite), 3);
                        }
                    }
                    if (!notHollow) continue;
                    HollowTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)random, (BlockPos)dPos, trunkBlocks, (MutableBoundingBox)mutableBoundingBox, (BaseTreeFeatureConfig)baseTreeFeatureConfig);
                    HollowTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)random, (BlockPos)startPos.func_177982_a(-x, y, -z), trunkBlocks, (MutableBoundingBox)mutableBoundingBox, (BaseTreeFeatureConfig)baseTreeFeatureConfig);
                    HollowTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)random, (BlockPos)startPos.func_177982_a(-z, y, x), trunkBlocks, (MutableBoundingBox)mutableBoundingBox, (BaseTreeFeatureConfig)baseTreeFeatureConfig);
                    HollowTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)random, (BlockPos)startPos.func_177982_a(z, y, -x), trunkBlocks, (MutableBoundingBox)mutableBoundingBox, (BaseTreeFeatureConfig)baseTreeFeatureConfig);
                }
            }
            ++z;
        }
    }

    protected void buildFullCrown(IWorldGenerationReader world, Random random, BlockPos pos, List<FoliagePlacer.Foliage> leaves, Set<BlockPos> branch, float diameter, int height, MutableBoundingBox mbb, BaseTreeFeatureConfig config) {
        int crownRadius = (int)(diameter * 4.0f + 4.0f);
        int bvar = (int)(diameter + 2.0f);
        this.buildBranchRing(world, random, pos, leaves, branch, diameter, height - crownRadius, 0, crownRadius, 0.35, bvar, bvar + 2, 2, true, mbb, config);
        this.buildBranchRing(world, random, pos, leaves, branch, diameter, height - (crownRadius >> 1), 0, crownRadius, 0.28, bvar, bvar + 2, 1, true, mbb, config);
        this.buildBranchRing(world, random, pos, leaves, branch, diameter, height, 0, crownRadius, 0.15, 2, 4, 2, true, mbb, config);
        this.buildBranchRing(world, random, pos, leaves, branch, diameter, height, 0, crownRadius >> 1, 0.05, bvar, bvar + 2, 1, true, mbb, config);
    }

    protected void buildBranchRing(IWorldGenerationReader world, Random random, BlockPos pos, List<FoliagePlacer.Foliage> leaves, Set<BlockPos> branch, float diameter, int branchHeight, int heightVar, float length, double tilt, int minBranches, int maxBranches, int size, boolean leafy, MutableBoundingBox mbb, BaseTreeFeatureConfig config) {
        int numBranches = random.nextInt(maxBranches - minBranches) + minBranches;
        double branchRotation = 1.0 / (double)(numBranches + 1);
        double branchOffset = random.nextDouble();
        for (int i = 0; i <= numBranches; ++i) {
            int dHeight = heightVar > 0 ? branchHeight - heightVar + random.nextInt(2 * heightVar) : branchHeight;
            if (size == 2) {
                this.makeLargeBranch(world, random, pos, leaves, branch, diameter, dHeight, length, (double)i * branchRotation + branchOffset, tilt, leafy, mbb, config);
                continue;
            }
            if (size == 1) {
                this.makeMedBranch(world, random, pos, leaves, branch, diameter, dHeight, length, (double)i * branchRotation + branchOffset, tilt, leafy, mbb, config);
                continue;
            }
            if (size == 3) {
                this.makeRoot(world, random, pos, diameter, dHeight, length, (double)i * branchRotation + branchOffset, tilt, config);
                continue;
            }
            this.makeSmallBranch(world, random, pos, leaves, branch, diameter, dHeight, length, (double)i * branchRotation + branchOffset, tilt, leafy, mbb, config);
        }
    }

    protected void makeLargeBranch(IWorldGenerationReader world, Random random, BlockPos pos, List<FoliagePlacer.Foliage> leaves, Set<BlockPos> branch, float diameter, int branchHeight, float length, double angle, double tilt, boolean leafy, MutableBoundingBox mbb, BaseTreeFeatureConfig config) {
        BlockPos src = FeatureUtil.translate(pos.func_177981_b(branchHeight), diameter, angle, 0.5);
        this.makeLargeBranch(world, random, src, leaves, branch, length, angle, tilt, leafy, mbb, config);
    }

    protected void makeLargeBranch(IWorldGenerationReader world, Random random, BlockPos src, List<FoliagePlacer.Foliage> leaves, Set<BlockPos> branch, float length, double angle, double tilt, boolean leafy, MutableBoundingBox mbb, BaseTreeFeatureConfig config) {
        BlockPos dest = FeatureUtil.translate(src, length, angle, tilt);
        FeatureUtil.drawBresenhamBranch(world, random, src, dest, branch, mbb, config);
        int reinforcements = random.nextInt(3);
        for (int i = 0; i <= reinforcements; ++i) {
            int vx = (i & 2) == 0 ? 1 : 0;
            int vy = (i & 1) == 0 ? 1 : -1;
            int vz = (i & 2) == 0 ? 0 : 1;
            FeatureUtil.drawBresenhamBranch(world, random, src.func_177982_a(vx, vy, vz), dest, branch, mbb, config);
        }
        if (leafy) {
            leaves.add(new FoliagePlacer.Foliage(dest.func_177984_a(), 3, false));
        }
        int numMedBranches = random.nextInt((int)(length / 6.0f)) + random.nextInt(2) + 1;
        for (int i = 0; i <= numMedBranches; ++i) {
            double outVar = random.nextDouble() * 0.3 + 0.3;
            double angleVar = random.nextDouble() * 0.225 * ((i & 1) == 0 ? 1.0 : -1.0);
            BlockPos bsrc = FeatureUtil.translate(src, (double)length * outVar, angle, tilt);
            this.makeMedBranch(world, random, bsrc, leaves, branch, (double)length * 0.6, angle + angleVar, tilt, leafy, mbb, config);
        }
        int numSmallBranches = random.nextInt(2) + 1;
        for (int i = 0; i <= numSmallBranches; ++i) {
            double outVar = random.nextDouble() * 0.25 + 0.25;
            double angleVar = random.nextDouble() * 0.25 * ((i & 1) == 0 ? 1.0 : -1.0);
            BlockPos bsrc = FeatureUtil.translate(src, (double)length * outVar, angle, tilt);
            this.makeSmallBranch(world, random, bsrc, leaves, branch, Math.max((double)length * 0.3, 2.0), angle + angleVar, tilt, leafy, mbb, config);
        }
    }

    protected void makeMedBranch(IWorldGenerationReader world, Random random, BlockPos pos, List<FoliagePlacer.Foliage> leaves, Set<BlockPos> branch, float diameter, int branchHeight, double length, double angle, double tilt, boolean leafy, MutableBoundingBox mbb, BaseTreeFeatureConfig config) {
        BlockPos src = FeatureUtil.translate(pos.func_177981_b(branchHeight), diameter, angle, 0.5);
        this.makeMedBranch(world, random, src, leaves, branch, length, angle, tilt, leafy, mbb, config);
    }

    protected void makeMedBranch(IWorldGenerationReader world, Random random, BlockPos src, List<FoliagePlacer.Foliage> leaves, Set<BlockPos> branch, double length, double angle, double tilt, boolean leafy, MutableBoundingBox mbb, BaseTreeFeatureConfig config) {
        BlockPos dest = FeatureUtil.translate(src, length, angle, tilt);
        FeatureUtil.drawBresenhamBranch(world, random, src, dest, branch, mbb, config);
        if (leafy) {
            leaves.add(new FoliagePlacer.Foliage(dest, 2, false));
        }
        int numShoots = random.nextInt(2) + 1;
        double angleInc = 0.8 / (double)numShoots;
        for (int i = 0; i <= numShoots; ++i) {
            double angleVar = angleInc * (double)i - 0.4;
            double outVar = random.nextDouble() * 0.8 + 0.2;
            double tiltVar = random.nextDouble() * 0.75 + 0.15;
            BlockPos bsrc = FeatureUtil.translate(src, length * outVar, angle, tilt);
            double slength = length * 0.4;
            this.makeSmallBranch(world, random, bsrc, leaves, branch, slength, angle + angleVar, tilt * tiltVar, leafy, mbb, config);
        }
    }

    protected void makeSmallBranch(IWorldGenerationReader world, Random random, BlockPos src, List<FoliagePlacer.Foliage> leaves, Set<BlockPos> branch, double length, double angle, double tilt, boolean leafy, MutableBoundingBox mbb, BaseTreeFeatureConfig config) {
        BlockPos dest = FeatureUtil.translate(src, length, angle, tilt);
        FeatureUtil.drawBresenhamBranch(world, random, src, dest, branch, mbb, config);
        if (leafy) {
            leaves.add(new FoliagePlacer.Foliage(dest, random.nextInt(2) + 1, false));
        }
    }

    protected void makeSmallBranch(IWorldGenerationReader world, Random random, BlockPos pos, List<FoliagePlacer.Foliage> leaves, Set<BlockPos> branch, float diameter, int branchHeight, double length, double angle, double tilt, boolean leafy, MutableBoundingBox mbb, BaseTreeFeatureConfig config) {
        BlockPos src = FeatureUtil.translate(pos.func_177981_b(branchHeight), diameter, angle, 0.5);
        this.makeSmallBranch(world, random, src, leaves, branch, length, angle, tilt, leafy, mbb, config);
    }

    protected void makeRoot(IWorldGenerationReader world, Random random, BlockPos pos, float diameter, int branchHeight, double length, double angle, double tilt, BaseTreeFeatureConfig config) {
        BlockPos src = FeatureUtil.translate(pos.func_177981_b(branchHeight), diameter, angle, 0.5);
        BlockPos dest = FeatureUtil.translate(src, length, angle, tilt);
        BlockPos[] lineArray = FeatureUtil.getBresenhamArrays(src, dest);
        boolean stillAboveGround = true;
        for (BlockPos coord : lineArray) {
            if (stillAboveGround && FeatureUtil.hasAirAround(world, coord)) {
                world.func_180501_a(coord, config.field_227368_m_.func_225574_a_(random, coord), 3);
                world.func_180501_a(coord.func_177977_b(), config.field_227368_m_.func_225574_a_(random, coord.func_177977_b()), 3);
                continue;
            }
            world.func_180501_a(coord, config.field_227368_m_.func_225574_a_(random, coord), 3);
            world.func_180501_a(coord.func_177977_b(), config.field_227368_m_.func_225574_a_(random, coord.func_177977_b()), 3);
            stillAboveGround = false;
        }
    }
}

