/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.worldgen.structures;

import com.google.common.collect.ImmutableSet;
import com.google.common.math.StatsAccumulator;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.state.Property;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import org.apache.commons.lang3.tuple.Pair;
import twilightforest.TwilightForestMod;
import twilightforest.entity.TFEntities;
import twilightforest.entity.WraithEntity;
import twilightforest.loot.TFTreasure;
import twilightforest.structures.RandomizedTemplateProcessor;
import twilightforest.structures.TFStructureProcessors;

public class TFGenGraveyard
extends Feature<NoFeatureConfig> {
    private static final ResourceLocation GRAVEYARD = TwilightForestMod.prefix("landscape/graveyard/graveyard");
    private static final ResourceLocation TRAP = TwilightForestMod.prefix("landscape/graveyard/grave_trap");
    private static final ImmutableSet<Material> MATERIAL_WHITELIST = ImmutableSet.of((Object)Material.field_151578_c, (Object)Material.field_151577_b, (Object)Material.field_151584_j, (Object)Material.field_151575_d, (Object)Material.field_151585_k, (Object)Material.field_151576_e, (Object[])new Material[0]);

    public TFGenGraveyard(Codec<NoFeatureConfig> config) {
        super(config);
    }

    private static boolean offsetToAverageGroundLevel(ISeedReader world, BlockPos.Mutable startPos, BlockPos size) {
        StatsAccumulator heights = new StatsAccumulator();
        for (int dx = 0; dx < size.func_177958_n(); ++dx) {
            for (int dz = 0; dz < size.func_177952_p(); ++dz) {
                int y;
                int x = startPos.func_177958_n() + dx;
                int z = startPos.func_177952_p() + dz;
                for (y = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, x, z); y >= 0; --y) {
                    BlockState state = world.func_180495_p(new BlockPos(x, y, z));
                    if (TFGenGraveyard.isBlockNotOk(state)) {
                        return false;
                    }
                    if (TFGenGraveyard.isBlockOk(state)) break;
                }
                if (y < 0) {
                    return false;
                }
                heights.add((double)y);
            }
        }
        if (heights.populationStandardDeviation() > 2.0) {
            return false;
        }
        int baseY = (int)Math.round(heights.mean());
        int maxY = (int)heights.max();
        startPos.func_185336_p(baseY);
        return TFGenGraveyard.isAreaClear((IBlockReader)world, startPos.func_177981_b(maxY - baseY + 1), startPos.func_177971_a((Vector3i)size));
    }

    private static boolean isAreaClear(IBlockReader world, BlockPos min, BlockPos max) {
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)min, (BlockPos)max)) {
            Material material = world.func_180495_p(pos).func_185904_a();
            if (material.func_76222_j() || MATERIAL_WHITELIST.contains((Object)material) || material.func_76224_d()) continue;
            return false;
        }
        return true;
    }

    private static boolean isBlockOk(BlockState state) {
        Material material = state.func_185904_a();
        return material == Material.field_151576_e || material == Material.field_151578_c || material == Material.field_151577_b || material == Material.field_151595_p;
    }

    private static boolean isBlockNotOk(BlockState state) {
        Material material = state.func_185904_a();
        return material == Material.field_151586_h || material == Material.field_151587_i || state.func_177230_c() == Blocks.field_150357_h;
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        int flags = 19;
        Random random = world.func_201674_k();
        TemplateManager templatemanager = world.func_201672_e().func_73046_m().func_240792_aT_();
        Template base = templatemanager.func_200219_b(GRAVEYARD);
        if (base == null) {
            return false;
        }
        ArrayList<Pair> graves = new ArrayList<Pair>();
        Template trap = templatemanager.func_200219_b(TRAP);
        if (trap == null) {
            return false;
        }
        for (GraveType type : GraveType.VALUES) {
            Template grave = templatemanager.func_200219_b(type.RL);
            if (grave == null) {
                return false;
            }
            graves.add(Pair.of((Object)((Object)type), (Object)grave));
        }
        Rotation[] rotations = Rotation.values();
        Rotation rotation = rotations[random.nextInt(rotations.length)];
        Mirror[] mirrors = Mirror.values();
        Mirror mirror = mirrors[random.nextInt(mirrors.length + 1) % mirrors.length];
        BlockPos transformedSize = base.func_186257_a(rotation);
        BlockPos transformedGraveSize = ((Template)((Pair)graves.get(0)).getValue()).func_186257_a(rotation);
        ChunkPos chunkpos = new ChunkPos(pos.func_177982_a(-8, 0, -8));
        ChunkPos chunkendpos = new ChunkPos(pos.func_177982_a(-8, 0, -8).func_177971_a((Vector3i)transformedSize));
        MutableBoundingBox structureboundingbox = new MutableBoundingBox(chunkpos.func_180334_c() + 8, 0, chunkpos.func_180333_d() + 8, chunkendpos.func_180332_e() + 8, 255, chunkendpos.func_180330_f() + 8);
        PlacementSettings placementsettings = new PlacementSettings().func_186214_a(mirror).func_186220_a(rotation).func_186223_a(structureboundingbox).func_189950_a(random);
        BlockPos posSnap = chunkpos.func_206849_h().func_177982_a(8, pos.func_177956_o() - 1, 8);
        BlockPos.Mutable startPos = new BlockPos.Mutable(posSnap.func_177958_n(), posSnap.func_177956_o(), posSnap.func_177952_p());
        if (!TFGenGraveyard.offsetToAverageGroundLevel(world, startPos, transformedSize)) {
            return false;
        }
        BlockPos placementPos = base.func_189961_a((BlockPos)startPos, mirror, rotation).func_177982_a(1, -1, 0);
        BlockPos size = transformedSize.func_177982_a(-1, 0, -1);
        BlockPos graveSize = transformedGraveSize.func_177982_a(-1, 0, -1);
        base.func_237146_a_((IServerWorld)world, placementPos, placementPos, placementsettings.func_215222_a((StructureProcessor)new WebTemplateProcessor(0.2f)), random, flags);
        ArrayList data = new ArrayList(base.func_215381_a(placementPos, placementsettings, Blocks.field_185779_df));
        BlockPos start = startPos.func_177982_a(1, 1, 0);
        BlockPos end = start.func_177982_a(size.func_177958_n(), 0, size.func_177952_p());
        for (int x = 1; x <= size.func_177958_n() - 1; ++x) {
            for (int z = 1; z <= size.func_177952_p() - 1; ++z) {
                if (!world.func_175623_d(start.func_177982_a(x, 0, z)) || rand.nextInt(12) != 0) continue;
                world.func_180501_a(start.func_177982_a(x, 0, z), Blocks.field_196553_aF.func_176223_P(), flags);
            }
        }
        BlockPos inner = start.func_177982_a(2, 0, 2);
        BlockPos bound = end.func_177982_a(-2, 0, -2);
        BlockPos innerSize = new BlockPos(bound.func_177958_n() - inner.func_177958_n(), bound.func_177956_o() - inner.func_177956_o(), bound.func_177952_p() - inner.func_177952_p());
        BlockPos fixed = inner.func_177982_a((rotation == Rotation.CLOCKWISE_180 ? graveSize.func_177958_n() : 0) + (mirror == Mirror.FRONT_BACK ? transformedGraveSize.func_177958_n() - 1 : 0) * (rotation == Rotation.CLOCKWISE_180 ? -1 : 1), 0, (rotation == Rotation.COUNTERCLOCKWISE_90 ? graveSize.func_177952_p() : 0) + (mirror == Mirror.FRONT_BACK ? transformedGraveSize.func_177952_p() - 1 : 0) * (rotation == Rotation.COUNTERCLOCKWISE_90 ? -1 : 1));
        BlockPos fixedSize = innerSize.func_177982_a(-graveSize.func_177958_n(), 0, -graveSize.func_177952_p());
        BlockPos chestloc = new BlockPos(random.nextInt(2) - (mirror == Mirror.FRONT_BACK ? 1 : 0), 1, 0).func_190942_a(rotation);
        for (int x = 0; x <= fixedSize.func_177958_n(); x += rotation == Rotation.CLOCKWISE_90 || rotation == Rotation.COUNTERCLOCKWISE_90 ? 2 : 5) {
            for (int z = 0; z <= fixedSize.func_177952_p(); z += rotation == Rotation.NONE || rotation == Rotation.CLOCKWISE_180 ? 2 : 5) {
                if (x == innerSize.func_177958_n() / 2 || z == innerSize.func_177952_p() / 2) continue;
                BlockPos placement = fixed.func_177982_a(x, -2, z);
                Pair grave = (Pair)graves.get(rand.nextInt(graves.size()));
                ((Template)grave.getValue()).func_237146_a_((IServerWorld)world, placement, placement, placementsettings, random, flags);
                data.addAll(((Template)grave.getValue()).func_215381_a(placement, placementsettings, Blocks.field_185779_df));
                if (grave.getKey() != GraveType.Full || !random.nextBoolean()) continue;
                if (random.nextInt(3) == 0) {
                    placement = placement.func_177971_a((Vector3i)new BlockPos(mirror == Mirror.FRONT_BACK ? 1 : -1, 0, mirror == Mirror.LEFT_RIGHT ? 1 : -1).func_190942_a(rotation));
                    trap.func_237146_a_((IServerWorld)world, placement, placement, placementsettings, random, flags);
                }
                data.addAll(trap.func_215381_a(placementPos, placementsettings, Blocks.field_185779_df));
                if (world.func_180501_a(placement.func_177971_a((Vector3i)chestloc), ((BlockState)Blocks.field_150447_bR.func_176223_P().func_206870_a((Property)ChestBlock.field_176459_a, (Comparable)Direction.WEST)).func_185907_a(rotation).func_185902_a(mirror), flags)) {
                    TFTreasure.graveyard.generateChestContents(world, placement.func_177971_a((Vector3i)chestloc));
                    world.func_180501_a(placement.func_177971_a((Vector3i)chestloc).func_177977_b(), Blocks.field_150341_Y.func_176223_P(), 3);
                }
                WraithEntity wraith = new WraithEntity(TFEntities.wraith, (World)world.func_201672_e());
                wraith.func_70107_b(placement.func_177958_n(), placement.func_177956_o(), placement.func_177952_p());
                world.func_217376_c((Entity)wraith);
            }
        }
        data.forEach(info -> {
            if (info.field_186244_c != null && StructureMode.valueOf((String)info.field_186244_c.func_74779_i("mode")) == StructureMode.DATA) {
                String s = info.field_186244_c.func_74779_i("metadata");
                BlockPos p = info.field_186242_a;
                if ("spawner".equals(s)) {
                    MobSpawnerTileEntity ms;
                    world.func_217377_a(p, false);
                    if (random.nextInt(4) == 0 && world.func_180501_a(p, Blocks.field_150474_ac.func_176223_P(), 3) && (ms = (MobSpawnerTileEntity)world.func_175625_s(p)) != null) {
                        ms.func_145881_a().func_200876_a(TFEntities.rising_zombie);
                    }
                }
            }
        });
        return true;
    }

    public static class WebTemplateProcessor
    extends RandomizedTemplateProcessor {
        public static final Codec<WebTemplateProcessor> codecWebProcessor = Codec.FLOAT.fieldOf("integrity").orElse((Object)Float.valueOf(1.0f)).xmap(WebTemplateProcessor::new, obj -> Float.valueOf(obj.integrity)).codec();

        public WebTemplateProcessor(float integrity) {
            super(integrity);
        }

        protected IStructureProcessorType<?> func_215192_a() {
            return TFStructureProcessors.WEB;
        }

        @Nullable
        public Template.BlockInfo process(IWorldReader worldIn, BlockPos pos, BlockPos piecepos, Template.BlockInfo p_process_3_, Template.BlockInfo blockInfo, PlacementSettings settings, @Nullable Template template) {
            return blockInfo.field_186243_b.func_177230_c() == Blocks.field_196658_i ? blockInfo : (settings.func_189947_a(pos).nextInt(5) == 0 ? new Template.BlockInfo(pos, Blocks.field_196553_aF.func_176223_P(), null) : blockInfo);
        }
    }

    private static enum GraveType {
        Full(TwilightForestMod.prefix("landscape/graveyard/grave_full")),
        Upper(TwilightForestMod.prefix("landscape/graveyard/grave_upper")),
        Lower(TwilightForestMod.prefix("landscape/graveyard/grave_lower"));

        private static final GraveType[] VALUES;
        private final ResourceLocation RL;

        private GraveType(ResourceLocation rl) {
            this.RL = rl;
        }

        static {
            VALUES = GraveType.values();
        }
    }
}

