/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import twilightforest.block.TFBlocks;

public class TFGenThorns
extends Feature<NoFeatureConfig> {
    private static final int MAX_SPREAD = 7;
    private static final int CHANCE_OF_BRANCH = 3;
    private static final int CHANCE_OF_LEAF = 3;
    private static final int CHANCE_LEAF_IS_ROSE = 50;

    public TFGenThorns(Codec<NoFeatureConfig> config) {
        super(config);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        int nextLength = 2 + rand.nextInt(4);
        int maxLength = 2 + rand.nextInt(4) + rand.nextInt(4) + rand.nextInt(4);
        this.placeThorns(world, rand, pos, nextLength, Direction.UP, maxLength, pos);
        return true;
    }

    private void placeThorns(ISeedReader world, Random rand, BlockPos pos, int length, Direction dir, int maxLength, BlockPos oPos) {
        Direction nextDir;
        int middle;
        boolean complete = false;
        for (int i = 0; i < length; ++i) {
            BlockPos dPos = pos.func_177967_a(dir, i);
            if (!world.func_175710_j(pos) || Math.abs(dPos.func_177958_n() - oPos.func_177958_n()) >= 7 || Math.abs(dPos.func_177952_p() - oPos.func_177952_p()) >= 7 || !this.canPlaceThorns((IWorld)world, dPos)) break;
            world.func_180501_a(dPos, (BlockState)((Block)TFBlocks.brown_thorns.get()).func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)dir.func_176740_k()), 3);
            if (i != length - 1) continue;
            complete = true;
            if (rand.nextInt(3) != 0 || !world.func_175623_d(dPos.func_177972_a(dir))) continue;
            if (rand.nextInt(50) > 0) {
                world.func_180501_a(dPos.func_177972_a(dir), ((Block)TFBlocks.thorn_leaves.get()).func_176223_P(), 3);
                continue;
            }
            world.func_180501_a(dPos.func_177972_a(dir), ((Block)TFBlocks.thorn_rose.get()).func_176223_P(), 3);
        }
        if (complete && maxLength > 1) {
            Direction nextDir2 = Direction.func_239631_a_((Random)rand);
            BlockPos nextPos = pos.func_177967_a(dir, length - 1).func_177972_a(nextDir2);
            int nextLength = 1 + rand.nextInt(maxLength);
            this.placeThorns(world, rand, nextPos, nextLength, nextDir2, maxLength - 1, oPos);
        }
        if (complete && length > 3 && rand.nextInt(3) == 0) {
            middle = rand.nextInt(length);
            nextDir = Direction.func_239631_a_((Random)rand);
            BlockPos nextPos = pos.func_177967_a(dir, middle).func_177972_a(nextDir);
            int nextLength = 1 + rand.nextInt(maxLength);
            this.placeThorns(world, rand, nextPos, nextLength, nextDir, maxLength - 1, oPos);
        }
        if (complete && length > 3 && rand.nextInt(3) == 0) {
            middle = rand.nextInt(length);
            nextDir = Direction.func_239631_a_((Random)rand);
            BlockPos nextPos = pos.func_177967_a(dir, middle).func_177972_a(nextDir);
            if (world.func_175623_d(nextPos)) {
                world.func_180501_a(nextPos, ((Block)TFBlocks.thorn_leaves.get()).func_176223_P(), 3);
            }
        }
    }

    private boolean canPlaceThorns(IWorld world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockReader)world, pos) || state.func_177230_c().func_203417_a((ITag)BlockTags.field_206952_E);
    }
}

