/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.stronghold;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.StairsBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import twilightforest.TFFeature;
import twilightforest.structures.stronghold.StrongholdPieces;
import twilightforest.structures.stronghold.StructureTFStrongholdComponent;

public class StrongholdCrossingComponent
extends StructureTFStrongholdComponent {
    public StrongholdCrossingComponent(TemplateManager manager, CompoundNBT nbt) {
        super(StrongholdPieces.TFSCr, nbt);
    }

    public StrongholdCrossingComponent(TFFeature feature, int i, Direction facing, int x, int y, int z) {
        super(StrongholdPieces.TFSCr, feature, i, facing, x, y, z);
    }

    @Override
    public MutableBoundingBox generateBoundingBox(Direction facing, int x, int y, int z) {
        return StructureTFStrongholdComponent.getComponentToAddBoundingBox(x, y, z, -13, -1, 0, 18, 7, 18, facing);
    }

    @Override
    public void func_74861_a(StructurePiece parent, List<StructurePiece> list, Random random) {
        super.func_74861_a(parent, list, random);
        this.addDoor(13, 1, 0);
        this.addNewComponent(parent, list, random, Rotation.NONE, 4, 1, 18);
        this.addNewComponent(parent, list, random, Rotation.CLOCKWISE_90, -1, 1, 13);
        this.addNewComponent(parent, list, random, Rotation.COUNTERCLOCKWISE_90, 18, 1, 4);
    }

    public boolean func_230383_a_(ISeedReader world, StructureManager manager, ChunkGenerator generator, Random rand, MutableBoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        this.placeStrongholdWalls(world, sbb, 0, 0, 0, 17, 6, 17, rand, this.deco.randomBlocks);
        this.placeCornerStatue(world, 2, 1, 2, 0, sbb);
        this.placeCornerStatue(world, 15, 1, 15, 3, sbb);
        this.fillBlocksRotated(world, sbb, 8, 1, 8, 9, 5, 9, this.deco.pillarState, Rotation.NONE);
        this.placeWallStatue(world, 8, 1, 7, Rotation.NONE, sbb);
        this.placeWallStatue(world, 7, 1, 9, Rotation.COUNTERCLOCKWISE_90, sbb);
        this.placeWallStatue(world, 9, 1, 10, Rotation.CLOCKWISE_180, sbb);
        this.placeWallStatue(world, 10, 1, 8, Rotation.CLOCKWISE_90, sbb);
        this.placeTableAndChairs(world, sbb, Rotation.NONE);
        this.placeTableAndChairs(world, sbb, Rotation.CLOCKWISE_90);
        this.placeTableAndChairs(world, sbb, Rotation.CLOCKWISE_180);
        this.placeTableAndChairs(world, sbb, Rotation.COUNTERCLOCKWISE_90);
        this.placeDoors(world, sbb);
        return true;
    }

    private void placeTableAndChairs(ISeedReader world, MutableBoundingBox sbb, Rotation rotation) {
        BlockState oakStairs = Blocks.field_150476_ad.func_176223_P();
        this.setBlockStateRotated(world, StrongholdCrossingComponent.getStairState(oakStairs, Rotation.NONE.func_185831_a(Direction.WEST), true), 5, 1, 3, rotation, sbb);
        this.setBlockStateRotated(world, StrongholdCrossingComponent.getStairState(oakStairs, Rotation.COUNTERCLOCKWISE_90.func_185831_a(Direction.WEST), true), 5, 1, 4, rotation, sbb);
        this.setBlockStateRotated(world, StrongholdCrossingComponent.getStairState(oakStairs, Rotation.CLOCKWISE_90.func_185831_a(Direction.WEST), true), 6, 1, 3, rotation, sbb);
        this.setBlockStateRotated(world, StrongholdCrossingComponent.getStairState(oakStairs, Rotation.CLOCKWISE_180.func_185831_a(Direction.WEST), true), 6, 1, 4, rotation, sbb);
        this.setBlockStateRotated(world, (BlockState)Blocks.field_150485_bF.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Rotation.COUNTERCLOCKWISE_90.func_185831_a(Direction.WEST)), 5, 1, 2, rotation, sbb);
        this.setBlockStateRotated(world, (BlockState)Blocks.field_150485_bF.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Rotation.NONE.func_185831_a(Direction.WEST)), 7, 1, 3, rotation, sbb);
        this.setBlockStateRotated(world, (BlockState)Blocks.field_150485_bF.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Rotation.CLOCKWISE_90.func_185831_a(Direction.WEST)), 6, 1, 5, rotation, sbb);
        this.setBlockStateRotated(world, (BlockState)Blocks.field_150485_bF.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Rotation.CLOCKWISE_180.func_185831_a(Direction.WEST)), 4, 1, 4, rotation, sbb);
    }
}

