/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.mushroomtower;

import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import twilightforest.TFFeature;
import twilightforest.structures.TFStructureComponentOld;
import twilightforest.structures.lichtower.TowerRoofComponent;
import twilightforest.structures.lichtower.TowerWingComponent;
import twilightforest.structures.mushroomtower.MushroomTowerPieces;

public class TowerRoofMushroomComponent
extends TowerRoofComponent {
    public TowerRoofMushroomComponent(TemplateManager manager, CompoundNBT nbt) {
        super(MushroomTowerPieces.TFMTRoofMush, nbt);
    }

    public TowerRoofMushroomComponent(TFFeature feature, int i, TowerWingComponent wing, float pHang) {
        super(MushroomTowerPieces.TFMTRoofMush, feature, i);
        this.height = wing.size;
        int overhang = (int)((float)this.height * pHang);
        this.size = this.height + overhang * 2;
        this.func_186164_a(Direction.SOUTH);
        this.field_74887_e = new MutableBoundingBox(wing.func_74874_b().field_78897_a - overhang, wing.func_74874_b().field_78894_e + 2, wing.func_74874_b().field_78896_c - overhang, wing.func_74874_b().field_78893_d + overhang, wing.func_74874_b().field_78894_e + this.height + 1, wing.func_74874_b().field_78892_f + overhang);
    }

    public void func_74861_a(StructurePiece parent, List<StructurePiece> list, Random rand) {
        if (parent != null && parent instanceof TFStructureComponentOld) {
            this.deco = ((TFStructureComponentOld)parent).deco;
        }
    }

    @Override
    public boolean func_230383_a_(ISeedReader world, StructureManager manager, ChunkGenerator generator, Random rand, MutableBoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        for (int y = 0; y <= this.height; ++y) {
            int radius = (int)(MathHelper.func_76126_a((float)(((float)y + (float)this.height / 1.2f) / ((float)this.height * 2.05f) * 3.14f)) * (float)this.size / 2.0f);
            int hollow = MathHelper.func_76141_d((float)((float)radius * 0.9f));
            if (this.height - y < 3) {
                hollow = -1;
            }
            this.makeCircle(world, y, radius, hollow, sbb);
        }
        return true;
    }

    private void makeCircle(ISeedReader world, int y, int radius, int hollow, MutableBoundingBox sbb) {
        int cx = this.size / 2;
        int cz = this.size / 2;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                float dist = MathHelper.func_76129_c((float)(dx * dx + dz * dz));
                if (!(dist <= (float)radius + 0.5f)) continue;
                if (dist > (float)hollow) {
                    this.func_175811_a(world, this.deco.accentState, dx + cx, y, dz + cz, sbb);
                    continue;
                }
                this.func_175811_a(world, this.deco.accentState.func_177230_c().func_176223_P(), dx + cx, y, dz + cz, sbb);
            }
        }
    }
}

