/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.mushroomtower;

import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import twilightforest.TFFeature;
import twilightforest.TwilightForestMod;
import twilightforest.structures.TFStructureComponentOld;
import twilightforest.structures.mushroomtower.MushroomTowerDecorator;
import twilightforest.structures.mushroomtower.MushroomTowerPieces;
import twilightforest.structures.mushroomtower.MushroomTowerWingComponent;
import twilightforest.structures.mushroomtower.TowerRoofMushroomComponent;
import twilightforest.util.RotationUtil;

public class MushroomTowerMainComponent
extends MushroomTowerWingComponent {
    public MushroomTowerMainComponent(TemplateManager manager, CompoundNBT nbt) {
        super(MushroomTowerPieces.TFMTMai, nbt);
    }

    public MushroomTowerMainComponent(TFFeature feature, Random rand, int index, int x, int y, int z) {
        this(feature, rand, index, x + 15, y + 4, z + 15, Direction.NORTH);
    }

    public MushroomTowerMainComponent(TFFeature feature, Random rand, int index, int x, int y, int z, Direction rotation) {
        super(MushroomTowerPieces.TFMTMai, feature, index, x, y, z, 15, 8 + rand.nextInt(3) * 4, rotation);
        if (this.deco == null) {
            this.deco = new MushroomTowerDecorator();
        }
    }

    protected MushroomTowerMainComponent(TFFeature feature, int i, int x, int y, int z, int pSize, int pHeight, Direction direction) {
        super(MushroomTowerPieces.TFMTMai, feature, i, x, y, z, pSize, pHeight, direction);
    }

    @Override
    public void func_74861_a(StructurePiece parent, List<StructurePiece> list, Random rand) {
        if (parent != null && parent instanceof TFStructureComponentOld) {
            this.deco = ((TFStructureComponentOld)parent).deco;
        }
        this.addOpening(0, 1, this.size / 2, Rotation.CLOCKWISE_180);
        this.hasBase = true;
        Rotation mainDir = null;
        if (this.func_74877_c() < 3) {
            for (int i = 0; i < 6 && (mainDir = this.makeAscenderTower(list, rand)) == null; ++i) {
            }
            for (Rotation i : RotationUtil.ROTATIONS) {
                if (i == mainDir) continue;
                int[] dest = this.getValidOpening(rand, i);
                int childHeight = (rand.nextInt(2) + rand.nextInt(2) + 2) * 4 + 1;
                this.makeBridge(list, rand, this.func_74877_c() + 1, dest[0], dest[1], dest[2], this.size - 4, childHeight, i);
            }
        } else {
            this.makeARoof(parent, list, rand);
        }
    }

    private Rotation makeAscenderTower(List<StructurePiece> list, Random rand) {
        Rotation mainDir = RotationUtil.ROTATIONS[rand.nextInt(4)];
        int[] dest = this.getValidOpening(rand, mainDir);
        int childHeight = this.height - dest[1] + (rand.nextInt(2) + rand.nextInt(2) + 3) * 4 + 1;
        boolean madeIt = this.makeBridge(list, rand, this.func_74877_c() + 1, dest[0], dest[1], dest[2], this.size - 4, childHeight, mainDir, true);
        if (madeIt) {
            TwilightForestMod.LOGGER.debug("Main tower made a bridge to another tower");
            return mainDir;
        }
        TwilightForestMod.LOGGER.info("Main tower failed to branch off at index {}", (Object)this.field_74886_g);
        return null;
    }

    @Override
    public void makeARoof(StructurePiece parent, List<StructurePiece> list, Random rand) {
        TowerRoofMushroomComponent roof = new TowerRoofMushroomComponent(this.getFeatureType(), this.func_74877_c() + 1, this, 1.6f);
        list.add(roof);
        roof.func_74861_a(this, list, rand);
    }

    @Override
    protected void makeDoorOpening(ISeedReader world, int dx, int dy, int dz, MutableBoundingBox sbb) {
        super.makeDoorOpening(world, dx, dy, dz, sbb);
        if (dx == 0) {
            this.func_175811_a(world, AIR, dx + 1, dy, dz, sbb);
            this.func_175811_a(world, AIR, dx + 1, dy + 1, dz, sbb);
        }
        if (dx == this.size - 1) {
            this.func_175811_a(world, AIR, dx - 1, dy, dz, sbb);
            this.func_175811_a(world, AIR, dx - 1, dy + 1, dz, sbb);
        }
        if (dz == 0) {
            this.func_175811_a(world, AIR, dx, dy, dz + 1, sbb);
            this.func_175811_a(world, AIR, dx, dy + 1, dz + 1, sbb);
        }
        if (dz == this.size - 1) {
            this.func_175811_a(world, AIR, dx, dy, dz - 1, sbb);
            this.func_175811_a(world, AIR, dx, dy + 1, dz - 1, sbb);
        }
    }
}

