/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.minotaurmaze;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import twilightforest.TFFeature;
import twilightforest.structures.TFStructureComponentOld;
import twilightforest.structures.minotaurmaze.MazeUpperEntranceComponent;
import twilightforest.structures.minotaurmaze.MinotaurMazePieces;

public class MazeMoundComponent
extends TFStructureComponentOld {
    public static final int DIAMETER = 35;
    private int averageGroundLevel = -1;
    private MazeUpperEntranceComponent mazeAbove;

    public MazeMoundComponent(TemplateManager manager, CompoundNBT nbt) {
        super(MinotaurMazePieces.TFMMMound, nbt);
    }

    public MazeMoundComponent(TFFeature feature, int i, Random rand, int x, int y, int z) {
        super(MinotaurMazePieces.TFMMMound, feature, i);
        this.func_186164_a(Direction.Plane.HORIZONTAL.func_179518_a(rand));
        this.field_74887_e = new MutableBoundingBox(x, y, z, x + 35, y + 8, z + 35);
    }

    public void func_74861_a(StructurePiece structurecomponent, List<StructurePiece> list, Random random) {
        super.func_74861_a(structurecomponent, list, random);
        this.mazeAbove = new MazeUpperEntranceComponent(this.getFeatureType(), 3, random, this.field_74887_e.field_78897_a + 10, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 10);
        list.add(this.mazeAbove);
        this.mazeAbove.func_74861_a(this, list, random);
    }

    public boolean func_230383_a_(ISeedReader world, StructureManager manager, ChunkGenerator generator, Random rand, MutableBoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        if (this.averageGroundLevel < 0) {
            this.averageGroundLevel = this.getAverageGroundLevel(world, generator, sbb);
            if (this.averageGroundLevel < 0) {
                return true;
            }
            int offset = this.averageGroundLevel - this.field_74887_e.field_78894_e + 8 - 1;
            this.field_74887_e.func_78886_a(0, offset, 0);
            if (this.mazeAbove != null) {
                this.mazeAbove.func_74874_b().func_78886_a(0, offset, 0);
            }
        }
        for (int x = 0; x < 35; ++x) {
            for (int z = 0; z < 35; ++z) {
                int cx = x - 17;
                int cz = z - 17;
                int dist = (int)Math.sqrt(cx * cx + cz * cz);
                int hheight = (int)(Math.cos((double)dist / 35.0 * Math.PI) * 11.0);
                if (cx <= 2 && cx >= -1 && cz <= 2 && cz >= -1 || (cx <= 2 && cx >= -1 || cz <= 2 && cz >= -1) && hheight <= 6) continue;
                this.func_175811_a(world, Blocks.field_196658_i.func_176223_P(), x, hheight, z, sbb);
                if (!(cx <= 2 && cx >= -1 || cz <= 2 && cz >= -1)) {
                    this.func_175811_a(world, Blocks.field_150346_d.func_176223_P(), x, hheight - 1, z, sbb);
                    continue;
                }
                if (hheight <= 6) continue;
                this.func_175804_a(world, sbb, x, 6, z, x, hheight - 1, z, Blocks.field_150346_d.func_176223_P(), AIR, false);
            }
        }
        return true;
    }

    @Override
    protected int getAverageGroundLevel(ISeedReader world, ChunkGenerator generator, MutableBoundingBox boundingBox) {
        int totalHeight = 0;
        int totalMeasures = 0;
        for (int z = this.field_74887_e.field_78896_c; z <= this.field_74887_e.field_78892_f; ++z) {
            for (int x = this.field_74887_e.field_78897_a; x <= this.field_74887_e.field_78893_d; ++x) {
                BlockPos pos = new BlockPos(x, 64, z);
                if (!boundingBox.func_175898_b((Vector3i)pos)) continue;
                BlockPos topPos = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, pos);
                totalHeight += Math.max(topPos.func_177956_o(), generator.func_205470_d());
                ++totalMeasures;
            }
        }
        if (totalMeasures == 0) {
            return -1;
        }
        return totalHeight / totalMeasures;
    }
}

