/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.lichtower;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SixWayBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import twilightforest.TFFeature;
import twilightforest.block.TFBlocks;
import twilightforest.entity.SwarmSpiderEntity;
import twilightforest.entity.TFEntities;
import twilightforest.structures.TFStructureComponentOld;
import twilightforest.structures.lichtower.LichTowerPieces;
import twilightforest.structures.lichtower.TowerOutbuildingComponent;
import twilightforest.structures.lichtower.TowerWingComponent;
import twilightforest.util.RotationUtil;

public class TowerMainComponent
extends TowerWingComponent {
    public TowerMainComponent(TemplateManager manager, CompoundNBT nbt) {
        super(LichTowerPieces.TFLTMai, nbt);
    }

    public TowerMainComponent(TFFeature feature, Random rand, int index, int x, int y, int z) {
        super(LichTowerPieces.TFLTMai, feature, index, x, y + 6, z, 15, 55 + rand.nextInt(32), Direction.SOUTH);
    }

    @Override
    public void func_74861_a(StructurePiece parent, List<StructurePiece> list, Random rand) {
        int childHeight;
        int[] dest;
        this.makeARoof(parent, list, rand);
        for (Rotation rotation : RotationUtil.ROTATIONS) {
            dest = this.getValidOpening(rand, rotation);
            if (dest[1] < this.height / 2) {
                dest[1] = dest[1] + 20;
            }
            if (this.makeTowerWing(list, rand, 1, dest[0], dest[1], dest[2], 9, childHeight = Math.min(21 + rand.nextInt(10), this.height - dest[1] - 3), rotation)) continue;
            this.makeTowerWing(list, rand, 1, dest[0], dest[1], dest[2], 7, childHeight, rotation);
        }
        for (Rotation rotation : RotationUtil.ROTATIONS) {
            dest = this.getValidOpening(rand, rotation);
            if (dest[1] < this.height / 2) {
                dest[1] = dest[1] + 10;
            }
            if (this.makeTowerWing(list, rand, 1, dest[0], dest[1], dest[2], 9, childHeight = Math.min(21 + rand.nextInt(10), this.height - dest[1] - 3), rotation)) continue;
            this.makeTowerWing(list, rand, 1, dest[0], dest[1], dest[2], 7, childHeight, rotation);
        }
        for (Rotation rotation : RotationUtil.ROTATIONS) {
            dest = this.getValidOpening(rand, rotation);
            if (this.makeTowerWing(list, rand, 1, dest[0], dest[1], dest[2], 5, childHeight = Math.min(7 + rand.nextInt(6), this.height - dest[1] - 3), rotation)) continue;
            this.makeTowerWing(list, rand, 1, dest[0], dest[1], dest[2], 3, childHeight, rotation);
        }
        for (Rotation rotation : RotationUtil.ROTATIONS) {
            dest = this.getOutbuildingOpening(rand, rotation);
            childHeight = 11 + rand.nextInt(10);
            int childSize = 7 + rand.nextInt(2) * 2;
            this.makeTowerOutbuilding(list, rand, 1, dest[0], dest[1], dest[2], childSize, childHeight, rotation);
        }
        for (int i = 0; i < 4; ++i) {
            for (Rotation towerRotation : RotationUtil.ROTATIONS) {
                int[] dest2 = this.getValidOpening(rand, towerRotation);
                int childHeight2 = 6 + rand.nextInt(5);
                if (rand.nextInt(3) != 0 && this.makeTowerWing(list, rand, 1, dest2[0], dest2[1], dest2[2], 5, childHeight2, towerRotation)) continue;
                this.makeTowerWing(list, rand, 1, dest2[0], dest2[1], dest2[2], 3, childHeight2, towerRotation);
            }
        }
    }

    public int[] getOutbuildingOpening(Random rand, Rotation rotation) {
        int rx = 0;
        int ry = 1;
        int rz = 0;
        switch (rotation) {
            case NONE: {
                rx = this.size - 1;
                rz = 6 + rand.nextInt(8);
                break;
            }
            case CLOCKWISE_90: {
                rx = 1 + rand.nextInt(11);
                rz = this.size - 1;
                break;
            }
            case CLOCKWISE_180: {
                rx = 0;
                rz = 1 + rand.nextInt(8);
                break;
            }
            case COUNTERCLOCKWISE_90: {
                rx = 3 + rand.nextInt(11);
                rz = 0;
            }
        }
        return new int[]{rx, ry, rz};
    }

    public boolean makeTowerOutbuilding(List<StructurePiece> list, Random rand, int index, int x, int y, int z, int wingSize, int wingHeight, Rotation rotation) {
        Direction direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, wingSize, direction);
        TowerOutbuildingComponent outbuilding = new TowerOutbuildingComponent(this.getFeatureType(), index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction);
        StructurePiece intersect = StructurePiece.func_74883_a(list, (MutableBoundingBox)outbuilding.func_74874_b());
        if (intersect == null) {
            list.add(outbuilding);
            outbuilding.func_74861_a(this, list, rand);
            this.addOpening(x, y, z, rotation);
            return true;
        }
        return false;
    }

    @Override
    public boolean func_230383_a_(ISeedReader world, StructureManager manager, ChunkGenerator generator, Random rand, MutableBoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        this.func_74882_a(world, sbb, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1, false, rand, TFStructureComponentOld.getStrongholdStones());
        this.func_74878_a(world, sbb, 1, 1, 1, this.size - 2, this.height - 2, this.size - 2);
        BlockState defaultState = Blocks.field_150347_e.func_176223_P();
        for (int x = 0; x < this.size; ++x) {
            for (int z = 0; z < this.size; ++z) {
                this.func_175808_b(world, defaultState, x, -1, z, sbb);
            }
        }
        if (this.height - this.highestOpening > 15) {
            this.highestOpening = this.height - 15;
        }
        this.makeStairs(world, rand, sbb);
        this.makeOpenings(world, sbb);
        this.decorateStairFloor(world, rand, sbb);
        this.makeStairwayCrossings(world, rand, sbb);
        this.makeLichRoom(world, rand, sbb);
        this.makeTowerPaintings(world, rand, sbb);
        return true;
    }

    protected void makeStairwayCrossings(ISeedReader world, Random rand, MutableBoundingBox sbb) {
        int flights = this.highestOpening / 5 - 2;
        for (int i = 2 + rand.nextInt(2); i < flights; i += 1 + rand.nextInt(5)) {
            this.makeStairCrossing(world, rand, i, sbb);
        }
    }

    protected void makeStairCrossing(ISeedReader world, Random rand, int flight, MutableBoundingBox sbb) {
        int dz;
        int dx;
        Direction temp = this.func_186165_e();
        if (flight % 2 == 0) {
            this.func_186164_a(this.getStructureRelativeRotation(Rotation.CLOCKWISE_90));
        }
        int floorLevel = flight * 5;
        BlockState crossingfloor = rand.nextBoolean() ? (BlockState)Blocks.field_222401_hJ.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE) : Blocks.field_196666_p.func_176223_P();
        for (dx = 6; dx <= 8; ++dx) {
            for (dz = 4; dz <= 10; ++dz) {
                this.func_175811_a(world, crossingfloor, dx, floorLevel, dz, sbb);
            }
        }
        ++floorLevel;
        dx = 6;
        for (dz = 3; dz <= 11; ++dz) {
            this.func_175811_a(world, Blocks.field_180407_aO.func_176223_P(), dx, floorLevel, dz, sbb);
        }
        ++dx;
        for (dz = 3; dz <= 11; ++dz) {
            this.func_175811_a(world, AIR, dx, floorLevel, dz, sbb);
        }
        ++dx;
        for (dz = 3; dz <= 11; ++dz) {
            this.func_175811_a(world, Blocks.field_180407_aO.func_176223_P(), dx, floorLevel, dz, sbb);
        }
        this.func_175811_a(world, crossingfloor, 6, floorLevel - 1, 11, sbb);
        this.func_175811_a(world, crossingfloor, 8, floorLevel - 1, 3, sbb);
        this.func_175811_a(world, Blocks.field_180407_aO.func_176223_P(), 5, floorLevel, 11, sbb);
        this.func_175811_a(world, Blocks.field_180407_aO.func_176223_P(), 9, floorLevel, 3, sbb);
        EntityType<SwarmSpiderEntity> mobID = EntityType.field_200741_ag;
        switch (rand.nextInt(4)) {
            case 0: 
            case 1: {
                mobID = EntityType.field_200741_ag;
                break;
            }
            case 2: {
                mobID = EntityType.field_200725_aD;
                break;
            }
            case 3: {
                mobID = TFEntities.swarm_spider;
            }
        }
        this.setSpawner(world, 7, floorLevel + 2, 7, sbb, mobID);
        this.func_175811_a(world, Blocks.field_180407_aO.func_176223_P(), 6, floorLevel + 1, 7, sbb);
        this.func_175811_a(world, Blocks.field_180407_aO.func_176223_P(), 8, floorLevel + 1, 7, sbb);
        this.func_175811_a(world, Blocks.field_180407_aO.func_176223_P(), 6, floorLevel + 2, 7, sbb);
        this.func_175811_a(world, Blocks.field_180407_aO.func_176223_P(), 8, floorLevel + 2, 7, sbb);
        this.func_186164_a(temp);
    }

    protected void makeLichRoom(ISeedReader world, Random rand, MutableBoundingBox sbb) {
        int floorLevel = 2 + this.highestOpening / 5 * 5;
        Rotation i = this.highestOpening / 5 % 2 == 0 ? Rotation.NONE : Rotation.CLOCKWISE_90;
        this.makeLichFloor(world, floorLevel, i, sbb);
        this.decorateLichChandelier(world, floorLevel, sbb);
        this.decoratePaintings(world, rand, floorLevel, sbb);
        this.decorateTorches(world, rand, floorLevel, sbb);
        this.func_175811_a(world, ((Block)TFBlocks.boss_spawner_lich.get()).func_176223_P(), this.size / 2, floorLevel + 2, this.size / 2, sbb);
    }

    protected void makeTowerPaintings(ISeedReader world, Random rand, MutableBoundingBox sbb) {
        int howMany = 10;
        this.generatePaintingsOnWall(world, rand, howMany, 0, Direction.WEST, 48, sbb);
        this.generatePaintingsOnWall(world, rand, howMany, 0, Direction.WEST, 32, sbb);
        this.generatePaintingsOnWall(world, rand, howMany, 0, Direction.WEST, 0, sbb);
        this.generatePaintingsOnWall(world, rand, howMany, 0, Direction.EAST, 48, sbb);
        this.generatePaintingsOnWall(world, rand, howMany, 0, Direction.EAST, 32, sbb);
        this.generatePaintingsOnWall(world, rand, howMany, 0, Direction.EAST, 0, sbb);
        this.generatePaintingsOnWall(world, rand, howMany, 0, Direction.NORTH, 48, sbb);
        this.generatePaintingsOnWall(world, rand, howMany, 0, Direction.NORTH, 32, sbb);
        this.generatePaintingsOnWall(world, rand, howMany, 0, Direction.NORTH, 0, sbb);
        this.generatePaintingsOnWall(world, rand, howMany, 0, Direction.SOUTH, 48, sbb);
        this.generatePaintingsOnWall(world, rand, howMany, 0, Direction.SOUTH, 32, sbb);
        this.generatePaintingsOnWall(world, rand, howMany, 0, Direction.SOUTH, 0, sbb);
    }

    protected void makeLichFloor(ISeedReader world, int floorLevel, Rotation rotation, MutableBoundingBox sbb) {
        Direction temp = this.func_186165_e();
        this.func_186164_a(this.getStructureRelativeRotation(rotation));
        BlockState birchSlab = (BlockState)Blocks.field_196627_bs.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.TOP);
        BlockState birchPlank = Blocks.field_196666_p.func_176223_P();
        for (int fx = 1; fx < 14; ++fx) {
            for (int fz = 1; fz < 14; ++fz) {
                if ((fx == 1 || fx == 2) && fz >= 6 && fz <= 12) {
                    if (fz != 6) continue;
                    this.func_175811_a(world, birchSlab, fx, floorLevel, fz, sbb);
                    continue;
                }
                if ((fx == 12 || fx == 13) && fz >= 3 && fz <= 8) {
                    if (fz != 8) continue;
                    this.func_175811_a(world, birchSlab, fx, floorLevel, fz, sbb);
                    continue;
                }
                if (fx >= 4 && fx <= 10 && fz >= 4 && fz <= 10) {
                    if (fx == 4 && fz == 4 || fx == 10 && fz == 10) {
                        this.func_175811_a(world, birchPlank, fx, floorLevel, fz, sbb);
                        continue;
                    }
                    this.func_175811_a(world, Blocks.field_150359_w.func_176223_P(), fx, floorLevel, fz, sbb);
                    continue;
                }
                if (!(fx != 2 && fx != 3 || fz != 2 && fz != 3)) {
                    this.func_175811_a(world, Blocks.field_150359_w.func_176223_P(), fx, floorLevel, fz, sbb);
                    continue;
                }
                if (!(fx != 11 && fx != 12 || fz != 11 && fz != 12)) {
                    this.func_175811_a(world, Blocks.field_150359_w.func_176223_P(), fx, floorLevel, fz, sbb);
                    continue;
                }
                this.func_175811_a(world, birchPlank, fx, floorLevel, fz, sbb);
            }
        }
        this.func_175811_a(world, AIR, 3, floorLevel + 1, 11, sbb);
        this.func_175811_a(world, AIR, 3, floorLevel + 1, 10, sbb);
        this.func_175811_a(world, AIR, 3, floorLevel + 2, 11, sbb);
        this.func_175811_a(world, AIR, 11, floorLevel + 1, 3, sbb);
        this.func_175811_a(world, AIR, 11, floorLevel + 1, 4, sbb);
        this.func_175811_a(world, AIR, 11, floorLevel + 2, 3, sbb);
        this.func_186164_a(temp);
    }

    protected void decorateLichChandelier(ISeedReader world, int floorLevel, MutableBoundingBox sbb) {
        int cx = this.size / 2;
        int cy = floorLevel + 4;
        int cz = this.size / 2;
        this.func_175811_a(world, Blocks.field_180407_aO.func_176223_P(), cx + 1, cy, cz, sbb);
        this.func_175811_a(world, Blocks.field_180407_aO.func_176223_P(), cx + 2, cy, cz, sbb);
        this.func_175811_a(world, Blocks.field_180407_aO.func_176223_P(), cx + 1, cy, cz + 1, sbb);
        this.func_175811_a(world, Blocks.field_180407_aO.func_176223_P(), cx, cy, cz + 1, sbb);
        this.func_175811_a(world, Blocks.field_180407_aO.func_176223_P(), cx, cy, cz + 2, sbb);
        this.func_175811_a(world, Blocks.field_180407_aO.func_176223_P(), cx - 1, cy, cz + 1, sbb);
        this.func_175811_a(world, Blocks.field_180407_aO.func_176223_P(), cx - 1, cy, cz, sbb);
        this.func_175811_a(world, Blocks.field_180407_aO.func_176223_P(), cx - 2, cy, cz, sbb);
        this.func_175811_a(world, Blocks.field_180407_aO.func_176223_P(), cx - 1, cy, cz - 1, sbb);
        this.func_175811_a(world, Blocks.field_180407_aO.func_176223_P(), cx, cy, cz - 1, sbb);
        this.func_175811_a(world, Blocks.field_180407_aO.func_176223_P(), cx, cy, cz - 2, sbb);
        this.func_175811_a(world, Blocks.field_180407_aO.func_176223_P(), cx + 1, cy, cz - 1, sbb);
        this.func_175811_a(world, Blocks.field_180407_aO.func_176223_P(), cx + 1, ++cy, cz, sbb);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P(), cx + 2, cy, cz, sbb);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P(), cx + 1, cy, cz + 1, sbb);
        this.func_175811_a(world, Blocks.field_180407_aO.func_176223_P(), cx, cy, cz + 1, sbb);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P(), cx, cy, cz + 2, sbb);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P(), cx - 1, cy, cz + 1, sbb);
        this.func_175811_a(world, Blocks.field_180407_aO.func_176223_P(), cx - 1, cy, cz, sbb);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P(), cx - 2, cy, cz, sbb);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P(), cx - 1, cy, cz - 1, sbb);
        this.func_175811_a(world, Blocks.field_180407_aO.func_176223_P(), cx, cy, cz - 1, sbb);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P(), cx, cy, cz - 2, sbb);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P(), cx + 1, cy, cz - 1, sbb);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P(), cx + 1, ++cy, cz, sbb);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P(), cx, cy, cz + 1, sbb);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P(), cx - 1, cy, cz, sbb);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P(), cx, cy, cz - 1, sbb);
        for (int y = floorLevel + 5; y < this.height - 1; ++y) {
            this.func_175811_a(world, Blocks.field_180407_aO.func_176223_P(), cx, y, cz, sbb);
        }
    }

    protected void decoratePaintings(ISeedReader world, Random rand, int floorLevel, MutableBoundingBox sbb) {
        int howMany = 25;
        for (Direction horizontal : Direction.Plane.HORIZONTAL) {
            this.generatePaintingsOnWall(world, rand, howMany, floorLevel, horizontal, 48, sbb);
            this.generatePaintingsOnWall(world, rand, howMany, floorLevel, horizontal, 32, sbb);
            this.generatePaintingsOnWall(world, rand, howMany, floorLevel, horizontal, 0, sbb);
        }
    }

    protected void decorateTorches(ISeedReader world, Random rand, int floorLevel, MutableBoundingBox sbb) {
        this.generateTorchesOnWall(world, rand, floorLevel, Direction.SOUTH, sbb);
        this.generateTorchesOnWall(world, rand, floorLevel, Direction.EAST, sbb);
        this.generateTorchesOnWall(world, rand, floorLevel, Direction.NORTH, sbb);
        this.generateTorchesOnWall(world, rand, floorLevel, Direction.WEST, sbb);
    }

    protected void generateTorchesOnWall(ISeedReader world, Random rand, int floorLevel, Direction direction, MutableBoundingBox sbb) {
        for (int i = 0; i < 5; ++i) {
            BlockPos wCoords = this.getRandomWallSpot(rand, floorLevel, direction, sbb);
            if (wCoords == null) continue;
            BlockPos.Mutable tCoords = new BlockPos.Mutable(wCoords.func_177958_n(), wCoords.func_177956_o(), wCoords.func_177952_p());
            BlockState blockState = world.func_180495_p((BlockPos)tCoords);
            BlockState aboveBlockState = world.func_180495_p(tCoords.func_177984_a());
            if (blockState.func_185904_a() != Material.field_151579_a || aboveBlockState.func_185904_a() != Material.field_151579_a || this.getEntitiesInAABB(world, new AxisAlignedBB((BlockPos)tCoords)).size() != 0) continue;
            world.func_180501_a((BlockPos)tCoords, (BlockState)Blocks.field_180407_aO.func_176223_P().func_206870_a((Property)SixWayBlock.field_196491_B.get(direction.func_176734_d()), (Comparable)Boolean.valueOf(true)), 2);
            world.func_180501_a(tCoords.func_177984_a(), Blocks.field_150478_aa.func_176223_P(), 2);
        }
    }
}

