/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.icetower;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import twilightforest.TFFeature;
import twilightforest.structures.TFStructureComponentOld;
import twilightforest.structures.icetower.IceTowerPieces;
import twilightforest.structures.icetower.IceTowerStairsComponent;
import twilightforest.structures.icetower.IceTowerWingComponent;

public class IceTowerEntranceComponent
extends IceTowerWingComponent {
    public IceTowerEntranceComponent(TemplateManager manager, CompoundNBT nbt) {
        super(IceTowerPieces.TFITEnt, nbt);
    }

    public IceTowerEntranceComponent(TFFeature feature, int i, int x, int y, int z, int pSize, int pHeight, Direction direction) {
        super(IceTowerPieces.TFITEnt, feature, i, x, y, z, pSize, pHeight, direction);
    }

    @Override
    protected boolean shouldHaveBase(Random rand) {
        return true;
    }

    @Override
    public void func_74861_a(StructurePiece parent, List<StructurePiece> list, Random rand) {
        if (parent != null && parent instanceof TFStructureComponentOld) {
            this.deco = ((TFStructureComponentOld)parent).deco;
        }
        this.addOpening(0, 1, this.size / 2, Rotation.CLOCKWISE_180);
        this.addStairs(list, rand, this.func_74877_c() + 1, this.size - 1, 1, this.size / 2, Rotation.NONE);
        this.addStairs(list, rand, this.func_74877_c() + 1, this.size / 2, 1, 0, Rotation.COUNTERCLOCKWISE_90);
        this.addStairs(list, rand, this.func_74877_c() + 1, this.size / 2, 1, this.size - 1, Rotation.CLOCKWISE_90);
        this.hasBase = this.shouldHaveBase(rand);
        this.makeARoof(parent, list, rand);
    }

    private boolean addStairs(List<StructurePiece> list, Random rand, int index, int x, int y, int z, Rotation rotation) {
        this.addOpening(x, y, z, rotation);
        Direction direction = this.getStructureRelativeRotation(rotation);
        BlockPos dx = this.offsetTowerCCoords(x, y, z, this.size, direction);
        IceTowerStairsComponent entrance = new IceTowerStairsComponent(this.getFeatureType(), index, dx.func_177958_n(), dx.func_177956_o(), dx.func_177952_p(), this.size, this.height, direction);
        list.add(entrance);
        entrance.func_74861_a(list.get(0), list, rand);
        return true;
    }

    @Override
    public boolean makeTowerWing(List<StructurePiece> list, Random rand, int index, int x, int y, int z, int wingSize, int wingHeight, Rotation rotation) {
        return false;
    }

    @Override
    protected void makeFloorsForTower(ISeedReader world, Random rand, MutableBoundingBox sbb) {
        this.decoratePillarsCornersHigh(world, 0, 11, Rotation.NONE, sbb);
    }

    protected void decoratePillarsCornersHigh(ISeedReader world, int bottom, int top, Rotation rotation, MutableBoundingBox sbb) {
        BlockState pillarXAxis = (BlockState)this.deco.pillarState.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.X);
        BlockState pillarZAxis = (BlockState)this.deco.pillarState.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Z);
        this.fillBlocksRotated(world, sbb, 3, bottom + 5, 1, 3, bottom + 5, 9, pillarZAxis, rotation);
        this.fillBlocksRotated(world, sbb, 7, bottom + 5, 1, 7, bottom + 5, 9, pillarZAxis, rotation);
        this.fillBlocksRotated(world, sbb, 1, bottom + 5, 3, 9, bottom + 5, 3, pillarXAxis, rotation);
        this.fillBlocksRotated(world, sbb, 1, bottom + 5, 7, 9, bottom + 5, 7, pillarXAxis, rotation);
        this.fillAirRotated(world, sbb, 3, bottom + 5, 3, 7, bottom + 5, 7, rotation);
        this.fillBlocksRotated(world, sbb, 3, bottom + 5, 3, 3, top - 1, 3, this.deco.pillarState, rotation);
        this.fillBlocksRotated(world, sbb, 7, bottom + 5, 3, 7, top - 1, 3, this.deco.pillarState, rotation);
        this.fillBlocksRotated(world, sbb, 3, bottom + 5, 7, 3, top - 1, 7, this.deco.pillarState, rotation);
        this.fillBlocksRotated(world, sbb, 7, bottom + 5, 7, 7, top - 1, 7, this.deco.pillarState, rotation);
    }
}

