/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.courtyard;

import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import twilightforest.TFFeature;
import twilightforest.enums.Diagonals;
import twilightforest.structures.TFStructureComponent;
import twilightforest.structures.TFStructureComponentTemplate;
import twilightforest.structures.courtyard.NagaCourtyardHedgeCapComponent;
import twilightforest.structures.courtyard.NagaCourtyardHedgeCapPillarComponent;
import twilightforest.structures.courtyard.NagaCourtyardHedgeCornerComponent;
import twilightforest.structures.courtyard.NagaCourtyardHedgeIntersectionComponent;
import twilightforest.structures.courtyard.NagaCourtyardHedgeLineComponent;
import twilightforest.structures.courtyard.NagaCourtyardHedgePadderComponent;
import twilightforest.structures.courtyard.NagaCourtyardHedgeTJunctionComponent;
import twilightforest.structures.courtyard.NagaCourtyardPathComponent;
import twilightforest.structures.courtyard.NagaCourtyardTerraceBrazierComponent;
import twilightforest.structures.courtyard.NagaCourtyardTerraceDuctComponent;
import twilightforest.structures.courtyard.NagaCourtyardTerraceStatueComponent;
import twilightforest.structures.courtyard.NagaCourtyardWallComponent;
import twilightforest.structures.courtyard.NagaCourtyardWallCornerAltComponent;
import twilightforest.structures.courtyard.NagaCourtyardWallCornerComponent;
import twilightforest.structures.courtyard.NagaCourtyardWallPadderComponent;

public abstract class StructureMazeGenerator
extends TFStructureComponent {
    protected int[][] maze;
    private int[][] cornerClipping = new int[4][2];
    private int widthInCellCount;
    private int heightInCellCount;

    public StructureMazeGenerator(IStructurePieceType piece, CompoundNBT nbt) {
        super(piece, nbt);
        this.widthInCellCount = nbt.func_74762_e("mazeWidth");
        this.heightInCellCount = nbt.func_74762_e("mazeHeight");
        this.maze = new int[this.widthInCellCount - 1][this.heightInCellCount - 1];
        ListNBT mazeX = nbt.func_150295_c("maze", 9);
        for (int x = 0; x < this.widthInCellCount - 1; ++x) {
            INBT mazeY = mazeX.get(x);
            if (!(mazeY instanceof ListNBT)) continue;
            for (int y = 0; y < this.heightInCellCount - 1; ++y) {
                this.maze[x][y] = ((ListNBT)mazeY).func_186858_c(y);
            }
        }
    }

    StructureMazeGenerator(IStructurePieceType type, TFFeature feature, Random rand, int i, int widthInCellCount, int heightInCellCount) {
        super(type, feature, i);
        this.widthInCellCount = widthInCellCount;
        this.heightInCellCount = heightInCellCount;
        this.maze = new int[widthInCellCount - 1][heightInCellCount - 1];
        StructureMazeGenerator.generateMaze(this.maze, this.cornerClipping, rand, this.widthInCellCount, this.heightInCellCount, 2);
    }

    public void func_74861_a(StructurePiece structureComponent, List<StructurePiece> list, Random random) {
        super.func_74861_a(structureComponent, list, random);
        int offset = 6;
        Rotation[] rotations = Rotation.values();
        this.processInnerWallsAndFloor(structureComponent, list, random, 6, rotations);
        this.processOuterWalls(structureComponent, list, random, 6, rotations);
    }

    private static void generateMaze(int[][] maze, int[][] cornerClippings, Random random, int widthInCellCount, int heightInCellCount, int maximumClipping) {
        int x;
        WallFacing[][] rotations = new WallFacing[maze.length][maze[0].length];
        for (int x2 = 0; x2 < widthInCellCount - 1; ++x2) {
            for (int y = 0; y < heightInCellCount - 1; ++y) {
                rotations[x2][y] = WallFacing.values()[random.nextInt(WallFacing.values().length)];
                int[] nArray = maze[x2];
                int n = y;
                nArray[n] = nArray[n] | rotations[x2][y].BYTE;
            }
        }
        int[][] mazeLocal = (int[][])maze.clone();
        int halfWayPointX = widthInCellCount / 2 - 1;
        int halfWayPointY = heightInCellCount / 2 - 1;
        for (int y = 0; y < heightInCellCount - 1; ++y) {
            for (x = 0; x < widthInCellCount - 1; ++x) {
                if (x == halfWayPointX && y == halfWayPointY) continue;
                if (rotations[x][y] == WallFacing.WEST && x > 0) {
                    if (!rotations[x][y].unpackAndTest(maze[x - 1][y])) {
                        int[] nArray = maze[x - 1];
                        int n = y;
                        nArray[n] = nArray[n] | rotations[x][y].OPPOSITE;
                    } else {
                        int[] nArray = maze[x];
                        int n = y;
                        nArray[n] = nArray[n] & rotations[x][y].INVERTED;
                        int[] nArray2 = maze[x - 1];
                        int n2 = y;
                        nArray2[n2] = nArray2[n2] & rotations[x - 1][y].INVERTED_OPPOSITE;
                    }
                }
                if (rotations[x][y] == WallFacing.NORTH && y > 0) {
                    if (!rotations[x][y].unpackAndTest(maze[x][y - 1])) {
                        int[] nArray = maze[x];
                        int n = y - 1;
                        nArray[n] = nArray[n] | rotations[x][y].OPPOSITE;
                    } else {
                        int[] nArray = maze[x];
                        int n = y;
                        nArray[n] = nArray[n] & rotations[x][y].INVERTED;
                        int[] nArray3 = maze[x];
                        int n3 = y - 1;
                        nArray3[n3] = nArray3[n3] & rotations[x][y - 1].INVERTED_OPPOSITE;
                    }
                }
                if (rotations[x][y] == WallFacing.EAST && x < widthInCellCount - 2) {
                    if (!rotations[x][y].unpackAndTest(maze[x + 1][y])) {
                        int[] nArray = maze[x + 1];
                        int n = y;
                        nArray[n] = nArray[n] | rotations[x][y].OPPOSITE;
                    } else {
                        int[] nArray = maze[x];
                        int n = y;
                        nArray[n] = nArray[n] & rotations[x][y].INVERTED;
                        int[] nArray4 = maze[x + 1];
                        int n4 = y;
                        nArray4[n4] = nArray4[n4] & rotations[x + 1][y].INVERTED_OPPOSITE;
                    }
                }
                if (rotations[x][y] != WallFacing.SOUTH || y >= heightInCellCount - 2) continue;
                if (!rotations[x][y].unpackAndTest(maze[x][y + 1])) {
                    int[] nArray = maze[x];
                    int n = y + 1;
                    nArray[n] = nArray[n] | rotations[x][y].OPPOSITE;
                    continue;
                }
                int[] nArray = maze[x];
                int n = y;
                nArray[n] = nArray[n] & rotations[x][y].INVERTED;
                int[] nArray5 = maze[x];
                int n5 = y + 1;
                nArray5[n5] = nArray5[n5] & rotations[x][y + 1].INVERTED_OPPOSITE;
            }
        }
        WallFacing[] y = WallFacing.values();
        x = y.length;
        for (int i = 0; i < x; ++i) {
            WallFacing facing = y[i];
            int[] nArray = maze[halfWayPointX + facing.xOffset];
            int n = halfWayPointY + facing.zOffset;
            nArray[n] = nArray[n] & facing.INVERTED_OPPOSITE;
        }
        maze[halfWayPointX][halfWayPointY] = 16;
        for (int x3 = 1; x3 < maze.length; ++x3) {
            for (int y2 = 1; y2 < maze[x3].length; ++y2) {
                if (mazeLocal[x3][y2] != 0) continue;
                if (mazeLocal[x3 - 1][y2] == 0) {
                    int[] nArray = maze[x3];
                    int n = y2;
                    nArray[n] = nArray[n] | WallFacing.WEST.BYTE;
                    int[] nArray6 = maze[x3 - 1];
                    int n6 = y2;
                    nArray6[n6] = nArray6[n6] | WallFacing.WEST.OPPOSITE;
                }
                if (mazeLocal[x3][y2 - 1] != 0) continue;
                int[] nArray = maze[x3];
                int n = y2;
                nArray[n] = nArray[n] | WallFacing.NORTH.BYTE;
                int[] nArray7 = maze[x3];
                int n7 = y2 - 1;
                nArray7[n7] = nArray7[n7] | WallFacing.NORTH.OPPOSITE;
            }
        }
        for (Diagonals diagonals : Diagonals.values()) {
            cornerClippings[diagonals.ordinal()][0] = random.nextInt(maximumClipping) + 1;
            cornerClippings[diagonals.ordinal()][1] = random.nextInt(maximumClipping) + 1;
            for (int y3 = 0; y3 < cornerClippings[diagonals.ordinal()][0]; ++y3) {
                for (int x4 = 0; x4 < cornerClippings[diagonals.ordinal()][1]; ++x4) {
                    int[] nArray = maze[diagonals.operationX.convert(x4, widthInCellCount - 2)];
                    int n = diagonals.operationY.convert(y3, heightInCellCount - 2);
                    nArray[n] = nArray[n] | 0x10;
                }
            }
        }
    }

    private void processInnerWallsAndFloor(StructurePiece structureComponent, List<StructurePiece> list, Random random, int offset, Rotation[] rotations) {
        for (int x = 0; x < this.widthInCellCount - 1; ++x) {
            for (int y = 0; y < this.heightInCellCount - 1; ++y) {
                NagaCourtyardPathComponent path2;
                boolean eastSouthHasNoTerraceOrIsSafe;
                NagaCourtyardHedgeLineComponent structureLine;
                NagaCourtyardHedgePadderComponent padding2;
                NagaCourtyardHedgePadderComponent padding;
                boolean yCenter;
                boolean xCenter = x == this.widthInCellCount / 2 - 1;
                boolean bl = yCenter = y == this.heightInCellCount / 2 - 1;
                if (!xCenter && !yCenter && (this.maze[x][y] & 0x10) == 16) continue;
                int rotation = 0;
                int xBB = this.field_74887_e.field_78897_a + x * 12 + offset;
                int yBB = this.field_74887_e.field_78895_b + 1;
                int zBB = this.field_74887_e.field_78896_c + y * 12 + offset;
                if (!xCenter || !yCenter) {
                    TFStructureComponentTemplate structure;
                    switch (this.maze[x][y] & 0xF) {
                        case 2: {
                            ++rotation;
                        }
                        case 1: {
                            ++rotation;
                        }
                        case 8: {
                            ++rotation;
                        }
                        case 4: {
                            Rotation rotationCap = rotations[rotation];
                            if (random.nextBoolean()) {
                                structure = new NagaCourtyardHedgeCapComponent(this.getFeatureType(), x * this.widthInCellCount + y, xBB, yBB, zBB, rotationCap);
                                break;
                            }
                            structure = new NagaCourtyardHedgeCapPillarComponent(this.getFeatureType(), x * this.widthInCellCount + y, xBB, yBB, zBB, rotationCap);
                            break;
                        }
                        case 9: {
                            ++rotation;
                        }
                        case 12: {
                            ++rotation;
                        }
                        case 6: {
                            ++rotation;
                        }
                        case 3: {
                            Rotation rotationCorner = rotations[rotation];
                            structure = new NagaCourtyardHedgeCornerComponent(this.getFeatureType(), this.maze[x][y], xBB, yBB, zBB, rotationCorner);
                            break;
                        }
                        case 13: {
                            ++rotation;
                        }
                        case 14: {
                            ++rotation;
                        }
                        case 7: {
                            ++rotation;
                        }
                        case 11: {
                            Rotation rotationT = rotations[rotation];
                            structure = new NagaCourtyardHedgeTJunctionComponent(this.getFeatureType(), this.maze[x][y], xBB, yBB, zBB, rotationT);
                            break;
                        }
                        case 10: {
                            ++rotation;
                        }
                        case 5: {
                            Rotation rotationLine = rotations[rotation];
                            structure = new NagaCourtyardHedgeLineComponent(this.getFeatureType(), this.maze[x][y], xBB, yBB, zBB, rotationLine);
                            break;
                        }
                        case 15: {
                            structure = new NagaCourtyardHedgeIntersectionComponent(this.getFeatureType(), this.maze[x][y], xBB, yBB, zBB, Rotation.NONE);
                            break;
                        }
                        default: {
                            structure = random.nextInt(150) == 0 ? new NagaCourtyardTerraceStatueComponent(this.getFeatureType(), this.maze[x][y], xBB - 6, yBB - 3, zBB - 6, rotations[random.nextInt(rotations.length)]) : (random.nextBoolean() ? new NagaCourtyardTerraceBrazierComponent(this.getFeatureType(), this.maze[x][y], xBB - 6, yBB - 3, zBB - 6, Rotation.NONE) : new NagaCourtyardTerraceDuctComponent(this.getFeatureType(), this.maze[x][y], xBB - 6, yBB - 3, zBB - 6, rotations[random.nextInt(rotations.length)]));
                        }
                    }
                    list.add(structure);
                    structure.func_74861_a(structureComponent, list, random);
                }
                xBB = this.field_74887_e.field_78897_a + x * 12 + offset;
                zBB = this.field_74887_e.field_78896_c + y * 12 + offset;
                boolean connectWest = WallFacing.WEST.unpackAndTest(this.maze[x][y]);
                boolean connectNorth = WallFacing.NORTH.unpackAndTest(this.maze[x][y]);
                boolean connectEast = WallFacing.EAST.unpackAndTest(this.maze[x][y]);
                boolean connectSouth = WallFacing.SOUTH.unpackAndTest(this.maze[x][y]);
                if (connectWest) {
                    padding = new NagaCourtyardHedgePadderComponent(this.getFeatureType(), this.maze[x][y], xBB - 1, yBB, zBB, Rotation.NONE);
                    list.add(padding);
                    padding.func_74861_a(structureComponent, list, random);
                    if (x > 0 && (this.maze[x - 1][y] & 0x10) != 16) {
                        padding2 = new NagaCourtyardHedgePadderComponent(this.getFeatureType(), this.maze[x][y], xBB - 7, yBB, zBB, Rotation.NONE);
                        list.add(padding2);
                        padding2.func_74861_a(structureComponent, list, random);
                    }
                    structureLine = new NagaCourtyardHedgeLineComponent(this.getFeatureType(), this.maze[x][y], xBB - 6, yBB, zBB, Rotation.NONE);
                    list.add(structureLine);
                    structureLine.func_74861_a(structureComponent, list, random);
                }
                if (connectNorth) {
                    padding = new NagaCourtyardHedgePadderComponent(this.getFeatureType(), this.maze[x][y], xBB + 4, yBB, zBB - 1, Rotation.CLOCKWISE_90);
                    list.add(padding);
                    padding.func_74861_a(structureComponent, list, random);
                    if (y > 0 && (this.maze[x][y - 1] & 0x10) != 16) {
                        padding2 = new NagaCourtyardHedgePadderComponent(this.getFeatureType(), this.maze[x][y], xBB + 4, yBB, zBB - 7, Rotation.CLOCKWISE_90);
                        list.add(padding2);
                        padding2.func_74861_a(structureComponent, list, random);
                    }
                    structureLine = new NagaCourtyardHedgeLineComponent(this.getFeatureType(), this.maze[x][y], xBB, yBB, zBB - 6, Rotation.CLOCKWISE_90);
                    list.add(structureLine);
                    structureLine.func_74861_a(structureComponent, list, random);
                }
                if ((x >= this.widthInCellCount - 2 || (this.maze[x + 1][y] & 0x10) == 16) && connectEast) {
                    padding = new NagaCourtyardHedgePadderComponent(this.getFeatureType(), this.maze[x][y], xBB + 5, yBB, zBB, Rotation.NONE);
                    list.add(padding);
                    padding.func_74861_a(structureComponent, list, random);
                    structureLine = new NagaCourtyardHedgeLineComponent(this.getFeatureType(), this.maze[x][y], xBB + 6, yBB, zBB, Rotation.NONE);
                    list.add(structureLine);
                    structureLine.func_74861_a(structureComponent, list, random);
                }
                if ((y >= this.heightInCellCount - 2 || (this.maze[x][y + 1] & 0x10) == 16) && connectSouth) {
                    padding = new NagaCourtyardHedgePadderComponent(this.getFeatureType(), this.maze[x][y], xBB + 4, yBB, zBB + 5, Rotation.CLOCKWISE_90);
                    list.add(padding);
                    padding.func_74861_a(structureComponent, list, random);
                    structureLine = new NagaCourtyardHedgeLineComponent(this.getFeatureType(), this.maze[x][y], xBB, yBB, zBB + 6, Rotation.CLOCKWISE_90);
                    list.add(structureLine);
                    structureLine.func_74861_a(structureComponent, list, random);
                }
                boolean hasNoTerrace = (this.maze[x][y] & 0xF) != 0;
                boolean westHasNoTerraceOrIsSafe = x == 0 || (this.maze[x - 1][y] & 0x10) == 16 || (this.maze[x - 1][y] & 0xF) != 0;
                boolean northHasNoTerraceOrIsSafe = y == 0 || (this.maze[x][y - 1] & 0x10) == 16 || (this.maze[x][y - 1] & 0xF) != 0;
                boolean eastHasNoTerraceOrIsSafe = x == this.widthInCellCount - 2 || (this.maze[x + 1][y] & 0x10) == 16;
                boolean southHasNoTerraceOrIsSafe = y == this.heightInCellCount - 2 || (this.maze[x][y + 1] & 0x10) == 16;
                boolean westNorthHasNoTerraceOrIsSafe = x == 0 || y == 0 || this.maze[x - 1][y - 1] != 0;
                boolean westSouthHasNoTerraceOrIsSafe = x == 0 || y >= this.heightInCellCount - 2 || this.maze[x - 1][y + 1] != 0;
                boolean eastNorthHasNoTerraceOrIsSafe = x >= this.widthInCellCount - 2 || y == 0 || this.maze[x + 1][y - 1] != 0;
                boolean bl2 = eastSouthHasNoTerraceOrIsSafe = x >= this.widthInCellCount - 2 || y >= this.heightInCellCount - 2 || this.maze[x + 1][y + 1] != 0;
                if (xCenter && yCenter) {
                    NagaCourtyardPathComponent path = new NagaCourtyardPathComponent(this.getFeatureType(), this.maze[x][y], xBB - 1, yBB - 1, zBB - 1);
                    list.add(path);
                    path.func_74861_a(structureComponent, list, random);
                }
                if (hasNoTerrace && westHasNoTerraceOrIsSafe && !connectWest) {
                    path2 = new NagaCourtyardPathComponent(this.getFeatureType(), this.maze[x][y], xBB - 7, yBB - 1, zBB - 1);
                    list.add(path2);
                    path2.func_74861_a(structureComponent, list, random);
                }
                if (hasNoTerrace && northHasNoTerraceOrIsSafe && !connectNorth) {
                    path2 = new NagaCourtyardPathComponent(this.getFeatureType(), this.maze[x][y], xBB - 1, yBB - 1, zBB - 7);
                    list.add(path2);
                    path2.func_74861_a(structureComponent, list, random);
                }
                if (hasNoTerrace && eastHasNoTerraceOrIsSafe) {
                    path2 = new NagaCourtyardPathComponent(this.getFeatureType(), this.maze[x][y], xBB + 5, yBB - 1, zBB - 1);
                    list.add(path2);
                    path2.func_74861_a(structureComponent, list, random);
                }
                if (hasNoTerrace && southHasNoTerraceOrIsSafe) {
                    path2 = new NagaCourtyardPathComponent(this.getFeatureType(), this.maze[x][y], xBB - 1, yBB - 1, zBB + 5);
                    list.add(path2);
                    path2.func_74861_a(structureComponent, list, random);
                }
                if (hasNoTerrace && westHasNoTerraceOrIsSafe && northHasNoTerraceOrIsSafe && westNorthHasNoTerraceOrIsSafe) {
                    path2 = new NagaCourtyardPathComponent(this.getFeatureType(), this.maze[x][y], xBB - 7, yBB - 1, zBB - 7);
                    list.add(path2);
                    path2.func_74861_a(structureComponent, list, random);
                }
                if (hasNoTerrace && westHasNoTerraceOrIsSafe && southHasNoTerraceOrIsSafe && westSouthHasNoTerraceOrIsSafe) {
                    path2 = new NagaCourtyardPathComponent(this.getFeatureType(), this.maze[x][y], xBB - 7, yBB - 1, zBB + 5);
                    list.add(path2);
                    path2.func_74861_a(structureComponent, list, random);
                }
                if (hasNoTerrace && eastHasNoTerraceOrIsSafe && northHasNoTerraceOrIsSafe && eastNorthHasNoTerraceOrIsSafe) {
                    path2 = new NagaCourtyardPathComponent(this.getFeatureType(), this.maze[x][y], xBB + 5, yBB - 1, zBB - 7);
                    list.add(path2);
                    path2.func_74861_a(structureComponent, list, random);
                }
                if (!hasNoTerrace || !eastHasNoTerraceOrIsSafe || !southHasNoTerraceOrIsSafe || !eastSouthHasNoTerraceOrIsSafe) continue;
                path2 = new NagaCourtyardPathComponent(this.getFeatureType(), this.maze[x][y], xBB + 5, yBB - 1, zBB + 5);
                list.add(path2);
                path2.func_74861_a(structureComponent, list, random);
            }
        }
    }

    private void processOuterWalls(StructurePiece structureComponent, List<StructurePiece> list, Random random, int offset, Rotation[] rotations) {
        for (Diagonals diagonal : Diagonals.values()) {
            int zBoundX = diagonal.isTop() ? this.field_74887_e.field_78896_c + this.cornerClipping[diagonal.ordinal()][0] * 12 - 3 : this.field_74887_e.field_78892_f - this.cornerClipping[diagonal.ordinal()][0] * 12 + 1;
            NagaCourtyardWallPadderComponent paddingStartX = new NagaCourtyardWallPadderComponent(this.getFeatureType(), this.cornerClipping[diagonal.ordinal()][1] * 2 + 1, diagonal.isLeft() ? this.field_74887_e.field_78897_a + 2 : this.field_74887_e.field_78893_d - 2, this.field_74887_e.field_78895_b, zBoundX, Rotation.NONE);
            list.add(paddingStartX);
            paddingStartX.func_74861_a(structureComponent, list, random);
            int xPadOffset = diagonal.isLeft() ? 11 : -1;
            for (int i = 0; i < this.cornerClipping[diagonal.ordinal()][1] - 1; ++i) {
                int xBound = diagonal.isLeft() ? this.field_74887_e.field_78897_a + i * 12 + 3 : this.field_74887_e.field_78893_d - i * 12 - 13;
                NagaCourtyardWallComponent wall = new NagaCourtyardWallComponent(this.getFeatureType(), i * 2, xBound, this.field_74887_e.field_78895_b, zBoundX, Rotation.NONE);
                list.add(wall);
                wall.func_74861_a(structureComponent, list, random);
                NagaCourtyardWallPadderComponent padding = new NagaCourtyardWallPadderComponent(this.getFeatureType(), i * 2 + 1, xBound + xPadOffset, this.field_74887_e.field_78895_b, zBoundX, Rotation.NONE);
                list.add(padding);
                padding.func_74861_a(structureComponent, list, random);
            }
            int xBoundZ = diagonal.isLeft() ? this.field_74887_e.field_78897_a + this.cornerClipping[diagonal.ordinal()][1] * 12 - 1 : this.field_74887_e.field_78893_d - this.cornerClipping[diagonal.ordinal()][1] * 12 + 3;
            NagaCourtyardWallPadderComponent paddingStartZ = new NagaCourtyardWallPadderComponent(this.getFeatureType(), this.cornerClipping[diagonal.ordinal()][1] * 2 + 1, xBoundZ, this.field_74887_e.field_78895_b, diagonal.isTop() ? this.field_74887_e.field_78896_c + 2 : this.field_74887_e.field_78892_f - 2, Rotation.CLOCKWISE_90);
            list.add(paddingStartZ);
            paddingStartZ.func_74861_a(structureComponent, list, random);
            int zPadOffset = diagonal.isTop() ? 11 : -1;
            for (int i = 0; i < this.cornerClipping[diagonal.ordinal()][0] - 1; ++i) {
                int zBound = diagonal.isTop() ? this.field_74887_e.field_78896_c + i * 12 + 3 : this.field_74887_e.field_78892_f - i * 12 - 13;
                NagaCourtyardWallComponent wall = new NagaCourtyardWallComponent(this.getFeatureType(), i * 2, xBoundZ - 10, this.field_74887_e.field_78895_b, zBound, Rotation.CLOCKWISE_90);
                list.add(wall);
                wall.func_74861_a(structureComponent, list, random);
                NagaCourtyardWallPadderComponent padding = new NagaCourtyardWallPadderComponent(this.getFeatureType(), i * 2 + 1, xBoundZ, this.field_74887_e.field_78895_b, zBound + zPadOffset, Rotation.CLOCKWISE_90);
                list.add(padding);
                padding.func_74861_a(structureComponent, list, random);
            }
            int wallCornerInnerX = this.field_74887_e.field_78897_a + diagonal.operationX.convert(this.cornerClipping[diagonal.ordinal()][1], this.widthInCellCount - 1) * 12 + (diagonal.isLeft() ? -3 : 3);
            int wallCornerInnerZ = this.field_74887_e.field_78896_c + diagonal.operationY.convert(this.cornerClipping[diagonal.ordinal()][0], this.heightInCellCount - 1) * 12 + (diagonal.isTop() ? -3 : 3);
            NagaCourtyardWallCornerComponent corner1 = new NagaCourtyardWallCornerComponent(this.getFeatureType(), diagonal.ordinal() * 3, wallCornerInnerX, this.field_74887_e.field_78895_b, diagonal.isTop() ? this.field_74887_e.field_78896_c - 3 : this.field_74887_e.field_78892_f - 1, rotations[diagonal.ordinal() % rotations.length]);
            list.add(corner1);
            corner1.func_74861_a(structureComponent, list, random);
            NagaCourtyardWallCornerComponent corner2 = new NagaCourtyardWallCornerComponent(this.getFeatureType(), diagonal.ordinal() * 3 + 1, diagonal.isLeft() ? this.field_74887_e.field_78897_a - 3 : this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b, wallCornerInnerZ, rotations[diagonal.ordinal() % rotations.length]);
            list.add(corner2);
            corner2.func_74861_a(structureComponent, list, random);
            NagaCourtyardWallCornerAltComponent innerCorner = new NagaCourtyardWallCornerAltComponent(this.getFeatureType(), diagonal.ordinal() * 3 + 3, wallCornerInnerX + (diagonal.isLeft() ? -6 : 2), this.field_74887_e.field_78895_b, wallCornerInnerZ + (diagonal.isTop() ? -6 : 2), rotations[diagonal.ordinal() % rotations.length]);
            list.add(innerCorner);
            innerCorner.func_74861_a(structureComponent, list, random);
        }
        for (int i = this.cornerClipping[3][1]; i < this.widthInCellCount - 1 - this.cornerClipping[0][1]; ++i) {
            NagaCourtyardWallComponent wall = new NagaCourtyardWallComponent(this.getFeatureType(), i, this.field_74887_e.field_78897_a + i * 12 + offset - 3, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 3, Rotation.NONE);
            list.add(wall);
            wall.func_74861_a(structureComponent, list, random);
            NagaCourtyardWallPadderComponent padding = new NagaCourtyardWallPadderComponent(this.getFeatureType(), i, this.field_74887_e.field_78897_a + i * 12 + offset - 4, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 3, Rotation.NONE);
            list.add(padding);
            padding.func_74861_a(structureComponent, list, random);
        }
        NagaCourtyardWallPadderComponent padding2 = new NagaCourtyardWallPadderComponent(this.getFeatureType(), this.widthInCellCount - 1 - this.cornerClipping[0][1], this.field_74887_e.field_78897_a + (this.widthInCellCount - 1 - this.cornerClipping[0][1]) * 12 + offset - 4, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 3, Rotation.NONE);
        list.add(padding2);
        padding2.func_74861_a(structureComponent, list, random);
        for (int i = this.cornerClipping[2][1]; i < this.widthInCellCount - 1 - this.cornerClipping[1][1]; ++i) {
            NagaCourtyardWallComponent wall = new NagaCourtyardWallComponent(this.getFeatureType(), i, this.field_74887_e.field_78897_a + i * 12 + offset - 3, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Rotation.NONE);
            list.add(wall);
            wall.func_74861_a(structureComponent, list, random);
            NagaCourtyardWallPadderComponent padding = new NagaCourtyardWallPadderComponent(this.getFeatureType(), i, this.field_74887_e.field_78897_a + i * 12 + offset - 4, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Rotation.NONE);
            list.add(padding);
            padding.func_74861_a(structureComponent, list, random);
        }
        NagaCourtyardWallPadderComponent padding5 = new NagaCourtyardWallPadderComponent(this.getFeatureType(), this.widthInCellCount - 1 - this.cornerClipping[1][1], this.field_74887_e.field_78897_a + (this.widthInCellCount - 1 - this.cornerClipping[1][1]) * 12 + offset - 4, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Rotation.NONE);
        list.add(padding5);
        padding5.func_74861_a(structureComponent, list, random);
        for (int i = this.cornerClipping[3][0]; i < this.heightInCellCount - 1 - this.cornerClipping[2][0]; ++i) {
            NagaCourtyardWallComponent wall = new NagaCourtyardWallComponent(this.getFeatureType(), i, this.field_74887_e.field_78897_a - 11, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + i * 12 + offset - 3, Rotation.CLOCKWISE_90);
            list.add(wall);
            wall.func_74861_a(structureComponent, list, random);
            NagaCourtyardWallPadderComponent padding = new NagaCourtyardWallPadderComponent(this.getFeatureType(), i, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + i * 12 + offset - 4, Rotation.CLOCKWISE_90);
            list.add(padding);
            padding.func_74861_a(structureComponent, list, random);
        }
        NagaCourtyardWallPadderComponent padding8 = new NagaCourtyardWallPadderComponent(this.getFeatureType(), this.heightInCellCount - 1 - this.cornerClipping[2][0], this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (this.heightInCellCount - 1 - this.cornerClipping[2][0]) * 12 + offset - 4, Rotation.CLOCKWISE_90);
        list.add(padding8);
        padding8.func_74861_a(structureComponent, list, random);
        for (int i = this.cornerClipping[0][0]; i < this.heightInCellCount - 1 - this.cornerClipping[1][0]; ++i) {
            NagaCourtyardWallComponent wall = new NagaCourtyardWallComponent(this.getFeatureType(), i, this.field_74887_e.field_78893_d - 7, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + i * 12 + offset - 3, Rotation.CLOCKWISE_90);
            list.add(wall);
            wall.func_74861_a(structureComponent, list, random);
            NagaCourtyardWallPadderComponent padding = new NagaCourtyardWallPadderComponent(this.getFeatureType(), i, this.field_74887_e.field_78893_d + 3, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + i * 12 + offset - 4, Rotation.CLOCKWISE_90);
            list.add(padding);
            padding.func_74861_a(structureComponent, list, random);
        }
        NagaCourtyardWallPadderComponent padding11 = new NagaCourtyardWallPadderComponent(this.getFeatureType(), this.heightInCellCount - 1 - this.cornerClipping[1][0], this.field_74887_e.field_78893_d + 3, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (this.heightInCellCount - 1 - this.cornerClipping[1][0]) * 12 + offset - 4, Rotation.CLOCKWISE_90);
        list.add(padding11);
        padding11.func_74861_a(structureComponent, list, random);
    }

    private static String getStringFromFacings(int directions) {
        switch (directions & 0xF) {
            case 2: {
                return " \u2577 ";
            }
            case 1: {
                return " \u2576\u2500";
            }
            case 8: {
                return " \u2575 ";
            }
            case 4: {
                return "\u2500\u2574 ";
            }
            case 9: {
                return " \u2514\u2500";
            }
            case 12: {
                return "\u2500\u2518 ";
            }
            case 6: {
                return "\u2500\u2510 ";
            }
            case 3: {
                return " \u250c\u2500";
            }
            case 13: {
                return "\u2500\u2534\u2500";
            }
            case 14: {
                return "\u2500\u2524 ";
            }
            case 7: {
                return "\u2500\u252c\u2500";
            }
            case 11: {
                return " \u251c\u2500";
            }
            case 10: {
                return " \u2502 ";
            }
            case 5: {
                return "\u2500\u2500\u2500";
            }
            case 15: {
                return "\u2500\u253c\u2500";
            }
        }
        return " \u2022 ";
    }

    @Override
    protected void func_143011_b(CompoundNBT tagCompound) {
        super.func_143011_b(tagCompound);
        ListNBT mazeX = new ListNBT();
        for (int x = 0; x < this.widthInCellCount - 1; ++x) {
            ListNBT mazeY = new ListNBT();
            for (int y = 0; y < this.heightInCellCount - 1; ++y) {
                mazeY.add((Object)IntNBT.func_229692_a_((int)this.maze[x][y]));
            }
            mazeX.add((Object)mazeY);
        }
        tagCompound.func_74768_a("mazeWidth", this.widthInCellCount);
        tagCompound.func_74768_a("mazeHeight", this.heightInCellCount);
        tagCompound.func_218657_a("maze", (INBT)mazeX);
    }

    protected static enum WallFacing {
        EAST(1, 4, 14, 11, Direction.EAST, 1, 0),
        SOUTH(2, 8, 13, 7, Direction.SOUTH, 0, 1),
        WEST(4, 1, 11, 14, Direction.WEST, -1, 0),
        NORTH(8, 2, 7, 13, Direction.NORTH, 0, -1);

        private final int BYTE;
        private final int OPPOSITE;
        private final int INVERTED;
        private final int INVERTED_OPPOSITE;
        private final int xOffset;
        private final int zOffset;

        private WallFacing(int bite, int oppositeBite, int inverted, int invertedOpposite, Direction enumFacing, int xOffset, int zOffset) {
            this.BYTE = bite;
            this.OPPOSITE = oppositeBite;
            this.INVERTED = inverted;
            this.INVERTED_OPPOSITE = invertedOpposite;
            this.xOffset = xOffset;
            this.zOffset = zOffset;
        }

        protected boolean unpackAndTest(int directions) {
            return (this.BYTE & directions) == this.BYTE;
        }
    }
}

