/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import twilightforest.inventory.UncraftingContainer;

public class UncraftingGuiPacket {
    private int type;

    public UncraftingGuiPacket(int type) {
        this.type = type;
    }

    public UncraftingGuiPacket(PacketBuffer buf) {
        this.type = buf.readInt();
    }

    public void encode(PacketBuffer buf) {
        buf.writeInt(this.type);
    }

    public static class Handler {
        public static boolean onMessage(final UncraftingGuiPacket message, Supplier<NetworkEvent.Context> ctx) {
            final ServerPlayerEntity player = ctx.get().getSender();
            ctx.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    Container container = player.field_71070_bA;
                    if (container instanceof UncraftingContainer) {
                        UncraftingContainer uncrafting = (UncraftingContainer)container;
                        switch (message.type) {
                            case 0: {
                                ++uncrafting.unrecipeInCycle;
                                break;
                            }
                            case 1: {
                                --uncrafting.unrecipeInCycle;
                                break;
                            }
                            case 2: {
                                ++uncrafting.ingredientsInCycle;
                                break;
                            }
                            case 3: {
                                --uncrafting.ingredientsInCycle;
                                break;
                            }
                            case 4: {
                                ++uncrafting.recipeInCycle;
                                break;
                            }
                            case 5: {
                                --uncrafting.recipeInCycle;
                            }
                        }
                        if (message.type < 4) {
                            uncrafting.func_75130_a(uncrafting.tinkerInput);
                        }
                        if (message.type >= 4) {
                            uncrafting.func_75130_a((IInventory)uncrafting.assemblyMatrix);
                        }
                    }
                }
            });
            return true;
        }
    }
}

