/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.enums;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.state.Property;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import twilightforest.block.TFBlocks;

public enum StructureWoodVariant implements IStringSerializable
{
    OAK(Blocks.field_196662_n, Blocks.field_150476_ad, Blocks.field_196622_bq, Blocks.field_196689_eF, Blocks.field_180407_aO, Blocks.field_180390_bo, Blocks.field_196663_cq),
    SPRUCE(Blocks.field_196664_o, Blocks.field_150485_bF, Blocks.field_196624_br, Blocks.field_196691_eG, Blocks.field_180408_aP, Blocks.field_180391_bp, Blocks.field_196665_cr),
    BIRCH(Blocks.field_196666_p, Blocks.field_150487_bG, Blocks.field_196627_bs, Blocks.field_196693_eH, Blocks.field_180404_aQ, Blocks.field_180392_bq, Blocks.field_196667_cs),
    JUNGLE(Blocks.field_196668_q, Blocks.field_150481_bH, Blocks.field_196630_bt, Blocks.field_196695_eI, Blocks.field_180403_aR, Blocks.field_180386_br, Blocks.field_196669_ct),
    ACACIA(Blocks.field_196670_r, Blocks.field_150400_ck, Blocks.field_196632_bu, Blocks.field_196697_eJ, Blocks.field_180405_aT, Blocks.field_180387_bt, Blocks.field_196671_cu),
    DARK_OAK(Blocks.field_196672_s, Blocks.field_150401_cl, Blocks.field_196635_bv, Blocks.field_196699_eK, Blocks.field_180406_aS, Blocks.field_180385_bs, Blocks.field_196673_cv),
    TWILIGHT_OAK((Supplier<Block>)TFBlocks.twilight_oak_planks, (Supplier<StairsBlock>)TFBlocks.twilight_oak_stairs, (Supplier<Block>)TFBlocks.twilight_oak_slab, (Supplier<Block>)TFBlocks.twilight_oak_button, (Supplier<Block>)TFBlocks.twilight_oak_fence, (Supplier<Block>)TFBlocks.twilight_oak_gate, (Supplier<Block>)TFBlocks.twilight_oak_plate),
    CANOPY((Supplier<Block>)TFBlocks.canopy_planks, (Supplier<StairsBlock>)TFBlocks.canopy_stairs, (Supplier<Block>)TFBlocks.canopy_slab, (Supplier<Block>)TFBlocks.canopy_button, (Supplier<Block>)TFBlocks.canopy_fence, (Supplier<Block>)TFBlocks.canopy_gate, (Supplier<Block>)TFBlocks.canopy_plate),
    MANGROVE((Supplier<Block>)TFBlocks.mangrove_planks, (Supplier<StairsBlock>)TFBlocks.mangrove_stairs, (Supplier<Block>)TFBlocks.mangrove_slab, (Supplier<Block>)TFBlocks.mangrove_button, (Supplier<Block>)TFBlocks.mangrove_fence, (Supplier<Block>)TFBlocks.mangrove_gate, (Supplier<Block>)TFBlocks.mangrove_plate),
    DARK((Supplier<Block>)TFBlocks.dark_planks, (Supplier<StairsBlock>)TFBlocks.dark_stairs, (Supplier<Block>)TFBlocks.dark_slab, (Supplier<Block>)TFBlocks.dark_button, (Supplier<Block>)TFBlocks.dark_fence, (Supplier<Block>)TFBlocks.dark_gate, (Supplier<Block>)TFBlocks.dark_plate),
    TIME((Supplier<Block>)TFBlocks.time_planks, (Supplier<StairsBlock>)TFBlocks.time_stairs, (Supplier<Block>)TFBlocks.time_slab, (Supplier<Block>)TFBlocks.time_button, (Supplier<Block>)TFBlocks.time_fence, (Supplier<Block>)TFBlocks.time_gate, (Supplier<Block>)TFBlocks.time_plate),
    TRANS((Supplier<Block>)TFBlocks.trans_planks, (Supplier<StairsBlock>)TFBlocks.trans_stairs, (Supplier<Block>)TFBlocks.trans_slab, (Supplier<Block>)TFBlocks.trans_button, (Supplier<Block>)TFBlocks.trans_fence, (Supplier<Block>)TFBlocks.trans_gate, (Supplier<Block>)TFBlocks.trans_plate),
    MINE((Supplier<Block>)TFBlocks.mine_planks, (Supplier<StairsBlock>)TFBlocks.mine_stairs, (Supplier<Block>)TFBlocks.mine_slab, (Supplier<Block>)TFBlocks.mine_button, (Supplier<Block>)TFBlocks.mine_fence, (Supplier<Block>)TFBlocks.mine_gate, (Supplier<Block>)TFBlocks.mine_plate),
    SORT((Supplier<Block>)TFBlocks.sort_planks, (Supplier<StairsBlock>)TFBlocks.sort_stairs, (Supplier<Block>)TFBlocks.sort_slab, (Supplier<Block>)TFBlocks.sort_button, (Supplier<Block>)TFBlocks.sort_fence, (Supplier<Block>)TFBlocks.sort_gate, (Supplier<Block>)TFBlocks.sort_plate);

    private final List<Block> blocks;
    private final Block planks;
    private final Block stairs;
    private final Block slab;
    private final Block button;
    private final Block fence;
    private final Block gate;
    private final Block plate;

    private StructureWoodVariant(Block planks, Block stairs, Block slab, Block button, Block fence, Block gate, Block plate) {
        this.planks = planks;
        this.stairs = stairs;
        this.slab = slab;
        this.button = button;
        this.fence = fence;
        this.gate = gate;
        this.plate = plate;
        this.blocks = Arrays.asList(planks, stairs, slab, button, fence, gate, plate);
    }

    private StructureWoodVariant(Supplier<Block> planks, Supplier<StairsBlock> stairs, Supplier<Block> slab, Supplier<Block> button, Supplier<Block> fence, Supplier<Block> gate, Supplier<Block> plate) {
        this.planks = planks.get();
        this.stairs = (Block)stairs.get();
        this.slab = slab.get();
        this.button = button.get();
        this.fence = fence.get();
        this.gate = gate.get();
        this.plate = plate.get();
        this.blocks = Arrays.asList(planks.get(), (Block)stairs.get(), slab.get(), button.get(), fence.get(), gate.get(), plate.get());
    }

    public String func_176610_l() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Nullable
    public static StructureWoodVariant getVariantFromBlock(Block block) {
        for (StructureWoodVariant var : StructureWoodVariant.values()) {
            if (!var.blocks.contains(block)) continue;
            return var;
        }
        return null;
    }

    public static boolean isPlanks(BlockState stateIn) {
        return StructureWoodVariant.isPlanks(stateIn.func_177230_c());
    }

    public static boolean isPlanks(Block block) {
        StructureWoodVariant var = StructureWoodVariant.getVariantFromBlock(block);
        if (var == null) {
            return false;
        }
        return var.planks == block;
    }

    public static BlockState modifyBlockWithType(BlockState stateIn, StructureWoodVariant target) {
        Block block = stateIn.func_177230_c();
        WoodShapes shape = StructureWoodVariant.getWoodShapeFromBlock(block);
        ResourceLocation blockRegName = block.getRegistryName();
        if (blockRegName == null) {
            return stateIn;
        }
        if (StructureWoodVariant.isPlanks(stateIn)) {
            shape = WoodShapes.BLOCK;
        }
        if (shape == WoodShapes.INVALID || !"minecraft".equals(blockRegName.func_110624_b()) && !"twilightforest".equals(blockRegName.func_110624_b())) {
            return stateIn;
        }
        switch (shape) {
            case BLOCK: {
                return target.planks.func_176223_P();
            }
            case STAIRS: {
                return StructureWoodVariant.transferStateKeys(stateIn, target.stairs.func_176223_P(), new Property[]{StairsBlock.field_176309_a, StairsBlock.field_176308_b, StairsBlock.field_176310_M});
            }
            case SLAB: {
                return StructureWoodVariant.transferStateKey(stateIn, target.slab.func_176223_P(), SlabBlock.field_196505_a);
            }
            case DOUBLESLAB: {
                return (BlockState)target.slab.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE);
            }
            case FENCE: {
                return StructureWoodVariant.transferStateKeys(stateIn, target.fence.func_176223_P(), new Property[]{FenceBlock.field_196409_a, FenceBlock.field_196411_b, FenceBlock.field_196414_y, FenceBlock.field_196413_c});
            }
            case GATE: {
                return StructureWoodVariant.transferStateKeys(stateIn, target.gate.func_176223_P(), new Property[]{FenceGateBlock.field_185512_D, FenceGateBlock.field_176466_a, FenceGateBlock.field_176465_b, FenceGateBlock.field_176467_M});
            }
            case BUTTON: {
                return StructureWoodVariant.transferStateKeys(stateIn, target.button.func_176223_P(), new Property[]{HorizontalFaceBlock.field_196366_M, AbstractButtonBlock.field_176584_b});
            }
            case PLATE: {
                return StructureWoodVariant.transferStateKey(stateIn, target.plate.func_176223_P(), PressurePlateBlock.field_176580_a);
            }
        }
        return stateIn;
    }

    public static BlockState transferStateKeys(BlockState stateIn, BlockState stateOut, Property<?> ... properties) {
        for (Property<?> property : properties) {
            stateOut = StructureWoodVariant.transferStateKey(stateIn, stateOut, property);
        }
        return stateOut;
    }

    public static <T extends Comparable<T>> BlockState transferStateKey(BlockState stateIn, BlockState stateOut, Property<T> property) {
        return (BlockState)stateOut.func_206870_a(property, stateIn.func_177229_b(property));
    }

    public static WoodShapes getWoodShapeFromBlock(Block b) {
        if (StructureWoodVariant.isPlanks(b)) {
            return WoodShapes.BLOCK;
        }
        if (b instanceof StairsBlock) {
            return WoodShapes.STAIRS;
        }
        if (b instanceof SlabBlock) {
            if (b.func_176223_P().func_177229_b((Property)SlabBlock.field_196505_a) == SlabType.DOUBLE) {
                return WoodShapes.DOUBLESLAB;
            }
            return WoodShapes.SLAB;
        }
        if (b instanceof AbstractButtonBlock) {
            return WoodShapes.BUTTON;
        }
        if (b instanceof FenceBlock) {
            return WoodShapes.FENCE;
        }
        if (b instanceof FenceGateBlock) {
            return WoodShapes.GATE;
        }
        if (b instanceof PressurePlateBlock) {
            return WoodShapes.PLATE;
        }
        return WoodShapes.INVALID;
    }

    public static enum WoodShapes {
        BLOCK,
        STAIRS,
        SLAB,
        DOUBLESLAB,
        BUTTON,
        FENCE,
        GATE,
        PLATE,
        INVALID;

    }
}

