/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import twilightforest.TFFeature;
import twilightforest.TFSounds;

public class HedgeSpiderEntity
extends SpiderEntity {
    public HedgeSpiderEntity(EntityType<? extends HedgeSpiderEntity> type, World world) {
        super(type, world);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.field_220892_d.removeIf(t -> t.func_220772_j() instanceof MeleeAttackGoal);
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true){

            protected double func_179512_a(LivingEntity attackTarget) {
                return 4.0f + attackTarget.func_213311_cf();
            }
        });
        this.field_70715_bh.field_220892_d.removeIf(t -> t.func_220770_h() == 2 && t.func_220772_j() instanceof NearestAttackableTargetGoal);
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public static boolean isValidLightLevel(IServerWorld world, BlockPos pos, Random random) {
        int chunkZ;
        int chunkX = MathHelper.func_76141_d((float)pos.func_177958_n()) >> 4;
        return TFFeature.getNearestFeature(chunkX, chunkZ = MathHelper.func_76141_d((float)pos.func_177952_p()) >> 4, (ISeedReader)((ServerWorld)world)) == TFFeature.HEDGE_MAZE || MonsterEntity.func_223323_a((IServerWorld)world, (BlockPos)pos, (Random)random);
    }

    protected SoundEvent func_184639_G() {
        return TFSounds.HEDGE_SPIDER_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return TFSounds.HEDGE_SPIDER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return TFSounds.HEDGE_SPIDER_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(TFSounds.HEDGE_SPIDER_STEP, 0.15f, 1.0f);
    }

    public static boolean canSpawn(EntityType<HedgeSpiderEntity> entity, IServerWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return world.func_175659_aa() != Difficulty.PEACEFUL && HedgeSpiderEntity.isValidLightLevel(world, pos, random);
    }
}

