/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import twilightforest.TwilightForestMod;
import twilightforest.client.model.entity.HydraHeadModel;
import twilightforest.client.renderer.entity.TFPartRenderer;
import twilightforest.entity.boss.HydraEntity;
import twilightforest.entity.boss.HydraHeadContainer;
import twilightforest.entity.boss.HydraHeadEntity;

public class HydraHeadRenderer
extends TFPartRenderer<HydraHeadEntity, HydraHeadModel> {
    private static final ResourceLocation textureLoc = TwilightForestMod.getModelTexture("hydra4.png");

    public HydraHeadRenderer(EntityRendererManager manager) {
        super(manager, new HydraHeadModel());
    }

    @Override
    public void render(HydraHeadEntity entity, float yaw, float partialTicks, MatrixStack stack, IRenderTypeBuffer buffer, int light) {
        HydraHeadContainer headCon = HydraHeadRenderer.getHeadObject(entity);
        if (headCon != null) {
            if (headCon.shouldRenderHead()) {
                stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-180.0f));
                super.render(entity, yaw, partialTicks, stack, buffer, light);
            }
        } else {
            super.render(entity, yaw, partialTicks, stack, buffer, light);
        }
    }

    @Nullable
    public static HydraHeadContainer getHeadObject(HydraHeadEntity entity) {
        HydraEntity hydra = (HydraEntity)entity.getParent();
        if (hydra != null) {
            for (int i = 0; i < hydra.numHeads; ++i) {
                if (hydra.hc[i].headEntity != entity) continue;
                return hydra.hc[i];
            }
        }
        return null;
    }

    public ResourceLocation getEntityTexture(HydraHeadEntity entity) {
        return textureLoc;
    }
}

