/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import twilightforest.TwilightForestMod;
import twilightforest.client.model.entity.ChainModel;
import twilightforest.client.model.entity.SpikeBlockModel;
import twilightforest.entity.ChainBlockEntity;

public class BlockChainRenderer
extends EntityRenderer<ChainBlockEntity> {
    private static final ResourceLocation textureLoc = TwilightForestMod.getModelTexture("blockgoblin.png");
    private final Model model = new SpikeBlockModel();
    private final Model chainModel = new ChainModel();

    public BlockChainRenderer(EntityRendererManager manager) {
        super(manager);
    }

    public void render(ChainBlockEntity chainBlock, float yaw, float partialTicks, MatrixStack stack, IRenderTypeBuffer buffer, int light) {
        super.func_225623_a_((Entity)chainBlock, yaw, partialTicks, stack, buffer, light);
        stack.func_227860_a_();
        IVertexBuilder ivertexbuilder = buffer.getBuffer(this.model.func_228282_a_(textureLoc));
        float pitch = chainBlock.field_70127_C + (chainBlock.field_70125_A - chainBlock.field_70127_C) * partialTicks;
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - MathHelper.func_76142_g((float)yaw)));
        stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(pitch));
        stack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        this.model.func_225598_a_(stack, ivertexbuilder, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        stack.func_227865_b_();
        BlockChainRenderer.renderChain((Entity)chainBlock, (Entity)chainBlock.chain1, yaw, partialTicks, stack, buffer, light, this.chainModel);
        BlockChainRenderer.renderChain((Entity)chainBlock, (Entity)chainBlock.chain2, yaw, partialTicks, stack, buffer, light, this.chainModel);
        BlockChainRenderer.renderChain((Entity)chainBlock, (Entity)chainBlock.chain3, yaw, partialTicks, stack, buffer, light, this.chainModel);
        BlockChainRenderer.renderChain((Entity)chainBlock, (Entity)chainBlock.chain4, yaw, partialTicks, stack, buffer, light, this.chainModel);
        BlockChainRenderer.renderChain((Entity)chainBlock, (Entity)chainBlock.chain5, yaw, partialTicks, stack, buffer, light, this.chainModel);
    }

    static void renderChain(Entity parent, Entity chain, float yaw, float partialTicks, MatrixStack stack, IRenderTypeBuffer buffer, int light, Model chainModel) {
        double chainInX = MathHelper.func_219803_d((double)partialTicks, (double)chain.field_70142_S, (double)chain.func_226277_ct_()) - MathHelper.func_219803_d((double)partialTicks, (double)parent.field_70142_S, (double)parent.func_226277_ct_());
        double chainInY = MathHelper.func_219803_d((double)partialTicks, (double)chain.field_70137_T, (double)chain.func_226278_cu_()) - MathHelper.func_219803_d((double)partialTicks, (double)parent.field_70137_T, (double)parent.func_226278_cu_());
        double chainInZ = MathHelper.func_219803_d((double)partialTicks, (double)chain.field_70136_U, (double)chain.func_226281_cx_()) - MathHelper.func_219803_d((double)partialTicks, (double)parent.field_70136_U, (double)parent.func_226281_cx_());
        stack.func_227860_a_();
        IVertexBuilder ivertexbuilder = buffer.getBuffer(chainModel.func_228282_a_(textureLoc));
        stack.func_227861_a_(chainInX, chainInY, chainInZ);
        float pitch = chain.field_70127_C + (chain.field_70125_A - chain.field_70127_C) * partialTicks;
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - MathHelper.func_76142_g((float)yaw)));
        stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(pitch));
        stack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        chainModel.func_225598_a_(stack, ivertexbuilder, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        stack.func_227865_b_();
    }

    private void renderMultiBoundingBox(MatrixStack stack, IVertexBuilder builder, Entity entity, float red, float grean, float blue) {
        AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_72317_d(-entity.func_226277_ct_(), -entity.func_226278_cu_(), -entity.func_226281_cx_());
        WorldRenderer.func_228430_a_((MatrixStack)stack, (IVertexBuilder)builder, (AxisAlignedBB)axisalignedbb, (float)red, (float)grean, (float)blue, (float)1.0f);
    }

    public ResourceLocation getEntityTexture(ChainBlockEntity entity) {
        return textureLoc;
    }
}

