/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.LivingEntity;
import twilightforest.capabilities.CapabilityList;
import twilightforest.entity.boss.LichEntity;

public enum RenderEffect {
    SHIELDS{

        @Override
        public boolean shouldRender(LivingEntity entity, boolean firstPerson) {
            if (entity instanceof LichEntity) {
                return false;
            }
            return entity.getCapability(CapabilityList.SHIELDS).map(c -> c.shieldsLeft() > 0).orElse(false);
        }

        @Override
        public void render(LivingEntity entity, EntityModel<? extends LivingEntity> renderer, double x, double y, double z, float partialTicks, boolean firstPerson) {
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)x, (double)y, (double)z);
            RenderSystem.rotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            RenderSystem.translatef((float)0.0f, (float)(0.5f - entity.func_70047_e()), (float)0.0f);
            RenderSystem.enableBlend();
            RenderSystem.disableCull();
            RenderSystem.blendFunc((int)770, (int)771);
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            RenderSystem.popMatrix();
        }
    };

    static final RenderEffect[] VALUES;

    public boolean shouldRender(LivingEntity entity, boolean firstPerson) {
        return false;
    }

    public void render(LivingEntity entity, EntityModel<? extends LivingEntity> renderer, double x, double y, double z, float partialTicks, boolean firstPerson) {
    }

    static {
        VALUES = RenderEffect.values();
    }
}

