/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import twilightforest.TFSounds;
import twilightforest.block.LockedVanishingBlock;
import twilightforest.block.TFBlocks;

public class VanishingBlock
extends Block {
    public static final BooleanProperty ACTIVE = BooleanProperty.func_177716_a((String)"active");
    public static final BooleanProperty VANISHED = BooleanProperty.func_177716_a((String)"vanished");
    private static final VoxelShape VANISHED_SHAPE = VanishingBlock.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);

    public VanishingBlock(AbstractBlock.Properties props) {
        super(props);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{ACTIVE});
    }

    private boolean isVanished(BlockState state) {
        return state.func_235901_b_((Property)VANISHED) && (Boolean)state.func_177229_b((Property)VANISHED) != false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return this.isVanished(state) ? VANISHED_SHAPE : super.func_220053_a(state, world, pos, ctx);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return this.isVanished(state) ? VoxelShapes.func_197880_a() : super.func_220071_b(state, world, pos, ctx);
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!this.isVanished(state) && !((Boolean)state.func_177229_b((Property)ACTIVE)).booleanValue()) {
            if (VanishingBlock.areBlocksLocked((IBlockReader)world, pos)) {
                world.func_184133_a(null, pos, TFSounds.LOCKED_VANISHING_BLOCK, SoundCategory.BLOCKS, 1.0f, 0.3f);
            } else {
                this.activate(world, pos);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public float getExplosionResistance(BlockState state, IBlockReader world, BlockPos pos, Explosion explosion) {
        return (Boolean)state.func_177229_b((Property)ACTIVE) == false ? 6000.0f : super.getExplosionResistance(state, world, pos, explosion);
    }

    public boolean canEntityDestroy(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        return !((Boolean)state.func_177229_b((Property)ACTIVE)).booleanValue() ? !VanishingBlock.areBlocksLocked(world, pos) : super.canEntityDestroy(state, world, pos, entity);
    }

    private static boolean areBlocksLocked(IBlockReader world, BlockPos start) {
        int limit = 512;
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        queue.offer(start);
        for (int iter = 0; !queue.isEmpty() && iter < limit; ++iter) {
            BlockPos cur = (BlockPos)queue.pop();
            BlockState state = world.func_180495_p(cur);
            if (state.func_177230_c() == TFBlocks.locked_vanishing_block.get() && ((Boolean)state.func_177229_b((Property)LockedVanishingBlock.LOCKED)).booleanValue()) {
                return true;
            }
            checked.add(cur);
            if (!(state.func_177230_c() instanceof VanishingBlock)) continue;
            for (Direction facing : Direction.values()) {
                BlockPos neighbor = cur.func_177972_a(facing);
                if (checked.contains(neighbor)) continue;
                queue.offer(neighbor);
            }
        }
        return false;
    }

    @Deprecated
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (world.field_72995_K) {
            return;
        }
        if (!this.isVanished(state) && !((Boolean)state.func_177229_b((Property)ACTIVE)).booleanValue() && world.func_175640_z(pos) && !VanishingBlock.areBlocksLocked((IBlockReader)world, pos)) {
            this.activate(world, pos);
        }
    }

    @Deprecated
    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (world.field_72995_K) {
            return;
        }
        if (this.isVanished(state)) {
            if (((Boolean)state.func_177229_b((Property)ACTIVE)).booleanValue()) {
                world.func_175656_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)VANISHED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
            } else {
                world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
                world.func_205220_G_().func_205360_a(pos, (Object)this, 15);
            }
            world.func_184133_a(null, pos, TFSounds.REAPPEAR_BLOCK, SoundCategory.BLOCKS, 0.3f, 0.6f);
        } else if (((Boolean)state.func_177229_b((Property)ACTIVE)).booleanValue()) {
            if (state.func_235901_b_((Property)VANISHED)) {
                world.func_175656_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)VANISHED, (Comparable)Boolean.valueOf(true)));
                world.func_205220_G_().func_205360_a(pos, (Object)this, 80);
            } else {
                world.func_217377_a(pos, false);
            }
            world.func_184133_a(null, pos, state.func_177230_c() == TFBlocks.reappearing_block.get() ? TFSounds.REAPPEAR_POOF : TFSounds.VANISHING_BLOCK, SoundCategory.BLOCKS, 0.3f, 0.5f);
            for (Direction e : Direction.values()) {
                this.activate((World)world, pos.func_177972_a(e));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        if (((Boolean)state.func_177229_b((Property)ACTIVE)).booleanValue()) {
            this.sparkle(world, pos);
        }
    }

    public void sparkle(World worldIn, BlockPos pos) {
        Random random = worldIn.field_73012_v;
        double d0 = 0.0625;
        for (int i = 0; i < 6; ++i) {
            double d1 = (float)pos.func_177958_n() + random.nextFloat();
            double d2 = (float)pos.func_177956_o() + random.nextFloat();
            double d3 = (float)pos.func_177952_p() + random.nextFloat();
            if (i == 0 && !worldIn.func_180495_p(pos.func_177984_a()).func_200015_d((IBlockReader)worldIn, pos)) {
                d2 = (double)pos.func_177956_o() + d0 + 1.0;
            }
            if (i == 1 && !worldIn.func_180495_p(pos.func_177977_b()).func_200015_d((IBlockReader)worldIn, pos)) {
                d2 = (double)pos.func_177956_o() - d0;
            }
            if (i == 2 && !worldIn.func_180495_p(pos.func_177968_d()).func_200015_d((IBlockReader)worldIn, pos)) {
                d3 = (double)pos.func_177952_p() + d0 + 1.0;
            }
            if (i == 3 && !worldIn.func_180495_p(pos.func_177978_c()).func_200015_d((IBlockReader)worldIn, pos)) {
                d3 = (double)pos.func_177952_p() - d0;
            }
            if (i == 4 && !worldIn.func_180495_p(pos.func_177974_f()).func_200015_d((IBlockReader)worldIn, pos)) {
                d1 = (double)pos.func_177958_n() + d0 + 1.0;
            }
            if (i == 5 && !worldIn.func_180495_p(pos.func_177976_e()).func_200015_d((IBlockReader)worldIn, pos)) {
                d1 = (double)pos.func_177958_n() - d0;
            }
            float f1 = 1.0f;
            float f2 = Math.max(0.0f, 0.19999999f);
            float f3 = Math.max(0.0f, -0.099999964f);
            if (!(d1 < (double)pos.func_177958_n() || d1 > (double)(pos.func_177958_n() + 1) || d2 < 0.0 || d2 > (double)(pos.func_177956_o() + 1) || d3 < (double)pos.func_177952_p()) && !(d3 > (double)(pos.func_177952_p() + 1))) continue;
            worldIn.func_195594_a((IParticleData)new RedstoneParticleData(f1, f2, f3, 1.0f), d1, d2, d3, 0.0, 0.0, 0.0);
        }
    }

    private void activate(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof VanishingBlock && !this.isVanished(state) && !((Boolean)state.func_177229_b((Property)ACTIVE)).booleanValue()) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
            world.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), 2 + world.field_73012_v.nextInt(5));
        }
    }
}

