/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import twilightforest.block.ConnectableRotatedPillarBlock;
import twilightforest.block.TFBlocks;
import twilightforest.util.TFDamageSources;

public class ThornsBlock
extends ConnectableRotatedPillarBlock
implements IWaterLoggable {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final float THORN_DAMAGE = 4.0f;

    ThornsBlock(AbstractBlock.Properties props) {
        super(props, 10.0);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public boolean canConnectTo(BlockState state, boolean solidSide) {
        return state.func_177230_c() instanceof ThornsBlock || state.func_177230_c() == TFBlocks.thorn_rose.get() || state.func_177230_c() == TFBlocks.thorn_leaves.get() || state.func_185904_a() == Material.field_151585_k || state.func_185904_a() == Material.field_151578_c;
    }

    @Nullable
    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, @Nullable MobEntity entity) {
        return PathNodeType.DAMAGE_CACTUS;
    }

    @Deprecated
    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entity) {
        entity.func_70097_a(TFDamageSources.THORNS, 4.0f);
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof ThornsBlock && state.func_177229_b((Property)field_176298_M) == Direction.Axis.Y) {
            this.func_196262_a(state, world, pos, entity);
        }
        super.func_176199_a(world, pos, entity);
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (!player.field_71075_bZ.field_75098_d) {
            if (!world.field_72995_K) {
                this.doThornBurst(world, pos, state);
            }
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    @Deprecated
    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    private void doThornBurst(World world, BlockPos pos, BlockState state) {
        switch ((Direction.Axis)state.func_177229_b((Property)field_176298_M)) {
            case Y: {
                this.growThorns(world, pos, Direction.UP);
                this.growThorns(world, pos, Direction.DOWN);
                break;
            }
            case X: {
                this.growThorns(world, pos, Direction.EAST);
                this.growThorns(world, pos, Direction.WEST);
                break;
            }
            case Z: {
                this.growThorns(world, pos, Direction.NORTH);
                this.growThorns(world, pos, Direction.SOUTH);
            }
        }
        this.growThorns(world, pos, Direction.func_239631_a_((Random)world.field_73012_v));
        this.growThorns(world, pos, Direction.func_239631_a_((Random)world.field_73012_v));
        this.growThorns(world, pos, Direction.func_239631_a_((Random)world.field_73012_v));
    }

    private void growThorns(World world, BlockPos pos, Direction dir) {
        BlockPos dPos;
        int length = 1 + world.field_73012_v.nextInt(3);
        for (int i = 1; i < length && world.func_175623_d(dPos = pos.func_177967_a(dir, i)); ++i) {
            world.func_180501_a(dPos, (BlockState)((Block)TFBlocks.green_thorns.get()).func_176223_P().func_206870_a((Property)field_176298_M, (Comparable)dir.func_176740_k()), 2);
        }
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean flag = fluidstate.func_206886_c() == Fluids.field_204546_a;
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{WATERLOGGED});
    }
}

