/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMerger;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import twilightforest.TFSounds;
import twilightforest.block.TFHorizontalBlock;
import twilightforest.enums.BlockLoggingEnum;
import twilightforest.item.TFItems;
import twilightforest.tileentity.KeepsakeCasketTileEntity;

public class KeepsakeCasketBlock
extends ContainerBlock
implements BlockLoggingEnum.IMultiLoggable {
    public static final DirectionProperty FACING = TFHorizontalBlock.field_185512_D;
    public static final IntegerProperty BREAKAGE = IntegerProperty.func_177719_a((String)"damage", (int)0, (int)2);
    private static final VoxelShape BOTTOM_X = Block.func_208617_a((double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)6.0, (double)15.0);
    private static final VoxelShape TOP_X = Block.func_208617_a((double)1.0, (double)6.0, (double)0.0, (double)15.0, (double)14.0, (double)16.0);
    private static final VoxelShape BOTTOM_Z = Block.func_208617_a((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)6.0, (double)14.0);
    private static final VoxelShape TOP_Z = Block.func_208617_a((double)0.0, (double)6.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0);
    private static final VoxelShape CASKET_X = VoxelShapes.func_197872_a((VoxelShape)BOTTOM_X, (VoxelShape)TOP_X);
    private static final VoxelShape CASKET_Z = VoxelShapes.func_197872_a((VoxelShape)BOTTOM_Z, (VoxelShape)TOP_Z);
    private static final VoxelShape SOLID = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    private static final VoxelShape TOPPER_X = Block.func_208617_a((double)1.0, (double)12.0, (double)0.0, (double)15.0, (double)14.0, (double)16.0);
    private static final VoxelShape TOPPER_Z = Block.func_208617_a((double)0.0, (double)12.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0);
    private static final VoxelShape SOLID_X = VoxelShapes.func_197872_a((VoxelShape)SOLID, (VoxelShape)TOPPER_X);
    private static final VoxelShape SOLID_Z = VoxelShapes.func_197872_a((VoxelShape)SOLID, (VoxelShape)TOPPER_Z);

    protected KeepsakeCasketBlock() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151646_E).func_226896_b_().func_235861_h_().func_200948_a(50.0f, 1200.0f).func_200947_a(SoundType.field_235594_P_));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)BREAKAGE, (Comparable)Integer.valueOf(0)));
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("twilightforest.misc.wip0"));
        tooltip.add((ITextComponent)new TranslationTextComponent("twilightforest.misc.wip1"));
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return ((BlockLoggingEnum)((Object)state.func_177229_b(BlockLoggingEnum.MULTILOGGED))).getBlock() != Blocks.field_150350_a && ((BlockLoggingEnum)((Object)state.func_177229_b(BlockLoggingEnum.MULTILOGGED))).getFluid() == Fluids.field_204541_a ? BlockRenderType.MODEL : BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
        if (((BlockLoggingEnum)((Object)state.func_177229_b(BlockLoggingEnum.MULTILOGGED))).getBlock() != Blocks.field_150350_a && ((BlockLoggingEnum)((Object)state.func_177229_b(BlockLoggingEnum.MULTILOGGED))).getFluid() == Fluids.field_204541_a) {
            return direction.func_176740_k() == Direction.Axis.X ? SOLID_X : SOLID_Z;
        }
        return direction.func_176740_k() == Direction.Axis.X ? CASKET_X : CASKET_Z;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new KeepsakeCasketTileEntity();
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof IInventory) {
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((IInventory)tileentity));
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public float getExplosionResistance(BlockState state, IBlockReader world, BlockPos pos, Explosion explosion) {
        return 1.0E9f;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        boolean flag = false;
        if (((BlockLoggingEnum)((Object)state.func_177229_b(BlockLoggingEnum.MULTILOGGED))).getBlock() == Blocks.field_150350_a || ((BlockLoggingEnum)((Object)state.func_177229_b(BlockLoggingEnum.MULTILOGGED))).getFluid() != Fluids.field_204541_a) {
            ItemStack stack = player.func_184586_b(handIn);
            if (stack.func_77973_b() != TFItems.charm_of_keeping_3.get()) {
                if (worldIn.field_72995_K) {
                    return ActionResultType.SUCCESS;
                }
                INamedContainerProvider inamedcontainerprovider = this.func_220052_b(state, worldIn, pos);
                if (inamedcontainerprovider != null) {
                    player.func_213829_a(inamedcontainerprovider);
                }
                flag = true;
            } else if (stack.func_77973_b() == TFItems.charm_of_keeping_3.get() && (Integer)state.func_177229_b((Property)BREAKAGE) > 0) {
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)BREAKAGE, (Comparable)Integer.valueOf((Integer)state.func_177229_b((Property)BREAKAGE) - 1)));
                worldIn.func_184133_a(null, pos, TFSounds.CASKET_REPAIR, SoundCategory.BLOCKS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
                flag = true;
            }
        }
        return flag ? ActionResultType.CONSUME : ActionResultType.PASS;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntity tile;
        if (!worldIn.field_72995_K && !player.func_184812_l_() && worldIn.func_82736_K().func_223586_b(GameRules.field_223603_f) && (tile = worldIn.func_175625_s(pos)) instanceof KeepsakeCasketTileEntity) {
            Block block;
            KeepsakeCasketTileEntity casket = (KeepsakeCasketTileEntity)tile;
            ItemStack stack = new ItemStack((IItemProvider)this);
            String nameCheck = new StringTextComponent(casket.name + "'s " + casket.func_145748_c_()).getString();
            ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a("damage", ((Integer)state.func_177229_b((Property)BREAKAGE)).intValue());
            stack.func_77983_a("BlockStateTag", (INBT)nbt);
            if (casket.func_145818_k_()) {
                if (nameCheck.equals(casket.func_200201_e().getString())) {
                    itementity.func_200203_b(casket.func_145748_c_());
                } else {
                    itementity.func_200203_b(casket.func_200201_e());
                }
            }
            if (((BlockLoggingEnum)((Object)state.func_177229_b(BlockLoggingEnum.MULTILOGGED))).getFluid() == Fluids.field_204541_a && (block = ((BlockLoggingEnum)((Object)state.func_177229_b(BlockLoggingEnum.MULTILOGGED))).getBlock()) != Blocks.field_150350_a) {
                ItemStack blockstack = new ItemStack((IItemProvider)block);
                ItemEntity item = new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), blockstack);
                item.func_174869_p();
                worldIn.func_217376_c((Entity)item);
            }
            itementity.func_174869_p();
            worldIn.func_217376_c((Entity)itementity);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        CompoundNBT damageNbt;
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74764_b("BlockStateTag") && (damageNbt = nbt.func_74775_l("BlockStateTag")).func_74764_b("damage")) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BREAKAGE, (Comparable)Integer.valueOf(damageNbt.func_74762_e("damage"))), 2);
        }
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof KeepsakeCasketTileEntity) {
            ((KeepsakeCasketTileEntity)tileentity).func_213903_a(stack.func_200301_q());
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.reactWithNeighbors(worldIn, pos, state);
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
    }

    private void reactWithNeighbors(World worldIn, BlockPos pos, BlockState state) {
        block4: {
            block3: {
                if (state.func_177229_b(BlockLoggingEnum.MULTILOGGED) != BlockLoggingEnum.LAVA) break block3;
                boolean flag = worldIn.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_235336_cN_);
                for (Direction direction : Direction.values()) {
                    if (direction == Direction.DOWN) continue;
                    BlockPos blockpos = pos.func_177972_a(direction);
                    if (worldIn.func_204610_c(blockpos).func_206884_a((ITag)FluidTags.field_206959_a)) {
                        worldIn.func_175656_a(pos, (BlockState)state.func_206870_a(BlockLoggingEnum.MULTILOGGED, (Comparable)((Object)BlockLoggingEnum.OBSIDIAN)));
                        worldIn.func_217379_c(1501, pos, 0);
                    }
                    if (!flag || !worldIn.func_180495_p(blockpos).func_203425_a(Blocks.field_205164_gk)) continue;
                    worldIn.func_175656_a(pos, (BlockState)state.func_206870_a(BlockLoggingEnum.MULTILOGGED, (Comparable)((Object)BlockLoggingEnum.BASALT)));
                    worldIn.func_217379_c(1501, pos, 0);
                }
                break block4;
            }
            if (state.func_177229_b(BlockLoggingEnum.MULTILOGGED) != BlockLoggingEnum.WATER) break block4;
            for (Direction direction : Direction.values()) {
                BlockPos blockpos;
                if (direction == Direction.DOWN || !worldIn.func_204610_c(blockpos = pos.func_177972_a(direction)).func_206884_a((ITag)FluidTags.field_206960_b)) continue;
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a(BlockLoggingEnum.MULTILOGGED, (Comparable)((Object)BlockLoggingEnum.STONE)));
                worldIn.func_217379_c(1501, pos, 0);
            }
        }
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_178144_a((TileEntity)worldIn.func_175625_s(pos));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockLoggingEnum.MULTILOGGED, FACING, BREAKAGE});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)super.func_196258_a(context).func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a(BlockLoggingEnum.MULTILOGGED, (Comparable)((Object)BlockLoggingEnum.getFromFluid(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c())));
    }

    public FluidState func_204507_t(BlockState state) {
        return ((BlockLoggingEnum)((Object)state.func_177229_b(BlockLoggingEnum.MULTILOGGED))).getFluid().func_207188_f();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static TileEntityMerger.ICallback<KeepsakeCasketTileEntity, Float2FloatFunction> getLidRotationCallback(final IChestLid lid) {
        return new TileEntityMerger.ICallback<KeepsakeCasketTileEntity, Float2FloatFunction>(){

            public Float2FloatFunction func_225539_a_(KeepsakeCasketTileEntity p_225539_1_, KeepsakeCasketTileEntity p_225539_2_) {
                return angle -> Math.max(p_225539_1_.func_195480_a(angle), p_225539_2_.func_195480_a(angle));
            }

            public Float2FloatFunction func_225538_a_(KeepsakeCasketTileEntity p_225538_1_) {
                return p_225538_1_::func_195480_a;
            }

            public Float2FloatFunction func_225537_b_() {
                return arg_0 -> ((IChestLid)lid).func_195480_a(arg_0);
            }
        };
    }
}

