/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.WoodType;
import net.minecraft.command.CommandSource;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.OptionalDispenseBehavior;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.AxeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import twilightforest.ASMHooks;
import twilightforest.TFConfig;
import twilightforest.TFEventListener;
import twilightforest.TFSounds;
import twilightforest.TFStructures;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.TFBlocks;
import twilightforest.block.TrophyBlock;
import twilightforest.capabilities.CapabilityList;
import twilightforest.client.TFClientSetup;
import twilightforest.client.particle.TFParticleType;
import twilightforest.command.TFCommand;
import twilightforest.compat.TFCompat;
import twilightforest.dispenser.CrumbleDispenseBehavior;
import twilightforest.dispenser.FeatherFanDispenseBehavior;
import twilightforest.dispenser.MoonwormDispenseBehavior;
import twilightforest.dispenser.TransformationDispenseBehavior;
import twilightforest.entity.projectile.MoonwormShotEntity;
import twilightforest.entity.projectile.TwilightWandBoltEntity;
import twilightforest.inventory.TFContainers;
import twilightforest.item.FieryPickItem;
import twilightforest.item.TFItems;
import twilightforest.item.recipe.UncraftingEnabledCondition;
import twilightforest.loot.TFTreasure;
import twilightforest.network.TFPacketHandler;
import twilightforest.potions.TFPotions;
import twilightforest.tileentity.TFTileEntities;
import twilightforest.world.TFDimensions;
import twilightforest.world.feature.TFBiomeFeatures;
import twilightforest.world.feature.TFGenCaveStalactite;
import twilightforest.worldgen.TwilightFeatures;
import twilightforest.worldgen.biomes.BiomeGrassColors;
import twilightforest.worldgen.biomes.BiomeKeys;

@Mod(value="twilightforest")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TwilightForestMod {
    public static final String ID = "twilightforest";
    private static final String MODEL_DIR = "textures/model/";
    private static final String GUI_DIR = "textures/gui/";
    private static final String ENVIRO_DIR = "textures/environment/";
    public static final String ARMOR_DIR = "twilightforest:textures/armor/";
    public static final GameRules.RuleKey<GameRules.BooleanValue> ENFORCED_PROGRESSION_RULE = GameRules.func_234903_a_((String)"tfEnforcedProgression", (GameRules.Category)GameRules.Category.UPDATES, (GameRules.RuleType)GameRules.BooleanValue.func_223568_b((boolean)true));
    public static final Logger LOGGER = LogManager.getLogger((String)"twilightforest");
    private static final Rarity rarity = Rarity.create((String)"TWILIGHT", (TextFormatting)TextFormatting.DARK_GREEN);

    public TwilightForestMod() {
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> TFClientSetup::addLegacyPack);
        Pair specPair = new ForgeConfigSpec.Builder().configure(TFConfig.Common::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (ForgeConfigSpec)specPair.getRight());
        TFConfig.COMMON_CONFIG = (TFConfig.Common)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(TFConfig.Client::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (ForgeConfigSpec)specPair.getRight());
        TFConfig.CLIENT_CONFIG = (TFConfig.Client)specPair.getLeft();
        ASMHooks.registerMultipartEvents(MinecraftForge.EVENT_BUS);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        IEventBus modbus = FMLJavaModLoadingContext.get().getModEventBus();
        TFBlocks.BLOCKS.register(modbus);
        TFItems.ITEMS.register(modbus);
        TFPotions.POTIONS.register(modbus);
        BiomeKeys.BIOMES.register(modbus);
        modbus.addGenericListener(SoundEvent.class, TFSounds::registerSounds);
        TFTileEntities.TILE_ENTITIES.register(modbus);
        TFParticleType.PARTICLE_TYPES.register(modbus);
        modbus.addGenericListener(Structure.class, TFStructures::register);
        MinecraftForge.EVENT_BUS.addListener(TFStructures::load);
        TFBiomeFeatures.FEATURES.register(modbus);
        TFContainers.CONTAINERS.register(modbus);
        new TwilightFeatures();
        new BiomeGrassColors();
        if (((Boolean)TFConfig.COMMON_CONFIG.doCompat.get()).booleanValue()) {
            try {
                TFCompat.preInitCompat();
            }
            catch (Exception e) {
                TFConfig.COMMON_CONFIG.doCompat.set((Object)false);
                LOGGER.error("Had an error loading preInit compatibility!");
                LOGGER.catching(e.fillInStackTrace());
            }
        } else {
            LOGGER.warn("Skipping compatibility!");
        }
    }

    @SubscribeEvent
    public static void registerSerializers(RegistryEvent.Register<IRecipeSerializer<?>> evt) {
        CraftingHelper.register((IConditionSerializer)new UncraftingEnabledCondition.Serializer());
        TFTreasure.init();
    }

    @SubscribeEvent
    public static void registerLootModifiers(RegistryEvent.Register<GlobalLootModifierSerializer<?>> evt) {
        evt.getRegistry().register((IForgeRegistryEntry)new FieryPickItem.Serializer().setRegistryName("twilightforest:fiery_pick_smelting"));
        evt.getRegistry().register((IForgeRegistryEntry)new TFEventListener.Serializer().setRegistryName("twilightforest:giant_block_grouping"));
    }

    @SubscribeEvent
    public void sendIMCs(InterModEnqueueEvent evt) {
        TFCompat.IMCSender();
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent evt) {
        CapabilityList.registerCapabilities();
        TFPacketHandler.init();
        TFAdvancements.init();
        BiomeKeys.addBiomeTypes();
        TFDimensions.init();
        if (((Boolean)TFConfig.COMMON_CONFIG.doCompat.get()).booleanValue()) {
            try {
                TFCompat.initCompat();
            }
            catch (Exception e) {
                TFConfig.COMMON_CONFIG.doCompat.set((Object)false);
                LOGGER.error("Had an error loading init compatibility!");
                LOGGER.catching(e.fillInStackTrace());
            }
        }
        if (((Boolean)TFConfig.COMMON_CONFIG.doCompat.get()).booleanValue()) {
            try {
                TFCompat.postInitCompat();
            }
            catch (Exception e) {
                TFConfig.COMMON_CONFIG.doCompat.set((Object)false);
                LOGGER.error("Had an error loading postInit compatibility!");
                LOGGER.catching(e.fillInStackTrace());
            }
        }
        TFConfig.build();
        TFGenCaveStalactite.loadStalactites();
        evt.enqueueWork(() -> {
            TFBlocks.tfCompostables();
            TFBlocks.TFBurnables();
            TFBlocks.TFPots();
            TFSounds.registerParrotSounds();
            AxeItem.field_203176_a = Maps.newHashMap((Map)AxeItem.field_203176_a);
            AxeItem.field_203176_a.put(TFBlocks.oak_log.get(), TFBlocks.stripped_oak_log.get());
            AxeItem.field_203176_a.put(TFBlocks.canopy_log.get(), TFBlocks.stripped_canopy_log.get());
            AxeItem.field_203176_a.put(TFBlocks.mangrove_log.get(), TFBlocks.stripped_mangrove_log.get());
            AxeItem.field_203176_a.put(TFBlocks.dark_log.get(), TFBlocks.stripped_dark_log.get());
            AxeItem.field_203176_a.put(TFBlocks.time_log.get(), TFBlocks.stripped_time_log.get());
            AxeItem.field_203176_a.put(TFBlocks.transformation_log.get(), TFBlocks.stripped_transformation_log.get());
            AxeItem.field_203176_a.put(TFBlocks.mining_log.get(), TFBlocks.stripped_mining_log.get());
            AxeItem.field_203176_a.put(TFBlocks.sorting_log.get(), TFBlocks.stripped_sorting_log.get());
            AxeItem.field_203176_a.put(TFBlocks.oak_wood.get(), TFBlocks.stripped_oak_wood.get());
            AxeItem.field_203176_a.put(TFBlocks.canopy_wood.get(), TFBlocks.stripped_canopy_wood.get());
            AxeItem.field_203176_a.put(TFBlocks.mangrove_wood.get(), TFBlocks.stripped_mangrove_wood.get());
            AxeItem.field_203176_a.put(TFBlocks.dark_wood.get(), TFBlocks.stripped_dark_wood.get());
            AxeItem.field_203176_a.put(TFBlocks.time_wood.get(), TFBlocks.stripped_time_wood.get());
            AxeItem.field_203176_a.put(TFBlocks.transformation_wood.get(), TFBlocks.stripped_transformation_wood.get());
            AxeItem.field_203176_a.put(TFBlocks.mining_wood.get(), TFBlocks.stripped_mining_wood.get());
            AxeItem.field_203176_a.put(TFBlocks.sorting_wood.get(), TFBlocks.stripped_sorting_wood.get());
            DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)TFItems.moonworm_queen.get()), (IDispenseItemBehavior)new MoonwormDispenseBehavior(){

                @Override
                protected ProjectileEntity getProjectileEntity(World worldIn, IPosition position, ItemStack stackIn) {
                    return new MoonwormShotEntity(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
                }
            });
            OptionalDispenseBehavior idispenseitembehavior = new OptionalDispenseBehavior(){

                protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                    this.func_239796_a_(ArmorItem.func_226626_a_((IBlockSource)source, (ItemStack)stack));
                    return stack;
                }
            };
            DispenserBlock.func_199774_a((IItemProvider)((TrophyBlock)TFBlocks.naga_trophy.get()).func_199767_j(), (IDispenseItemBehavior)idispenseitembehavior);
            DispenserBlock.func_199774_a((IItemProvider)((TrophyBlock)TFBlocks.lich_trophy.get()).func_199767_j(), (IDispenseItemBehavior)idispenseitembehavior);
            DispenserBlock.func_199774_a((IItemProvider)((TrophyBlock)TFBlocks.minoshroom_trophy.get()).func_199767_j(), (IDispenseItemBehavior)idispenseitembehavior);
            DispenserBlock.func_199774_a((IItemProvider)((TrophyBlock)TFBlocks.hydra_trophy.get()).func_199767_j(), (IDispenseItemBehavior)idispenseitembehavior);
            DispenserBlock.func_199774_a((IItemProvider)((TrophyBlock)TFBlocks.knight_phantom_trophy.get()).func_199767_j(), (IDispenseItemBehavior)idispenseitembehavior);
            DispenserBlock.func_199774_a((IItemProvider)((TrophyBlock)TFBlocks.ur_ghast_trophy.get()).func_199767_j(), (IDispenseItemBehavior)idispenseitembehavior);
            DispenserBlock.func_199774_a((IItemProvider)((TrophyBlock)TFBlocks.snow_queen_trophy.get()).func_199767_j(), (IDispenseItemBehavior)idispenseitembehavior);
            DispenserBlock.func_199774_a((IItemProvider)((TrophyBlock)TFBlocks.quest_ram_trophy.get()).func_199767_j(), (IDispenseItemBehavior)idispenseitembehavior);
            DispenserBlock.func_199774_a((IItemProvider)((Block)TFBlocks.cicada.get()).func_199767_j(), (IDispenseItemBehavior)idispenseitembehavior);
            DispenserBlock.func_199774_a((IItemProvider)((Block)TFBlocks.firefly.get()).func_199767_j(), (IDispenseItemBehavior)idispenseitembehavior);
            DispenserBlock.func_199774_a((IItemProvider)((Block)TFBlocks.moonworm.get()).func_199767_j(), (IDispenseItemBehavior)idispenseitembehavior);
            FeatherFanDispenseBehavior pushmobsbehavior = new FeatherFanDispenseBehavior();
            DispenserBlock.func_199774_a((IItemProvider)((Item)TFItems.peacock_fan.get()).func_199767_j(), (IDispenseItemBehavior)pushmobsbehavior);
            CrumbleDispenseBehavior crumblebehavior = new CrumbleDispenseBehavior();
            DispenserBlock.func_199774_a((IItemProvider)((Item)TFItems.crumble_horn.get()).func_199767_j(), (IDispenseItemBehavior)crumblebehavior);
            TransformationDispenseBehavior transformbehavior = new TransformationDispenseBehavior();
            DispenserBlock.func_199774_a((IItemProvider)((Item)TFItems.transformation_powder.get()).func_199767_j(), (IDispenseItemBehavior)transformbehavior);
            DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)TFItems.twilight_scepter.get()), (IDispenseItemBehavior)new MoonwormDispenseBehavior(){

                @Override
                protected ProjectileEntity getProjectileEntity(World worldIn, IPosition position, ItemStack stackIn) {
                    return new TwilightWandBoltEntity(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
                }

                @Override
                protected void func_82485_a(IBlockSource source) {
                    BlockPos pos = source.func_180699_d();
                    source.func_197524_h().func_184133_a(null, pos, TFSounds.SCEPTER_PEARL, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            });
        });
        WoodType.func_227047_a_((WoodType)TFBlocks.TWILIGHT_OAK);
        WoodType.func_227047_a_((WoodType)TFBlocks.CANOPY);
        WoodType.func_227047_a_((WoodType)TFBlocks.MANGROVE);
        WoodType.func_227047_a_((WoodType)TFBlocks.DARKWOOD);
        WoodType.func_227047_a_((WoodType)TFBlocks.TIMEWOOD);
        WoodType.func_227047_a_((WoodType)TFBlocks.TRANSFORMATION);
        WoodType.func_227047_a_((WoodType)TFBlocks.MINING);
        WoodType.func_227047_a_((WoodType)TFBlocks.SORTING);
    }

    public void registerCommands(RegisterCommandsEvent event) {
        TFCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    public static ResourceLocation prefix(String name) {
        return new ResourceLocation(ID, name.toLowerCase(Locale.ROOT));
    }

    public static ResourceLocation getModelTexture(String name) {
        return new ResourceLocation(ID, MODEL_DIR + name);
    }

    public static ResourceLocation getGuiTexture(String name) {
        return new ResourceLocation(ID, GUI_DIR + name);
    }

    public static ResourceLocation getEnvTexture(String name) {
        return new ResourceLocation(ID, ENVIRO_DIR + name);
    }

    public static Rarity getRarity() {
        return rarity != null ? rarity : Rarity.EPIC;
    }
}

