/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.mixin;

import java.util.Iterator;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.inventory.container.RepairContainer;
import net.minecraft.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={RepairContainer.class})
public class RepairContainerMixin {
    private int maxLevel;

    @Inject(method={"updateRepairOutput"}, at={@At(value="INVOKE", target="Lnet/minecraft/enchantment/Enchantment;canApply(Lnet/minecraft/item/ItemStack;)Z", ordinal=0)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void beforeCanApply(CallbackInfo ci, ItemStack leftOriginal, int enchantCost, int repairCost, int renameCost, ItemStack leftCopy, ItemStack rightOriginal, Map leftEnchantments, boolean enchantingItem, Map rightEnchantments, boolean combinedEnchants, boolean invalidRepair, Iterator var12, Enchantment enchantment, int leftEnchantmentLevel, int combinedEnchantmentLevel) {
        int maxLevel = this.getEnchantmentLevel(enchantment);
        int leftLevel = leftEnchantments.getOrDefault(enchantment, 0);
        int rightLevel = (Integer)rightEnchantments.get(enchantment);
        this.maxLevel = Math.max(rightLevel, leftLevel);
        if (leftLevel == rightLevel && leftLevel < maxLevel) {
            this.maxLevel = rightLevel + 1;
        }
    }

    private int getEnchantmentLevel(Enchantment enchantment) {
        return enchantment.func_77325_b();
    }

    @ModifyArgs(method={"updateRepairOutput"}, at=@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", ordinal=0))
    private void afterSetMaxLevel(Args args) {
        args.set(1, (Object)this.maxLevel);
    }
}

