/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.entity;

import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import com.mrcrayfish.goblintraders.entity.TraderCreatureEntity;
import com.mrcrayfish.goblintraders.init.ModEntities;
import com.mrcrayfish.goblintraders.trades.EntityTrades;
import com.mrcrayfish.goblintraders.trades.TradeManager;
import com.mrcrayfish.goblintraders.trades.TradeRarity;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffers;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class VeinGoblinTraderEntity
extends AbstractGoblinEntity {
    public VeinGoblinTraderEntity(World worldIn) {
        super((EntityType<? extends CreatureEntity>)((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get()), worldIn);
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("goblintraders", "textures/entity/vein_goblin_trader.png");
    }

    @Override
    protected void populateTradeData() {
        MerchantOffers offers = this.func_213706_dY();
        EntityTrades entityTrades = TradeManager.instance().getTrades((EntityType<? extends TraderCreatureEntity>)((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get()));
        if (entityTrades != null) {
            Map<TradeRarity, List<VillagerTrades.ITrade>> tradeMap = entityTrades.getTradeMap();
            for (TradeRarity rarity : TradeRarity.values()) {
                List<VillagerTrades.ITrade> trades = tradeMap.get((Object)rarity);
                int min = rarity.getMaximum().apply(trades, this.field_70146_Z);
                int max = rarity.getMaximum().apply(trades, this.field_70146_Z);
                this.addTrades(offers, trades, Math.max(min, max), rarity.shouldShuffle());
            }
        }
    }

    @Override
    public ItemStack getFavouriteFood() {
        return new ItemStack((IItemProvider)Items.field_151172_bF);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa % 2 == 0) {
            if (this.func_226277_ct_() != this.field_70169_q || this.func_226278_cu_() != this.field_70167_r || this.func_226281_cx_() != this.field_70166_s) {
                // empty if block
            }
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_() - 0.5 + 1.0 * this.field_70146_Z.nextDouble(), this.func_226278_cu_() + 0.5 - 0.5 + 1.0 * this.field_70146_Z.nextDouble(), this.func_226281_cx_() - 0.5 + 1.0 * this.field_70146_Z.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    public boolean func_230279_az_() {
        return true;
    }
}

