/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.client.renderer.entity.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import net.minecraft.client.renderer.entity.model.IHasArm;
import net.minecraft.client.renderer.entity.model.IHasHead;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;

public class GoblinTraderModel
extends SegmentedModel<AbstractGoblinEntity>
implements IHasArm,
IHasHead {
    public ModelRenderer head;
    public ModelRenderer hood;
    public ModelRenderer body;
    public ModelRenderer rightArm;
    public ModelRenderer leftArm;
    public ModelRenderer rightLeg;
    public ModelRenderer leftLeg;
    public ModelRenderer nose;
    public ModelRenderer rightEar;
    public ModelRenderer leftEar;
    public ModelRenderer bag;
    private final ImmutableList<ModelRenderer> parts;

    public GoblinTraderModel() {
        this.field_78090_t = 46;
        this.field_78089_u = 46;
        this.rightEar = new ModelRenderer((Model)this, 0, 8);
        this.rightEar.func_78793_a(-4.0f, -3.0f, 1.0f);
        this.rightEar.func_228301_a_(0.0f, -2.0f, 0.0f, 0.0f, 4.0f, 4.0f, 0.0f);
        this.setRotateAngle(this.rightEar, 0.0f, -0.7853982f, 0.0f);
        this.leftEar = new ModelRenderer((Model)this, 8, 8);
        this.leftEar.func_78793_a(4.0f, -3.0f, 1.0f);
        this.leftEar.func_228301_a_(0.0f, -2.0f, 0.0f, 0.0f, 4.0f, 4.0f, 0.0f);
        this.setRotateAngle(this.leftEar, 0.0f, 0.7853982f, 0.0f);
        this.rightLeg = new ModelRenderer((Model)this, 26, 9);
        this.rightLeg.func_78793_a(-1.0f, 20.0f, 0.0f);
        this.rightLeg.func_228301_a_(-1.0f, 0.0f, -1.5f, 2.0f, 4.0f, 3.0f, 0.0f);
        this.rightArm = new ModelRenderer((Model)this, 30, 0);
        this.rightArm.func_78793_a(-3.0f, 17.0f, 0.0f);
        this.rightArm.func_228301_a_(-1.0f, -1.0f, -1.0f, 2.0f, 5.0f, 2.0f, 0.0f);
        this.head = new ModelRenderer((Model)this, 0, 0);
        this.head.func_78793_a(0.0f, 16.0f, 0.0f);
        this.head.func_228301_a_(-4.0f, -6.0f, -3.0f, 8.0f, 6.0f, 6.0f, 0.0f);
        this.body = new ModelRenderer((Model)this, 12, 12);
        this.body.func_78793_a(0.0f, 16.0f, 0.0f);
        this.body.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, 0.0f);
        this.nose = new ModelRenderer((Model)this, 22, 0);
        this.nose.func_78793_a(0.0f, -3.0f, -3.0f);
        this.nose.func_228301_a_(-1.0f, 0.0f, -2.0f, 2.0f, 4.0f, 2.0f, 0.0f);
        this.hood = new ModelRenderer((Model)this, 0, 32);
        this.hood.func_78793_a(0.0f, 16.0f, 0.0f);
        this.hood.func_228301_a_(-4.0f, -6.0f, -3.0f, 8.0f, 8.0f, 6.0f, 0.5f);
        this.bag = new ModelRenderer((Model)this, 0, 20);
        this.bag.func_78793_a(0.0f, 0.0f, 0.0f);
        this.bag.func_228301_a_(-2.5f, -2.0f, 2.0f, 5.0f, 7.0f, 3.0f, 0.0f);
        this.leftArm = new ModelRenderer((Model)this, 38, 0);
        this.leftArm.func_78793_a(3.0f, 17.0f, 0.0f);
        this.leftArm.func_228301_a_(-1.0f, -1.0f, -1.0f, 2.0f, 5.0f, 2.0f, 0.0f);
        this.leftLeg = new ModelRenderer((Model)this, 36, 9);
        this.leftLeg.func_78793_a(1.0f, 20.0f, 0.0f);
        this.leftLeg.func_228301_a_(-1.0f, 0.0f, -1.5f, 2.0f, 4.0f, 3.0f, 0.0f);
        this.head.func_78792_a(this.rightEar);
        this.head.func_78792_a(this.leftEar);
        this.head.func_78792_a(this.nose);
        this.body.func_78792_a(this.bag);
        this.parts = ImmutableList.of((Object)this.head, (Object)this.hood, (Object)this.body, (Object)this.leftArm, (Object)this.rightArm, (Object)this.leftLeg, (Object)this.rightLeg);
    }

    private void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    public Iterable<ModelRenderer> func_225601_a_() {
        return this.parts;
    }

    public void setRotationAngles(AbstractGoblinEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        float rotateFactor = (float)entity.func_213322_ci().func_189985_c();
        rotateFactor /= 0.2f;
        if ((rotateFactor = rotateFactor * rotateFactor * rotateFactor) < 1.0f) {
            rotateFactor = 1.0f;
        }
        this.rightArm.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f / rotateFactor;
        this.leftArm.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f / rotateFactor;
        this.rightArm.field_78796_g = 0.0f;
        this.rightArm.field_78808_h = 0.0f;
        this.leftArm.field_78796_g = 0.0f;
        this.leftArm.field_78808_h = 0.0f;
        this.rightLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount / rotateFactor;
        this.leftLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount / rotateFactor;
        this.head.field_78796_g = headYaw * ((float)Math.PI / 180);
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.hood.func_217177_a(this.head);
        if (this.field_217112_c > 0.0f) {
            ModelRenderer arm = this.rightArm;
            float progress = this.field_217112_c;
            this.body.field_78796_g = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)progress) * ((float)Math.PI * 2))) * 0.2f;
            this.rightArm.field_78796_g += this.body.field_78796_g;
            this.leftArm.field_78796_g += this.body.field_78796_g;
            this.leftArm.field_78795_f += this.body.field_78796_g;
            progress = 1.0f - this.field_217112_c;
            progress *= progress;
            progress *= progress;
            progress = 1.0f - progress;
            float f2 = MathHelper.func_76126_a((float)(progress * (float)Math.PI));
            float f3 = MathHelper.func_76126_a((float)(this.field_217112_c * (float)Math.PI)) * -(this.head.field_78795_f - 0.7f) * 0.75f;
            arm.field_78795_f = (float)((double)arm.field_78795_f - ((double)f2 * 1.2 + (double)f3));
            arm.field_78796_g += this.body.field_78796_g * 2.0f;
            arm.field_78808_h += MathHelper.func_76126_a((float)(this.field_217112_c * (float)Math.PI)) * -0.4f;
        }
        if (entity.func_184587_cr()) {
            this.rightArm.field_78795_f = (float)Math.toRadians(-90.0 + 5.0 * Math.sin(ageInTicks));
            this.leftArm.field_78795_f = (float)Math.toRadians(-90.0 + 5.0 * Math.sin(ageInTicks));
            this.rightLeg.field_78795_f = (float)Math.toRadians(-90.0);
            this.rightLeg.field_78796_g = (float)Math.toRadians(25.0);
            this.leftLeg.field_78795_f = (float)Math.toRadians(-90.0);
            this.leftLeg.field_78796_g = (float)Math.toRadians(-25.0);
        } else {
            this.rightLeg.field_78796_g = (float)Math.toRadians(0.0);
            this.leftLeg.field_78796_g = (float)Math.toRadians(0.0);
        }
    }

    public void func_225599_a_(HandSide handSide, MatrixStack matrixStack) {
        switch (handSide) {
            case LEFT: {
                this.leftArm.func_228307_a_(matrixStack);
                matrixStack.func_227861_a_(-0.235, -0.15, 0.25);
                matrixStack.func_227862_a_(0.75f, 0.75f, 0.75f);
                break;
            }
            case RIGHT: {
                this.rightArm.func_228307_a_(matrixStack);
                matrixStack.func_227861_a_(0.235, -0.15, 0.25);
                matrixStack.func_227862_a_(0.75f, 0.75f, 0.75f);
            }
        }
    }

    public ModelRenderer func_205072_a() {
        return this.head;
    }
}

