/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmode.ModeSettingsManager;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.render.BlockPreviewRenderer;
import nl.requios.effortlessbuilding.render.BuildRenderTypes;
import nl.requios.effortlessbuilding.render.ModifierRenderer;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class RenderHandler {
    @SubscribeEvent
    public static void onRender(RenderWorldLastEvent event) {
        if (event.getPhase() != EventPriority.NORMAL) {
            return;
        }
        MatrixStack matrixStack = event.getMatrixStack();
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        IRenderTypeBuffer.Impl renderTypeBuffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)bufferBuilder);
        if (renderTypeBuffer == null) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        ModeSettingsManager.ModeSettings modeSettings = ModeSettingsManager.getModeSettings((PlayerEntity)player);
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings((PlayerEntity)player);
        Vector3d projectedView = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(-projectedView.field_72450_a, -projectedView.field_72448_b, -projectedView.field_72449_c);
        ModifierRenderer.render(matrixStack, renderTypeBuffer, modifierSettings);
        BlockPreviewRenderer.render(matrixStack, renderTypeBuffer, (PlayerEntity)player, modifierSettings, modeSettings);
        matrixStack.func_227865_b_();
    }

    protected static IVertexBuilder beginLines(IRenderTypeBuffer.Impl renderTypeBuffer) {
        return renderTypeBuffer.getBuffer(BuildRenderTypes.LINES);
    }

    protected static void endLines(IRenderTypeBuffer.Impl renderTypeBuffer) {
        renderTypeBuffer.func_228461_a_();
    }

    protected static IVertexBuilder beginPlanes(IRenderTypeBuffer.Impl renderTypeBuffer) {
        return renderTypeBuffer.getBuffer(BuildRenderTypes.PLANES);
    }

    protected static void endPlanes(IRenderTypeBuffer.Impl renderTypeBuffer) {
        renderTypeBuffer.func_228461_a_();
    }

    protected static void renderBlockPreview(MatrixStack matrixStack, IRenderTypeBuffer.Impl renderTypeBuffer, BlockRendererDispatcher dispatcher, BlockPos blockPos, BlockState blockState, float dissolve, BlockPos firstPos, BlockPos secondPos, boolean red) {
        if (blockState == null) {
            return;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p());
        matrixStack.func_227861_a_((double)-0.01f, (double)-0.01f, (double)-0.01f);
        matrixStack.func_227862_a_(1.02f, 1.02f, 1.02f);
        RenderType blockPreviewRenderType = BuildRenderTypes.getBlockPreviewRenderType(dissolve, blockPos, firstPos, secondPos, red);
        IVertexBuilder buffer = renderTypeBuffer.getBuffer(blockPreviewRenderType);
        try {
            IBakedModel model = dispatcher.func_184389_a(blockState);
            dispatcher.func_175019_b().func_228804_a_(matrixStack.func_227866_c_(), buffer, blockState, model, 1.0f, 1.0f, 1.0f, 0, OverlayTexture.field_229196_a_);
        }
        catch (NullPointerException e) {
            EffortlessBuilding.logger.warn("RenderHandler::renderBlockPreview cannot render " + blockState.func_177230_c().toString());
            matrixStack.func_227865_b_();
            renderTypeBuffer.func_228461_a_();
            IVertexBuilder lineBuffer = RenderHandler.beginLines(renderTypeBuffer);
            RenderHandler.renderBlockOutline(matrixStack, lineBuffer, blockPos, new Vector3d(1.0, 1.0, 1.0));
            RenderHandler.endLines(renderTypeBuffer);
            buffer = renderTypeBuffer.getBuffer(Atlases.func_228785_j_());
            matrixStack.func_227860_a_();
        }
        renderTypeBuffer.func_228461_a_();
        matrixStack.func_227865_b_();
    }

    protected static void renderBlockOutline(MatrixStack matrixStack, IVertexBuilder buffer, BlockPos pos, Vector3d color) {
        RenderHandler.renderBlockOutline(matrixStack, buffer, pos, pos, color);
    }

    protected static void renderBlockOutline(MatrixStack matrixStack, IVertexBuilder buffer, BlockPos pos1, BlockPos pos2, Vector3d color) {
        AxisAlignedBB aabb = new AxisAlignedBB(pos1, pos2.func_177982_a(1, 1, 1)).func_186662_g((double)0.002f);
        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)buffer, (AxisAlignedBB)aabb, (float)((float)color.field_72450_a), (float)((float)color.field_72448_b), (float)((float)color.field_72449_c), (float)0.4f);
    }

    protected static void renderBlockOutline(MatrixStack matrixStack, IVertexBuilder buffer, BlockPos pos, VoxelShape collisionShape, Vector3d color) {
        WorldRenderer.func_228431_a_((MatrixStack)matrixStack, (IVertexBuilder)buffer, (VoxelShape)collisionShape, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (float)((float)color.field_72450_a), (float)((float)color.field_72448_b), (float)((float)color.field_72449_c), (float)0.4f);
    }
}

