/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.network.BlockPlacedMessage;
import nl.requios.effortlessbuilding.network.PacketHandler;
import nl.requios.effortlessbuilding.proxy.ClientProxy;

public class RequestLookAtMessage {
    private final boolean placeStartPos;

    public RequestLookAtMessage() {
        this.placeStartPos = false;
    }

    public RequestLookAtMessage(boolean placeStartPos) {
        this.placeStartPos = placeStartPos;
    }

    public static void encode(RequestLookAtMessage message, PacketBuffer buf) {
        buf.writeBoolean(message.placeStartPos);
    }

    public static RequestLookAtMessage decode(PacketBuffer buf) {
        boolean placeStartPos = buf.readBoolean();
        return new RequestLookAtMessage(placeStartPos);
    }

    public boolean getPlaceStartPos() {
        return this.placeStartPos;
    }

    public static class Handler {
        public static void handle(RequestLookAtMessage message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                    PlayerEntity player = EffortlessBuilding.proxy.getPlayerEntityFromContext(ctx);
                    if (ClientProxy.previousLookAt.func_216346_c() == RayTraceResult.Type.BLOCK) {
                        PacketHandler.INSTANCE.sendToServer((Object)new BlockPlacedMessage((BlockRayTraceResult)ClientProxy.previousLookAt, message.getPlaceStartPos()));
                    } else {
                        PacketHandler.INSTANCE.sendToServer((Object)new BlockPlacedMessage());
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

