/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.network.NetworkEvent;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmodifier.Array;
import nl.requios.effortlessbuilding.buildmodifier.Mirror;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.buildmodifier.RadialMirror;

public class ModifierSettingsMessage {
    private ModifierSettingsManager.ModifierSettings modifierSettings;

    public ModifierSettingsMessage() {
    }

    public ModifierSettingsMessage(ModifierSettingsManager.ModifierSettings modifierSettings) {
        this.modifierSettings = modifierSettings;
    }

    public static void encode(ModifierSettingsMessage message, PacketBuffer buf) {
        Array.ArraySettings a;
        Mirror.MirrorSettings m = message.modifierSettings.getMirrorSettings();
        buf.writeBoolean(m != null);
        if (m != null) {
            buf.writeBoolean(m.enabled);
            buf.writeDouble(m.position.field_72450_a);
            buf.writeDouble(m.position.field_72448_b);
            buf.writeDouble(m.position.field_72449_c);
            buf.writeBoolean(m.mirrorX);
            buf.writeBoolean(m.mirrorY);
            buf.writeBoolean(m.mirrorZ);
            buf.writeInt(m.radius);
            buf.writeBoolean(m.drawLines);
            buf.writeBoolean(m.drawPlanes);
        }
        buf.writeBoolean((a = message.modifierSettings.getArraySettings()) != null);
        if (a != null) {
            buf.writeBoolean(a.enabled);
            buf.writeInt(a.offset.func_177958_n());
            buf.writeInt(a.offset.func_177956_o());
            buf.writeInt(a.offset.func_177952_p());
            buf.writeInt(a.count);
        }
        buf.writeBoolean(message.modifierSettings.doQuickReplace());
        buf.writeInt(message.modifierSettings.getReachUpgrade());
        RadialMirror.RadialMirrorSettings r = message.modifierSettings.getRadialMirrorSettings();
        buf.writeBoolean(r != null);
        if (r != null) {
            buf.writeBoolean(r.enabled);
            buf.writeDouble(r.position.field_72450_a);
            buf.writeDouble(r.position.field_72448_b);
            buf.writeDouble(r.position.field_72449_c);
            buf.writeInt(r.slices);
            buf.writeBoolean(r.alternate);
            buf.writeInt(r.radius);
            buf.writeBoolean(r.drawLines);
            buf.writeBoolean(r.drawPlanes);
        }
    }

    public static ModifierSettingsMessage decode(PacketBuffer buf) {
        Mirror.MirrorSettings m = new Mirror.MirrorSettings();
        if (buf.readBoolean()) {
            boolean mirrorEnabled = buf.readBoolean();
            Vector3d mirrorPosition = new Vector3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
            boolean mirrorX = buf.readBoolean();
            boolean mirrorY = buf.readBoolean();
            boolean mirrorZ = buf.readBoolean();
            int mirrorRadius = buf.readInt();
            boolean mirrorDrawLines = buf.readBoolean();
            boolean mirrorDrawPlanes = buf.readBoolean();
            m = new Mirror.MirrorSettings(mirrorEnabled, mirrorPosition, mirrorX, mirrorY, mirrorZ, mirrorRadius, mirrorDrawLines, mirrorDrawPlanes);
        }
        Array.ArraySettings a = new Array.ArraySettings();
        if (buf.readBoolean()) {
            boolean arrayEnabled = buf.readBoolean();
            BlockPos arrayOffset = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
            int arrayCount = buf.readInt();
            a = new Array.ArraySettings(arrayEnabled, arrayOffset, arrayCount);
        }
        boolean quickReplace = buf.readBoolean();
        int reachUpgrade = buf.readInt();
        RadialMirror.RadialMirrorSettings r = new RadialMirror.RadialMirrorSettings();
        if (buf.readBoolean()) {
            boolean radialMirrorEnabled = buf.readBoolean();
            Vector3d radialMirrorPosition = new Vector3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
            int radialMirrorSlices = buf.readInt();
            boolean radialMirrorAlternate = buf.readBoolean();
            int radialMirrorRadius = buf.readInt();
            boolean radialMirrorDrawLines = buf.readBoolean();
            boolean radialMirrorDrawPlanes = buf.readBoolean();
            r = new RadialMirror.RadialMirrorSettings(radialMirrorEnabled, radialMirrorPosition, radialMirrorSlices, radialMirrorAlternate, radialMirrorRadius, radialMirrorDrawLines, radialMirrorDrawPlanes);
        }
        ModifierSettingsManager.ModifierSettings modifierSettings = new ModifierSettingsManager.ModifierSettings(m, a, r, quickReplace, reachUpgrade);
        return new ModifierSettingsMessage(modifierSettings);
    }

    public static class Handler {
        public static void handle(ModifierSettingsMessage message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                PlayerEntity player = EffortlessBuilding.proxy.getPlayerEntityFromContext(ctx);
                ModifierSettingsManager.sanitize(message.modifierSettings, player);
                ModifierSettingsManager.setModifierSettings(player, message.modifierSettings);
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

