/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.item;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import nl.requios.effortlessbuilding.BuildConfig;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.helper.ReachHelper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ReachUpgrade3Item
extends Item {
    public ReachUpgrade3Item() {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78040_i).func_200917_a(1));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (player.func_184812_l_()) {
            if (world.field_72995_K) {
                EffortlessBuilding.log(player, "Reach upgrades are not necessary in creative.");
            }
            if (world.field_72995_K) {
                EffortlessBuilding.log(player, "Still want increased reach? Use the config.");
            }
            return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(hand));
        }
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings(player);
        int currentLevel = modifierSettings.getReachUpgrade();
        if (currentLevel == 2) {
            modifierSettings.setReachUpgrade(3);
            if (world.field_72995_K) {
                EffortlessBuilding.log(player, "Upgraded reach to " + ReachHelper.getMaxReach(player));
            }
            player.func_184611_a(hand, ItemStack.field_190927_a);
            SoundEvent soundEvent = new SoundEvent(new ResourceLocation("entity.player.levelup"));
            player.func_184185_a(soundEvent, 1.0f, 1.0f);
        } else if (currentLevel < 2) {
            if (currentLevel == 0 && world.field_72995_K) {
                EffortlessBuilding.log(player, "Use Reach Upgrade 1 and 2 first.");
            }
            if (currentLevel == 1 && world.field_72995_K) {
                EffortlessBuilding.log(player, "Use Reach Upgrade 2 first.");
            }
            SoundEvent soundEvent = new SoundEvent(new ResourceLocation("item.armor.equip_leather"));
            player.func_184185_a(soundEvent, 1.0f, 1.0f);
        } else if (currentLevel > 2) {
            if (world.field_72995_K) {
                EffortlessBuilding.log(player, "Already used this upgrade! Current reach is " + ReachHelper.getMaxReach(player) + ".");
            }
            SoundEvent soundEvent = new SoundEvent(new ResourceLocation("item.armor.equip_leather"));
            player.func_184185_a(soundEvent, 1.0f, 1.0f);
        }
        return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(hand));
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "Consume to increase reach to " + TextFormatting.BLUE + BuildConfig.reach.maxReachLevel3.get()));
        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "Previous upgrades need to be consumed first"));
    }

    public String func_77658_a() {
        return this.getRegistryName().toString();
    }
}

