/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.item;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import nl.requios.effortlessbuilding.buildmode.BuildModes;
import nl.requios.effortlessbuilding.buildmode.ModeSettingsManager;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.capability.ItemHandlerCapabilityProvider;
import nl.requios.effortlessbuilding.helper.SurvivalHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class AbstractRandomizerBagItem
extends Item {
    private static long currentSeed = 1337L;
    private static final Random rand = new Random(currentSeed);

    public AbstractRandomizerBagItem() {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78040_i).func_200917_a(1));
    }

    public abstract int getInventorySize();

    public abstract INamedContainerProvider getContainerProvider(ItemStack var1);

    public IItemHandler getBagInventory(ItemStack bag) {
        return (IItemHandler)bag.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse(null);
    }

    public ItemStack pickRandomStack(IItemHandler bagInventory) {
        int nonempty = 0;
        ArrayList<ItemStack> nonEmptyStacks = new ArrayList<ItemStack>();
        ArrayList<Integer> originalSlots = new ArrayList<Integer>(this.getInventorySize());
        for (int i = 0; i < bagInventory.getSlots(); ++i) {
            ItemStack stack = bagInventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            ++nonempty;
            nonEmptyStacks.add(stack);
            originalSlots.add(i);
        }
        if (nonEmptyStacks.size() != originalSlots.size()) {
            throw new Error("NonEmptyStacks and OriginalSlots not same size");
        }
        if (nonempty == 0) {
            return ItemStack.field_190927_a;
        }
        int randomSlot = rand.nextInt(nonempty);
        if (randomSlot < 0 || randomSlot > bagInventory.getSlots()) {
            return ItemStack.field_190927_a;
        }
        int originalSlot = (Integer)originalSlots.get(randomSlot);
        if (originalSlot < 0 || originalSlot > bagInventory.getSlots()) {
            return ItemStack.field_190927_a;
        }
        return bagInventory.getStackInSlot(originalSlot);
    }

    public ItemStack findStack(IItemHandler bagInventory, Item item) {
        for (int i = 0; i < bagInventory.getSlots(); ++i) {
            ItemStack stack = bagInventory.getStackInSlot(i);
            if (stack.func_190926_b() || stack.func_77973_b() != item) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static void resetRandomness() {
        rand.setSeed(currentSeed);
    }

    public static void renewRandomness() {
        currentSeed = Calendar.getInstance().getTimeInMillis();
        rand.setSeed(currentSeed);
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        PlayerEntity player = ctx.func_195999_j();
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        Direction facing = ctx.func_196000_l();
        ItemStack item = ctx.func_195996_i();
        Vector3d hitVec = ctx.func_221532_j();
        if (player == null) {
            return ActionResultType.FAIL;
        }
        if (ctx.func_195999_j() != null && ctx.func_195999_j().func_225608_bj_()) {
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this.getContainerProvider(item));
        } else {
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            BuildModes.BuildModeEnum buildMode = ModeSettingsManager.getModeSettings(player).getBuildMode();
            ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings(player);
            if (buildMode != BuildModes.BuildModeEnum.NORMAL || modifierSettings.doQuickReplace()) {
                return ActionResultType.FAIL;
            }
            ItemStack bag = player.func_184586_b(Hand.MAIN_HAND);
            IItemHandler bagInventory = this.getBagInventory(bag);
            if (bagInventory == null) {
                return ActionResultType.FAIL;
            }
            ItemStack toPlace = this.pickRandomStack(bagInventory);
            if (toPlace.func_190926_b()) {
                return ActionResultType.FAIL;
            }
            if (!world.func_180495_p(pos).func_177230_c().func_225541_a_(world.func_180495_p(pos), Fluids.field_204541_a)) {
                pos = pos.func_177972_a(facing);
            }
            BlockItemUseContext blockItemUseContext = new BlockItemUseContext(new ItemUseContext(player, Hand.MAIN_HAND, new BlockRayTraceResult(hitVec, facing, pos, false)));
            BlockState blockState = Block.func_149634_a((Item)toPlace.func_77973_b()).func_196258_a(blockItemUseContext);
            SurvivalHelper.placeBlock(world, player, pos, blockState, toPlace, facing, hitVec, false, false, true);
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack bag = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            if (world.field_72995_K) {
                return new ActionResult(ActionResultType.SUCCESS, (Object)bag);
            }
        } else {
            IItemHandler bagInventory = this.getBagInventory(bag);
            if (bagInventory == null) {
                return new ActionResult(ActionResultType.FAIL, (Object)bag);
            }
            ItemStack toUse = this.pickRandomStack(bagInventory);
            if (toUse.func_190926_b()) {
                return new ActionResult(ActionResultType.FAIL, (Object)bag);
            }
            return toUse.func_77957_a(world, player, hand);
        }
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this.getContainerProvider(bag));
        return new ActionResult(ActionResultType.PASS, (Object)bag);
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return 1;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ItemHandlerCapabilityProvider(this.getInventorySize());
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + "Rightclick" + TextFormatting.GRAY + " to place a random block"));
        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + "Sneak + rightclick" + TextFormatting.GRAY + " to open inventory"));
        if (world != null && world.func_217369_A().size() > 1) {
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Experimental on servers: may lose inventory"));
        }
    }

    public String func_77658_a() {
        return this.getRegistryName().toString();
    }
}

