/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.gui.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FocusableGui;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class SlotGui
extends FocusableGui
implements IRenderable {
    protected final Minecraft minecraft;
    protected final int itemHeight;
    protected int width;
    protected int height;
    protected int y0;
    protected int y1;
    protected int x1;
    protected int x0;
    protected int yDrag = -2;
    protected double yo;
    protected boolean visible = true;
    protected boolean renderSelection = true;
    protected boolean renderHeader;
    protected int headerHeight;
    private boolean scrolling;

    public SlotGui(Minecraft mcIn, int width, int height, int topIn, int bottomIn, int slotHeightIn) {
        this.minecraft = mcIn;
        this.width = width;
        this.height = height;
        this.y0 = topIn;
        this.y1 = bottomIn;
        this.itemHeight = slotHeightIn;
        this.x0 = 0;
        this.x1 = width;
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected abstract int getItemCount();

    public List<? extends IGuiEventListener> func_231039_at__() {
        return Collections.emptyList();
    }

    protected boolean selectItem(int p_selectItem_1_, int p_selectItem_2_, double p_selectItem_3_, double p_selectItem_5_) {
        return true;
    }

    protected abstract boolean isSelectedItem(int var1);

    protected int getMaxPosition() {
        return this.getItemCount() * this.itemHeight + this.headerHeight;
    }

    protected abstract void renderBackground();

    protected void updateItemPosition(int p_updateItemPosition_1_, int p_updateItemPosition_2_, int p_updateItemPosition_3_, float p_updateItemPosition_4_) {
    }

    protected abstract void renderItem(MatrixStack var1, int var2, int var3, int var4, int var5, int var6, int var7, float var8);

    protected void renderHeader(int p_renderHeader_1_, int p_renderHeader_2_, Tessellator p_renderHeader_3_) {
    }

    protected void clickedHeader(int p_clickedHeader_1_, int p_clickedHeader_2_) {
    }

    public int getItemAtPosition(double p_getItemAtPosition_1_, double p_getItemAtPosition_3_) {
        int i = this.x0 + this.width / 2 - this.getRowWidth() / 2;
        int j = this.x0 + this.width / 2 + this.getRowWidth() / 2;
        int k = MathHelper.func_76128_c((double)(p_getItemAtPosition_3_ - (double)this.y0)) - this.headerHeight + (int)this.yo - 4;
        int l = k / this.itemHeight;
        return p_getItemAtPosition_1_ < (double)this.getScrollbarPosition() && p_getItemAtPosition_1_ >= (double)i && p_getItemAtPosition_1_ <= (double)j && l >= 0 && k >= 0 && l < this.getItemCount() ? l : -1;
    }

    protected void capYPosition() {
        this.yo = MathHelper.func_151237_a((double)this.yo, (double)0.0, (double)this.getMaxScroll());
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - (this.y1 - this.y0 - 4));
    }

    public int getScroll() {
        return (int)this.yo;
    }

    public boolean isMouseInList(double p_isMouseInList_1_, double p_isMouseInList_3_) {
        return p_isMouseInList_3_ >= (double)this.y0 && p_isMouseInList_3_ <= (double)this.y1 && p_isMouseInList_1_ >= (double)this.x0 && p_isMouseInList_1_ <= (double)this.x1;
    }

    public abstract void func_230430_a_(MatrixStack var1, int var2, int var3, float var4);

    protected void updateScrollingState(double p_updateScrollingState_1_, double p_updateScrollingState_3_, int p_updateScrollingState_5_) {
        this.scrolling = p_updateScrollingState_5_ == 0 && p_updateScrollingState_1_ >= (double)this.getScrollbarPosition() && p_updateScrollingState_1_ < (double)(this.getScrollbarPosition() + 6);
    }

    public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        this.updateScrollingState(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        if (this.isVisible() && this.isMouseInList(p_mouseClicked_1_, p_mouseClicked_3_)) {
            int i = this.getItemAtPosition(p_mouseClicked_1_, p_mouseClicked_3_);
            if (i == -1 && p_mouseClicked_5_ == 0) {
                this.clickedHeader((int)(p_mouseClicked_1_ - (double)(this.x0 + this.width / 2 - this.getRowWidth() / 2)), (int)(p_mouseClicked_3_ - (double)this.y0) + (int)this.yo - 4);
                return true;
            }
            if (i != -1 && this.selectItem(i, p_mouseClicked_5_, p_mouseClicked_1_, p_mouseClicked_3_)) {
                if (this.func_231039_at__().size() > i) {
                    this.func_231035_a_(this.func_231039_at__().get(i));
                }
                this.func_231037_b__(true);
                return true;
            }
            return this.scrolling;
        }
        return false;
    }

    public boolean func_231048_c_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        if (this.func_241217_q_() != null) {
            this.func_241217_q_().func_231048_c_(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
        }
        return false;
    }

    public boolean func_231045_a_(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        if (super.func_231045_a_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_)) {
            return true;
        }
        if (this.isVisible() && p_mouseDragged_5_ == 0 && this.scrolling) {
            if (p_mouseDragged_3_ < (double)this.y0) {
                this.yo = 0.0;
            } else if (p_mouseDragged_3_ > (double)this.y1) {
                this.yo = this.getMaxScroll();
            } else {
                double d0 = this.getMaxScroll();
                if (d0 < 1.0) {
                    d0 = 1.0;
                }
                int i = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
                double d1 = d0 / (double)(this.y1 - this.y0 - (i = MathHelper.func_76125_a((int)i, (int)32, (int)(this.y1 - this.y0 - 8))));
                if (d1 < 1.0) {
                    d1 = 1.0;
                }
                this.yo += p_mouseDragged_8_ * d1;
                this.capYPosition();
            }
            return true;
        }
        return false;
    }

    public boolean func_231043_a_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        if (!this.isVisible()) {
            return false;
        }
        this.yo -= p_mouseScrolled_5_ * (double)this.itemHeight / 2.0;
        return true;
    }

    public boolean func_231046_a_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (!this.isVisible()) {
            return false;
        }
        if (super.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) {
            return true;
        }
        if (p_keyPressed_1_ == 264) {
            this.moveSelection(1);
            return true;
        }
        if (p_keyPressed_1_ == 265) {
            this.moveSelection(-1);
            return true;
        }
        return false;
    }

    protected void moveSelection(int p_moveSelection_1_) {
    }

    public boolean func_231042_a_(char p_charTyped_1_, int p_charTyped_2_) {
        return this.isVisible() && super.func_231042_a_(p_charTyped_1_, p_charTyped_2_);
    }

    public boolean func_231047_b_(double p_isMouseOver_1_, double p_isMouseOver_3_) {
        return this.isMouseInList(p_isMouseOver_1_, p_isMouseOver_3_);
    }

    public int getRowWidth() {
        return 220;
    }

    protected void renderList(MatrixStack ms, int p_renderList_1_, int p_renderList_2_, int p_renderList_3_, int p_renderList_4_, float p_renderList_5_) {
        int i = this.getItemCount();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        for (int j = 0; j < i; ++j) {
            int k = p_renderList_2_ + j * this.itemHeight + this.headerHeight;
            int l = this.itemHeight - 4;
            if (k > this.y1 || k + l < this.y0) {
                this.updateItemPosition(j, p_renderList_1_, k, p_renderList_5_);
            }
            if (this.renderSelection && this.isSelectedItem(j)) {
                int i1 = this.x0 + this.width / 2 - this.getRowWidth() / 2;
                int j1 = this.x0 + this.width / 2 + this.getRowWidth() / 2;
                RenderSystem.disableTexture();
                float f = this.isFocused() ? 1.0f : 0.5f;
                RenderSystem.color4f((float)f, (float)f, (float)f, (float)1.0f);
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                bufferbuilder.func_225582_a_((double)i1, (double)(k + l + 2), 0.0).func_181675_d();
                bufferbuilder.func_225582_a_((double)j1, (double)(k + l + 2), 0.0).func_181675_d();
                bufferbuilder.func_225582_a_((double)j1, (double)(k - 2), 0.0).func_181675_d();
                bufferbuilder.func_225582_a_((double)i1, (double)(k - 2), 0.0).func_181675_d();
                tessellator.func_78381_a();
                RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                bufferbuilder.func_225582_a_((double)(i1 + 1), (double)(k + l + 1), 0.0).func_181675_d();
                bufferbuilder.func_225582_a_((double)(j1 - 1), (double)(k + l + 1), 0.0).func_181675_d();
                bufferbuilder.func_225582_a_((double)(j1 - 1), (double)(k - 1), 0.0).func_181675_d();
                bufferbuilder.func_225582_a_((double)(i1 + 1), (double)(k - 1), 0.0).func_181675_d();
                tessellator.func_78381_a();
                RenderSystem.enableTexture();
            }
            this.renderItem(ms, j, p_renderList_1_, k, l, p_renderList_3_, p_renderList_4_, p_renderList_5_);
        }
    }

    protected boolean isFocused() {
        return false;
    }

    protected int getScrollbarPosition() {
        return this.width / 2 + 124;
    }
}

