/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.gui.buildmodifier;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmodifier.Array;
import nl.requios.effortlessbuilding.buildmodifier.Mirror;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.buildmodifier.RadialMirror;
import nl.requios.effortlessbuilding.gui.buildmodifier.ArraySettingsGui;
import nl.requios.effortlessbuilding.gui.buildmodifier.MirrorSettingsGui;
import nl.requios.effortlessbuilding.gui.buildmodifier.RadialMirrorSettingsGui;
import nl.requios.effortlessbuilding.gui.elements.GuiScrollPane;
import nl.requios.effortlessbuilding.network.ModifierSettingsMessage;
import nl.requios.effortlessbuilding.network.PacketHandler;
import nl.requios.effortlessbuilding.proxy.ClientProxy;

@OnlyIn(value=Dist.CLIENT)
public class ModifierSettingsGui
extends Screen {
    private GuiScrollPane scrollPane;
    private Button buttonClose;
    private MirrorSettingsGui mirrorSettingsGui;
    private ArraySettingsGui arraySettingsGui;
    private RadialMirrorSettingsGui radialMirrorSettingsGui;

    public ModifierSettingsGui() {
        super((ITextComponent)new TranslationTextComponent("effortlessbuilding.screen.modifier_settings"));
    }

    protected void func_231160_c_() {
        this.scrollPane = new GuiScrollPane(this, this.field_230712_o_, 8, this.field_230709_l_ - 30);
        this.mirrorSettingsGui = new MirrorSettingsGui(this.scrollPane);
        this.scrollPane.AddListEntry(this.mirrorSettingsGui);
        this.arraySettingsGui = new ArraySettingsGui(this.scrollPane);
        this.scrollPane.AddListEntry(this.arraySettingsGui);
        this.radialMirrorSettingsGui = new RadialMirrorSettingsGui(this.scrollPane);
        this.scrollPane.AddListEntry(this.radialMirrorSettingsGui);
        this.scrollPane.init(this.field_230710_m_);
        int y = this.field_230709_l_ - 26;
        this.buttonClose = new Button(this.field_230708_k_ / 2 - 100, y, 200, 20, (ITextComponent)new StringTextComponent("Close"), button -> Minecraft.func_71410_x().field_71439_g.func_71053_j());
        this.field_230710_m_.add(this.buttonClose);
    }

    public void func_231023_e_() {
        this.scrollPane.updateScreen();
        this.handleMouseInput();
    }

    public void func_230430_a_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(ms);
        this.scrollPane.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        this.buttonClose.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        this.scrollPane.drawTooltip(ms, this, mouseX, mouseY);
    }

    public boolean func_231042_a_(char typedChar, int keyCode) {
        super.func_231042_a_(typedChar, keyCode);
        this.scrollPane.func_231042_a_(typedChar, keyCode);
        if (keyCode == ClientProxy.keyBindings[0].getKey().func_197937_c()) {
            this.field_230706_i_.field_71439_g.func_71053_j();
        }
        return false;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        super.func_231044_a_(mouseX, mouseY, mouseButton);
        this.field_230710_m_.forEach(button -> button.func_231044_a_(mouseX, mouseY, mouseButton));
        return this.scrollPane.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int state) {
        if (state != 0 || !this.scrollPane.func_231048_c_(mouseX, mouseY, state)) {
            return super.func_231048_c_(mouseX, mouseY, state);
        }
        return false;
    }

    public void handleMouseInput() {
        this.scrollPane.handleMouseInput();
    }

    public void func_231164_f_() {
        this.scrollPane.onGuiClosed();
        Mirror.MirrorSettings m = this.mirrorSettingsGui.getMirrorSettings();
        Array.ArraySettings a = this.arraySettingsGui.getArraySettings();
        RadialMirror.RadialMirrorSettings r = this.radialMirrorSettingsGui.getRadialMirrorSettings();
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings((PlayerEntity)this.field_230706_i_.field_71439_g);
        if (modifierSettings == null) {
            modifierSettings = new ModifierSettingsManager.ModifierSettings();
        }
        modifierSettings.setMirrorSettings(m);
        modifierSettings.setArraySettings(a);
        modifierSettings.setRadialMirrorSettings(r);
        String error = ModifierSettingsManager.sanitize(modifierSettings, (PlayerEntity)this.field_230706_i_.field_71439_g);
        if (!error.isEmpty()) {
            EffortlessBuilding.log((PlayerEntity)this.field_230706_i_.field_71439_g, error);
        }
        ModifierSettingsManager.setModifierSettings((PlayerEntity)this.field_230706_i_.field_71439_g, modifierSettings);
        PacketHandler.INSTANCE.sendToServer((Object)new ModifierSettingsMessage(modifierSettings));
        Minecraft.func_71410_x().field_71417_B.func_198034_i();
    }
}

