/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.gui.buildmode;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;
import net.minecraftforge.fml.client.gui.widget.Slider;
import nl.requios.effortlessbuilding.EffortlessBuilding;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PlayerSettingsGui
extends Screen {
    protected int left;
    protected int right;
    protected int top;
    protected int bottom;
    protected boolean showShaderList = false;
    private Button shaderTypeButton;
    private ShaderTypeList shaderTypeList;
    private Button closeButton;

    public PlayerSettingsGui() {
        super((ITextComponent)new TranslationTextComponent("effortlessbuilding.screen.player_settings"));
    }

    protected void func_231160_c_() {
        this.left = this.field_230708_k_ / 2 - 140;
        this.right = this.field_230708_k_ / 2 + 140;
        this.top = this.field_230709_l_ / 2 - 100;
        this.bottom = this.field_230709_l_ / 2 + 100;
        int yy = this.top;
        this.shaderTypeList = new ShaderTypeList(this.field_230706_i_);
        this.field_230705_e_.add(this.shaderTypeList);
        ITextComponent currentShaderName = ShaderType.DISSOLVE_BLUE.name;
        this.shaderTypeButton = new ExtendedButton(this.right - 180, yy, 180, 20, currentShaderName, button -> {
            this.showShaderList = !this.showShaderList;
        });
        this.func_230480_a_((Widget)this.shaderTypeButton);
        Slider slider = new Slider(this.right - 200, yy += 50, 200, 20, StringTextComponent.field_240750_d_, StringTextComponent.field_240750_d_, 0.5, 2.0, 1.0, true, true, button -> {});
        this.func_230480_a_((Widget)slider);
        this.closeButton = new ExtendedButton(this.left + 50, this.bottom - 20, 180, 20, (ITextComponent)new StringTextComponent("Done"), button -> this.field_230706_i_.field_71439_g.func_71053_j());
        this.func_230480_a_((Widget)this.closeButton);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
    }

    public void func_230430_a_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(ms);
        int yy = this.top;
        this.field_230712_o_.func_238421_b_(ms, "Shader type", (float)this.left, (float)(yy + 5), 0xFFFFFF);
        this.field_230712_o_.func_238421_b_(ms, "Shader speed", (float)this.left, (float)((yy += 50) + 5), 0xFFFFFF);
        super.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        if (this.showShaderList) {
            this.shaderTypeList.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        super.func_231044_a_(mouseX, mouseY, mouseButton);
        if (this.showShaderList && !this.shaderTypeList.func_231047_b_(mouseX, mouseY) && !this.shaderTypeButton.func_231047_b_(mouseX, mouseY)) {
            this.showShaderList = false;
        }
        return true;
    }

    public void func_231164_f_() {
        ShaderTypeList.ShaderTypeEntry selectedShader = (ShaderTypeList.ShaderTypeEntry)this.shaderTypeList.func_230958_g_();
    }

    @OnlyIn(value=Dist.CLIENT)
    class ShaderTypeList
    extends ExtendedList<ShaderTypeEntry> {
        public ShaderTypeList(Minecraft mcIn) {
            super(mcIn, 180, 140, PlayerSettingsGui.this.top + 20, PlayerSettingsGui.this.top + 100, 18);
            this.func_230959_g_(PlayerSettingsGui.this.right - this.field_230670_d_);
            for (int i = 0; i < 40; ++i) {
                for (ShaderType shaderType : ShaderType.values()) {
                    ShaderTypeEntry shaderTypeEntry = new ShaderTypeEntry(shaderType);
                    this.func_230513_b_((AbstractList.AbstractListEntry)shaderTypeEntry);
                }
            }
            if (this.func_230958_g_() != null) {
                this.func_230951_c_(this.func_230958_g_());
            }
        }

        public int func_230949_c_() {
            return this.field_230670_d_;
        }

        public void setSelected(ShaderTypeEntry selected) {
            super.func_241215_a_((AbstractList.AbstractListEntry)selected);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            EffortlessBuilding.log("Selected shader " + ((ShaderTypeEntry)selected).shaderType.name);
            PlayerSettingsGui.this.shaderTypeButton.func_238482_a_(((ShaderTypeEntry)selected).shaderType.name);
        }

        public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            if (!PlayerSettingsGui.this.showShaderList) {
                return false;
            }
            return super.func_231044_a_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        }

        public boolean func_231048_c_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
            if (!PlayerSettingsGui.this.showShaderList) {
                return false;
            }
            return super.func_231048_c_(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
        }

        public boolean func_231045_a_(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
            if (!PlayerSettingsGui.this.showShaderList) {
                return false;
            }
            return super.func_231045_a_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
        }

        public boolean func_231043_a_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
            if (!PlayerSettingsGui.this.showShaderList) {
                return false;
            }
            return super.func_231043_a_(p_mouseScrolled_1_, p_mouseScrolled_3_, p_mouseScrolled_5_);
        }

        public boolean func_231047_b_(double p_isMouseOver_1_, double p_isMouseOver_3_) {
            if (!PlayerSettingsGui.this.showShaderList) {
                return false;
            }
            return super.func_231047_b_(p_isMouseOver_1_, p_isMouseOver_3_);
        }

        protected boolean func_230971_aw__() {
            return PlayerSettingsGui.this.func_241217_q_() == this;
        }

        protected int func_230952_d_() {
            return PlayerSettingsGui.this.right - 6;
        }

        public void func_230430_a_(MatrixStack ms, int p_render_1_, int p_render_2_, float p_render_3_) {
            this.func_230433_a_(ms);
            int i = this.func_230952_d_();
            int j = i + 6;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float f = 32.0f;
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_225582_a_((double)this.field_230675_l_, (double)this.field_230673_j_, 0.0).func_225586_a_(20, 20, 20, 180).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.field_230674_k_, (double)this.field_230673_j_, 0.0).func_225586_a_(20, 20, 20, 180).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.field_230674_k_, (double)this.field_230672_i_, 0.0).func_225586_a_(20, 20, 20, 180).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.field_230675_l_, (double)this.field_230672_i_, 0.0).func_225586_a_(20, 20, 20, 180).func_181675_d();
            tessellator.func_78381_a();
            int k = this.func_230968_n_();
            int l = this.field_230672_i_ + 4 - (int)this.func_230966_l_();
            if (this.field_230680_q_) {
                this.func_230448_a_(ms, k, l, tessellator);
            }
            this.func_238478_a_(ms, k, l, p_render_1_, p_render_2_, p_render_3_);
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.disableAlphaTest();
            RenderSystem.shadeModel((int)7425);
            RenderSystem.disableTexture();
            int j1 = this.func_230955_e_();
            if (j1 > 0) {
                int k1 = (int)((float)((this.field_230673_j_ - this.field_230672_i_) * (this.field_230673_j_ - this.field_230672_i_)) / (float)this.func_230945_b_());
                k1 = MathHelper.func_76125_a((int)k1, (int)32, (int)(this.field_230673_j_ - this.field_230672_i_ - 8));
                int l1 = (int)this.func_230966_l_() * (this.field_230673_j_ - this.field_230672_i_ - k1) / j1 + this.field_230672_i_;
                if (l1 < this.field_230672_i_) {
                    l1 = this.field_230672_i_;
                }
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_225582_a_((double)i, (double)this.field_230673_j_, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)j, (double)this.field_230673_j_, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)j, (double)this.field_230672_i_, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)i, (double)this.field_230672_i_, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                tessellator.func_78381_a();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_225582_a_((double)i, (double)(l1 + k1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)j, (double)(l1 + k1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)j, (double)l1, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)i, (double)l1, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                tessellator.func_78381_a();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_225582_a_((double)i, (double)(l1 + k1 - 1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)(j - 1), (double)(l1 + k1 - 1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)(j - 1), (double)l1, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)i, (double)l1, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                tessellator.func_78381_a();
            }
            RenderSystem.enableTexture();
            RenderSystem.shadeModel((int)7424);
            RenderSystem.enableAlphaTest();
            RenderSystem.disableBlend();
        }

        public int func_230955_e_() {
            return Math.max(0, this.func_230945_b_() - (this.field_230673_j_ - this.field_230672_i_ - 4));
        }

        @OnlyIn(value=Dist.CLIENT)
        public class ShaderTypeEntry
        extends ExtendedList.AbstractListEntry<ShaderTypeEntry> {
            private final ShaderType shaderType;

            public ShaderTypeEntry(ShaderType shaderType) {
                this.shaderType = shaderType;
            }

            public void func_230432_a_(MatrixStack ms, int itemIndex, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
                if (rowTop + 10 > ShaderTypeList.this.field_230672_i_ && rowTop + rowHeight - 5 < ShaderTypeList.this.field_230673_j_) {
                    AbstractGui.func_238475_b_((MatrixStack)ms, (FontRenderer)PlayerSettingsGui.this.field_230712_o_, (ITextComponent)this.shaderType.name, (int)(ShaderTypeList.this.field_230675_l_ + 8), (int)(rowTop + 4), (int)0xFFFFFF);
                }
            }

            public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
                if (p_mouseClicked_5_ == 0) {
                    ShaderTypeList.this.setSelected(this);
                    return true;
                }
                return false;
            }
        }
    }

    public static enum ShaderType {
        DISSOLVE_BLUE("Dissolve Blue"),
        DISSOLVE_ORANGE("Dissolve Orange");

        public ITextComponent name;

        private ShaderType(ITextComponent name) {
            this.name = name;
        }

        private ShaderType(String name) {
            this.name = new StringTextComponent(name);
        }
    }
}

