/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmodifier;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.items.IItemHandler;
import nl.requios.effortlessbuilding.buildmodifier.BuildModifiers;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.item.AbstractRandomizerBagItem;

public class RadialMirror {
    public static List<BlockPos> findCoordinates(PlayerEntity player, BlockPos startPos) {
        ArrayList<BlockPos> coordinates = new ArrayList<BlockPos>();
        RadialMirrorSettings r = ModifierSettingsManager.getModifierSettings(player).getRadialMirrorSettings();
        if (!RadialMirror.isEnabled(r, startPos)) {
            return coordinates;
        }
        double sliceAngle = Math.PI * 2 / (double)r.slices;
        Vector3d startVec = new Vector3d((double)((float)startPos.func_177958_n() + 0.5f), (double)((float)startPos.func_177956_o() + 0.5f), (double)((float)startPos.func_177952_p() + 0.5f));
        Vector3d relStartVec = startVec.func_178788_d(r.position);
        double startAngleToCenter = MathHelper.func_181159_b((double)relStartVec.field_72450_a, (double)relStartVec.field_72449_c);
        if (startAngleToCenter < 0.0) {
            startAngleToCenter += Math.PI;
        }
        double startAngleInSlice = startAngleToCenter % sliceAngle;
        for (int i = 1; i < r.slices; ++i) {
            Vector3d relNewVec;
            BlockPos newBlockPos;
            double curAngle = sliceAngle * (double)i;
            if (r.alternate && i % 2 == 1) {
                curAngle = curAngle - startAngleInSlice + (sliceAngle - startAngleInSlice);
            }
            if (coordinates.contains(newBlockPos = new BlockPos(r.position.func_178787_e(relNewVec = relStartVec.func_178785_b((float)curAngle)))) || newBlockPos.equals((Object)startPos)) continue;
            coordinates.add(newBlockPos);
        }
        return coordinates;
    }

    public static List<BlockState> findBlockStates(PlayerEntity player, BlockPos startPos, BlockState blockState, ItemStack itemStack, List<ItemStack> itemStacks) {
        ArrayList<BlockState> blockStates = new ArrayList<BlockState>();
        ArrayList<BlockPos> coordinates = new ArrayList<BlockPos>();
        RadialMirrorSettings r = ModifierSettingsManager.getModifierSettings(player).getRadialMirrorSettings();
        if (!RadialMirror.isEnabled(r, startPos)) {
            return blockStates;
        }
        double sliceAngle = Math.PI * 2 / (double)r.slices;
        Vector3d startVec = new Vector3d((double)((float)startPos.func_177958_n() + 0.5f), (double)((float)startPos.func_177956_o() + 0.5f), (double)((float)startPos.func_177952_p() + 0.5f));
        Vector3d relStartVec = startVec.func_178788_d(r.position);
        double startAngleToCenter = MathHelper.func_181159_b((double)relStartVec.field_72450_a, (double)relStartVec.field_72449_c);
        double startAngleToCenterMod = startAngleToCenter < 0.0 ? startAngleToCenter + Math.PI : startAngleToCenter;
        double startAngleInSlice = startAngleToCenterMod % sliceAngle;
        blockState = RadialMirror.rotateOriginalBlockState(startAngleToCenter, blockState);
        AbstractRandomizerBagItem randomizerBagItem = null;
        IItemHandler bagInventory = null;
        if (!itemStack.func_190926_b() && itemStack.func_77973_b() instanceof AbstractRandomizerBagItem) {
            randomizerBagItem = (AbstractRandomizerBagItem)itemStack.func_77973_b();
            bagInventory = randomizerBagItem.getBagInventory(itemStack);
        }
        for (int i = 1; i < r.slices; ++i) {
            Vector3d relNewVec;
            BlockPos newBlockPos;
            BlockState newBlockState = blockState;
            double curAngle = sliceAngle * (double)i;
            if (r.alternate && i % 2 == 1) {
                curAngle = curAngle - startAngleInSlice + (sliceAngle - startAngleInSlice);
            }
            if (coordinates.contains(newBlockPos = new BlockPos(r.position.func_178787_e(relNewVec = relStartVec.func_178785_b((float)curAngle)))) || newBlockPos.equals((Object)startPos)) continue;
            coordinates.add(newBlockPos);
            if (bagInventory != null) {
                itemStack = randomizerBagItem.pickRandomStack(bagInventory);
                newBlockState = BuildModifiers.getBlockStateFromItem(itemStack, player, startPos, Direction.UP, new Vector3d(0.0, 0.0, 0.0), Hand.MAIN_HAND);
                newBlockState = RadialMirror.rotateOriginalBlockState(startAngleToCenter, newBlockState);
            }
            newBlockState = RadialMirror.rotateBlockState(relNewVec, newBlockState, r.alternate && i % 2 == 1);
            blockStates.add(newBlockState);
            itemStacks.add(itemStack);
        }
        return blockStates;
    }

    private static BlockState rotateOriginalBlockState(double startAngleToCenter, BlockState blockState) {
        BlockState newBlockState = blockState;
        if (startAngleToCenter < -2.3593360828459344 || startAngleToCenter > 2.3530528975387552) {
            newBlockState = blockState.func_185907_a(Rotation.CLOCKWISE_180);
        } else if (startAngleToCenter < -0.7885397560510381) {
            newBlockState = blockState.func_185907_a(Rotation.COUNTERCLOCKWISE_90);
        } else if (startAngleToCenter > 0.7822565707438585) {
            newBlockState = blockState.func_185907_a(Rotation.CLOCKWISE_90);
        }
        return newBlockState;
    }

    private static BlockState rotateBlockState(Vector3d relVec, BlockState blockState, boolean alternate) {
        BlockState newBlockState;
        double angleToCenter = MathHelper.func_181159_b((double)relVec.field_72450_a, (double)relVec.field_72449_c);
        if (angleToCenter < -2.3593360828459344 || angleToCenter > 2.3530528975387552) {
            newBlockState = blockState.func_185907_a(Rotation.CLOCKWISE_180);
            if (alternate) {
                newBlockState = newBlockState.func_185902_a(Mirror.FRONT_BACK);
            }
        } else if (angleToCenter < -0.7885397560510381) {
            newBlockState = blockState.func_185907_a(Rotation.CLOCKWISE_90);
            if (alternate) {
                newBlockState = newBlockState.func_185902_a(Mirror.LEFT_RIGHT);
            }
        } else if (angleToCenter > 0.7822565707438585) {
            newBlockState = blockState.func_185907_a(Rotation.COUNTERCLOCKWISE_90);
            if (alternate) {
                newBlockState = newBlockState.func_185902_a(Mirror.LEFT_RIGHT);
            }
        } else {
            newBlockState = blockState;
            if (alternate) {
                newBlockState = newBlockState.func_185902_a(Mirror.FRONT_BACK);
            }
        }
        return newBlockState;
    }

    public static boolean isEnabled(RadialMirrorSettings r, BlockPos startPos) {
        if (r == null || !r.enabled) {
            return false;
        }
        return !(new Vector3d((double)startPos.func_177958_n() + 0.5, (double)startPos.func_177956_o() + 0.5, (double)startPos.func_177952_p() + 0.5).func_178788_d(r.position).func_189985_c() > (double)(r.radius * r.radius));
    }

    public static class RadialMirrorSettings {
        public boolean enabled = false;
        public Vector3d position = new Vector3d(0.5, 64.5, 0.5);
        public int slices = 4;
        public boolean alternate = false;
        public int radius = 20;
        public boolean drawLines = true;
        public boolean drawPlanes = false;

        public RadialMirrorSettings() {
        }

        public RadialMirrorSettings(boolean enabled, Vector3d position, int slices, boolean alternate, int radius, boolean drawLines, boolean drawPlanes) {
            this.enabled = enabled;
            this.position = position;
            this.slices = slices;
            this.alternate = alternate;
            this.radius = radius;
            this.drawLines = drawLines;
            this.drawPlanes = drawPlanes;
        }

        public int getReach() {
            return this.radius * 2;
        }
    }
}

