/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmodifier;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.items.IItemHandler;
import nl.requios.effortlessbuilding.buildmodifier.BuildModifiers;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.item.AbstractRandomizerBagItem;

public class Array {
    public static List<BlockPos> findCoordinates(PlayerEntity player, BlockPos startPos) {
        ArrayList<BlockPos> coordinates = new ArrayList<BlockPos>();
        ArraySettings a = ModifierSettingsManager.getModifierSettings(player).getArraySettings();
        if (!Array.isEnabled(a)) {
            return coordinates;
        }
        BlockPos pos = startPos;
        Vector3i offset = new Vector3i(a.offset.func_177958_n(), a.offset.func_177956_o(), a.offset.func_177952_p());
        for (int i = 0; i < a.count; ++i) {
            pos = pos.func_177971_a(offset);
            coordinates.add(pos);
        }
        return coordinates;
    }

    public static List<BlockState> findBlockStates(PlayerEntity player, BlockPos startPos, BlockState blockState, ItemStack itemStack, List<ItemStack> itemStacks) {
        ArrayList<BlockState> blockStates = new ArrayList<BlockState>();
        ArraySettings a = ModifierSettingsManager.getModifierSettings(player).getArraySettings();
        if (!Array.isEnabled(a)) {
            return blockStates;
        }
        BlockPos pos = startPos;
        Vector3i offset = new Vector3i(a.offset.func_177958_n(), a.offset.func_177956_o(), a.offset.func_177952_p());
        AbstractRandomizerBagItem randomizerBagItem = null;
        IItemHandler bagInventory = null;
        if (!itemStack.func_190926_b() && itemStack.func_77973_b() instanceof AbstractRandomizerBagItem) {
            randomizerBagItem = (AbstractRandomizerBagItem)itemStack.func_77973_b();
            bagInventory = randomizerBagItem.getBagInventory(itemStack);
        }
        for (int i = 0; i < a.count; ++i) {
            pos = pos.func_177971_a(offset);
            if (randomizerBagItem != null) {
                itemStack = randomizerBagItem.pickRandomStack(bagInventory);
                blockState = BuildModifiers.getBlockStateFromItem(itemStack, player, startPos, Direction.UP, new Vector3d(0.0, 0.0, 0.0), Hand.MAIN_HAND);
            }
            blockStates.add(blockState);
            itemStacks.add(itemStack);
        }
        return blockStates;
    }

    public static boolean isEnabled(ArraySettings a) {
        if (a == null || !a.enabled) {
            return false;
        }
        return a.offset.func_177958_n() != 0 || a.offset.func_177956_o() != 0 || a.offset.func_177952_p() != 0;
    }

    public static class ArraySettings {
        public boolean enabled = false;
        public BlockPos offset = BlockPos.field_177992_a;
        public int count = 5;

        public ArraySettings() {
        }

        public ArraySettings(boolean enabled, BlockPos offset, int count) {
            this.enabled = enabled;
            this.offset = offset;
            this.count = count;
        }

        public int getReach() {
            int x = Math.abs(this.offset.func_177958_n());
            int y = Math.abs(this.offset.func_177956_o());
            int z = Math.abs(this.offset.func_177952_p());
            int largestOffset = Math.max(Math.max(x, y), z);
            return largestOffset * this.count;
        }
    }
}

