/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmode.buildmodes;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import nl.requios.effortlessbuilding.buildmode.BuildModes;
import nl.requios.effortlessbuilding.buildmode.TwoClicksBuildMode;
import nl.requios.effortlessbuilding.helper.ReachHelper;

public class Line
extends TwoClicksBuildMode {
    public static BlockPos findLine(PlayerEntity player, BlockPos firstPos, boolean skipRaytrace) {
        Vector3d look = BuildModes.getPlayerLookVec(player);
        Vector3d start = new Vector3d(player.func_226277_ct_(), player.func_226278_cu_() + (double)player.func_70047_e(), player.func_226281_cx_());
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>(3);
        Vector3d xBound = BuildModes.findXBound(firstPos.func_177958_n(), start, look);
        criteriaList.add(new Criteria(xBound, firstPos, start));
        Vector3d yBound = BuildModes.findYBound(firstPos.func_177956_o(), start, look);
        criteriaList.add(new Criteria(yBound, firstPos, start));
        Vector3d zBound = BuildModes.findZBound(firstPos.func_177952_p(), start, look);
        criteriaList.add(new Criteria(zBound, firstPos, start));
        int reach = ReachHelper.getPlacementReach(player) * 4;
        criteriaList.removeIf(criteria -> !criteria.isValid(start, look, reach, player, skipRaytrace));
        if (criteriaList.isEmpty()) {
            return null;
        }
        Criteria selected = (Criteria)criteriaList.get(0);
        if (criteriaList.size() > 1) {
            for (int i = 1; i < criteriaList.size(); ++i) {
                Criteria criteria2 = (Criteria)criteriaList.get(i);
                if (criteria2.distToLineSq < 2.0 && selected.distToLineSq < 2.0) {
                    if (!(criteria2.distToPlayerSq < selected.distToPlayerSq)) continue;
                    selected = criteria2;
                    continue;
                }
                if (!(criteria2.distToLineSq < selected.distToLineSq)) continue;
                selected = criteria2;
            }
        }
        return new BlockPos(selected.lineBound);
    }

    public static List<BlockPos> getLineBlocks(PlayerEntity player, int x1, int y1, int z1, int x2, int y2, int z2) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        if (x1 != x2) {
            Line.addXLineBlocks(list, x1, x2, y1, z1);
        } else if (y1 != y2) {
            Line.addYLineBlocks(list, y1, y2, x1, z1);
        } else {
            Line.addZLineBlocks(list, z1, z2, x1, y1);
        }
        return list;
    }

    public static void addXLineBlocks(List<BlockPos> list, int x1, int x2, int y, int z) {
        int x = x1;
        while (x1 < x2 ? x <= x2 : x >= x2) {
            list.add(new BlockPos(x, y, z));
            x += x1 < x2 ? 1 : -1;
        }
    }

    public static void addYLineBlocks(List<BlockPos> list, int y1, int y2, int x, int z) {
        int y = y1;
        while (y1 < y2 ? y <= y2 : y >= y2) {
            list.add(new BlockPos(x, y, z));
            y += y1 < y2 ? 1 : -1;
        }
    }

    public static void addZLineBlocks(List<BlockPos> list, int z1, int z2, int x, int y) {
        int z = z1;
        while (z1 < z2 ? z <= z2 : z >= z2) {
            list.add(new BlockPos(x, y, z));
            z += z1 < z2 ? 1 : -1;
        }
    }

    @Override
    protected BlockPos findSecondPos(PlayerEntity player, BlockPos firstPos, boolean skipRaytrace) {
        return Line.findLine(player, firstPos, skipRaytrace);
    }

    @Override
    protected List<BlockPos> getAllBlocks(PlayerEntity player, int x1, int y1, int z1, int x2, int y2, int z2) {
        return Line.getLineBlocks(player, x1, y1, z1, x2, y2, z2);
    }

    static class Criteria {
        Vector3d planeBound;
        Vector3d lineBound;
        double distToLineSq;
        double distToPlayerSq;

        Criteria(Vector3d planeBound, BlockPos firstPos, Vector3d start) {
            this.planeBound = planeBound;
            this.lineBound = this.toLongestLine(this.planeBound, firstPos);
            this.distToLineSq = this.lineBound.func_178788_d(this.planeBound).func_189985_c();
            this.distToPlayerSq = this.planeBound.func_178788_d(start).func_189985_c();
        }

        private Vector3d toLongestLine(Vector3d boundVec, BlockPos firstPos) {
            BlockPos bound = new BlockPos(boundVec);
            BlockPos firstToSecond = bound.func_177973_b((Vector3i)firstPos);
            int longest = Math.max((firstToSecond = new BlockPos(Math.abs(firstToSecond.func_177958_n()), Math.abs(firstToSecond.func_177956_o()), Math.abs(firstToSecond.func_177952_p()))).func_177958_n(), Math.max(firstToSecond.func_177956_o(), firstToSecond.func_177952_p()));
            if (longest == firstToSecond.func_177958_n()) {
                return new Vector3d((double)bound.func_177958_n(), (double)firstPos.func_177956_o(), (double)firstPos.func_177952_p());
            }
            if (longest == firstToSecond.func_177956_o()) {
                return new Vector3d((double)firstPos.func_177958_n(), (double)bound.func_177956_o(), (double)firstPos.func_177952_p());
            }
            if (longest == firstToSecond.func_177952_p()) {
                return new Vector3d((double)firstPos.func_177958_n(), (double)firstPos.func_177956_o(), (double)bound.func_177952_p());
            }
            return null;
        }

        public boolean isValid(Vector3d start, Vector3d look, int reach, PlayerEntity player, boolean skipRaytrace) {
            return BuildModes.isCriteriaValid(start, look, reach, player, skipRaytrace, this.lineBound, this.planeBound, this.distToPlayerSq);
        }
    }
}

