/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmode;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import nl.requios.effortlessbuilding.buildmode.BaseBuildMode;
import nl.requios.effortlessbuilding.buildmode.BuildModes;
import nl.requios.effortlessbuilding.helper.ReachHelper;

public abstract class ThreeClicksBuildMode
extends BaseBuildMode {
    protected Dictionary<UUID, BlockPos> secondPosTable = new Hashtable<UUID, BlockPos>();

    public static BlockPos findHeight(PlayerEntity player, BlockPos secondPos, boolean skipRaytrace) {
        Vector3d look = BuildModes.getPlayerLookVec(player);
        Vector3d start = new Vector3d(player.func_226277_ct_(), player.func_226278_cu_() + (double)player.func_70047_e(), player.func_226281_cx_());
        ArrayList<HeightCriteria> criteriaList = new ArrayList<HeightCriteria>(3);
        Vector3d xBound = BuildModes.findXBound(secondPos.func_177958_n(), start, look);
        criteriaList.add(new HeightCriteria(xBound, secondPos, start));
        Vector3d zBound = BuildModes.findZBound(secondPos.func_177952_p(), start, look);
        criteriaList.add(new HeightCriteria(zBound, secondPos, start));
        int reach = ReachHelper.getPlacementReach(player) * 4;
        criteriaList.removeIf(criteria -> !criteria.isValid(start, look, reach, player, skipRaytrace));
        if (criteriaList.isEmpty()) {
            return null;
        }
        HeightCriteria selected = (HeightCriteria)criteriaList.get(0);
        if (criteriaList.size() > 1) {
            for (int i = 1; i < criteriaList.size(); ++i) {
                HeightCriteria criteria2 = (HeightCriteria)criteriaList.get(i);
                if (criteria2.distToLineSq < 2.0 && selected.distToLineSq < 2.0) {
                    if (!(criteria2.distToPlayerSq < selected.distToPlayerSq)) continue;
                    selected = criteria2;
                    continue;
                }
                if (!(criteria2.distToLineSq < selected.distToLineSq)) continue;
                selected = criteria2;
            }
        }
        return new BlockPos(selected.lineBound);
    }

    @Override
    public void initialize(PlayerEntity player) {
        super.initialize(player);
        this.secondPosTable.put(player.func_110124_au(), BlockPos.field_177992_a);
    }

    @Override
    public List<BlockPos> onRightClick(PlayerEntity player, BlockPos blockPos, Direction sideHit, Vector3d hitVec, boolean skipRaytrace) {
        ArrayList<BlockPos> list = new ArrayList();
        Dictionary rightClickTable = player.field_70170_p.field_72995_K ? this.rightClickClientTable : this.rightClickServerTable;
        int rightClickNr = (Integer)rightClickTable.get(player.func_110124_au());
        rightClickTable.put(player.func_110124_au(), ++rightClickNr);
        if (rightClickNr == 1) {
            if (blockPos == null) {
                rightClickTable.put(player.func_110124_au(), 0);
                return list;
            }
            this.firstPosTable.put(player.func_110124_au(), blockPos);
            this.sideHitTable.put(player.func_110124_au(), sideHit);
            this.hitVecTable.put(player.func_110124_au(), hitVec);
        } else if (rightClickNr == 2) {
            BlockPos firstPos = (BlockPos)this.firstPosTable.get(player.func_110124_au());
            BlockPos secondPos = this.findSecondPos(player, firstPos, true);
            if (secondPos == null) {
                rightClickTable.put(player.func_110124_au(), 1);
                return list;
            }
            this.secondPosTable.put(player.func_110124_au(), secondPos);
        } else {
            list = this.findCoordinates(player, blockPos, skipRaytrace);
            rightClickTable.put(player.func_110124_au(), 0);
        }
        return list;
    }

    @Override
    public List<BlockPos> findCoordinates(PlayerEntity player, BlockPos blockPos, boolean skipRaytrace) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        Dictionary rightClickTable = player.field_70170_p.field_72995_K ? this.rightClickClientTable : this.rightClickServerTable;
        int rightClickNr = (Integer)rightClickTable.get(player.func_110124_au());
        if (rightClickNr == 0) {
            if (blockPos != null) {
                list.add(blockPos);
            }
        } else if (rightClickNr == 1) {
            BlockPos firstPos = (BlockPos)this.firstPosTable.get(player.func_110124_au());
            BlockPos secondPos = this.findSecondPos(player, firstPos, true);
            if (secondPos == null) {
                return list;
            }
            int axisLimit = ReachHelper.getMaxBlocksPerAxis(player);
            int x1 = firstPos.func_177958_n();
            int x2 = secondPos.func_177958_n();
            int y1 = firstPos.func_177956_o();
            int y2 = secondPos.func_177956_o();
            int z1 = firstPos.func_177952_p();
            int z2 = secondPos.func_177952_p();
            if (x2 - x1 >= axisLimit) {
                x2 = x1 + axisLimit - 1;
            }
            if (x1 - x2 >= axisLimit) {
                x2 = x1 - axisLimit + 1;
            }
            if (y2 - y1 >= axisLimit) {
                y2 = y1 + axisLimit - 1;
            }
            if (y1 - y2 >= axisLimit) {
                y2 = y1 - axisLimit + 1;
            }
            if (z2 - z1 >= axisLimit) {
                z2 = z1 + axisLimit - 1;
            }
            if (z1 - z2 >= axisLimit) {
                z2 = z1 - axisLimit + 1;
            }
            list.addAll(this.getIntermediateBlocks(player, x1, y1, z1, x2, y2, z2));
        } else {
            BlockPos secondPos;
            BlockPos firstPos = (BlockPos)this.firstPosTable.get(player.func_110124_au());
            BlockPos thirdPos = this.findThirdPos(player, firstPos, secondPos = this.secondPosTable.get(player.func_110124_au()), skipRaytrace);
            if (thirdPos == null) {
                return list;
            }
            int axisLimit = ReachHelper.getMaxBlocksPerAxis(player);
            int x1 = firstPos.func_177958_n();
            int x2 = secondPos.func_177958_n();
            int x3 = thirdPos.func_177958_n();
            int y1 = firstPos.func_177956_o();
            int y2 = secondPos.func_177956_o();
            int y3 = thirdPos.func_177956_o();
            int z1 = firstPos.func_177952_p();
            int z2 = secondPos.func_177952_p();
            int z3 = thirdPos.func_177952_p();
            if (x2 - x1 >= axisLimit) {
                x2 = x1 + axisLimit - 1;
            }
            if (x1 - x2 >= axisLimit) {
                x2 = x1 - axisLimit + 1;
            }
            if (y2 - y1 >= axisLimit) {
                y2 = y1 + axisLimit - 1;
            }
            if (y1 - y2 >= axisLimit) {
                y2 = y1 - axisLimit + 1;
            }
            if (z2 - z1 >= axisLimit) {
                z2 = z1 + axisLimit - 1;
            }
            if (z1 - z2 >= axisLimit) {
                z2 = z1 - axisLimit + 1;
            }
            if (x3 - x1 >= axisLimit) {
                x3 = x1 + axisLimit - 1;
            }
            if (x1 - x3 >= axisLimit) {
                x3 = x1 - axisLimit + 1;
            }
            if (y3 - y1 >= axisLimit) {
                y3 = y1 + axisLimit - 1;
            }
            if (y1 - y3 >= axisLimit) {
                y3 = y1 - axisLimit + 1;
            }
            if (z3 - z1 >= axisLimit) {
                z3 = z1 + axisLimit - 1;
            }
            if (z1 - z3 >= axisLimit) {
                z3 = z1 - axisLimit + 1;
            }
            list.addAll(this.getFinalBlocks(player, x1, y1, z1, x2, y2, z2, x3, y3, z3));
        }
        return list;
    }

    protected abstract BlockPos findSecondPos(PlayerEntity var1, BlockPos var2, boolean var3);

    protected abstract BlockPos findThirdPos(PlayerEntity var1, BlockPos var2, BlockPos var3, boolean var4);

    protected abstract List<BlockPos> getIntermediateBlocks(PlayerEntity var1, int var2, int var3, int var4, int var5, int var6, int var7);

    protected abstract List<BlockPos> getFinalBlocks(PlayerEntity var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    static class HeightCriteria {
        Vector3d planeBound;
        Vector3d lineBound;
        double distToLineSq;
        double distToPlayerSq;

        HeightCriteria(Vector3d planeBound, BlockPos secondPos, Vector3d start) {
            this.planeBound = planeBound;
            this.lineBound = this.toLongestLine(this.planeBound, secondPos);
            this.distToLineSq = this.lineBound.func_178788_d(this.planeBound).func_189985_c();
            this.distToPlayerSq = this.planeBound.func_178788_d(start).func_189985_c();
        }

        private Vector3d toLongestLine(Vector3d boundVec, BlockPos secondPos) {
            BlockPos bound = new BlockPos(boundVec);
            return new Vector3d((double)secondPos.func_177958_n(), (double)bound.func_177956_o(), (double)secondPos.func_177952_p());
        }

        public boolean isValid(Vector3d start, Vector3d look, int reach, PlayerEntity player, boolean skipRaytrace) {
            return BuildModes.isCriteriaValid(start, look, reach, player, skipRaytrace, this.lineBound, this.planeBound, this.distToPlayerSq);
        }
    }
}

