/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmode;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmode.IBuildMode;
import nl.requios.effortlessbuilding.buildmode.ModeOptions;
import nl.requios.effortlessbuilding.buildmode.ModeSettingsManager;
import nl.requios.effortlessbuilding.buildmode.buildmodes.Circle;
import nl.requios.effortlessbuilding.buildmode.buildmodes.Cube;
import nl.requios.effortlessbuilding.buildmode.buildmodes.Cylinder;
import nl.requios.effortlessbuilding.buildmode.buildmodes.DiagonalLine;
import nl.requios.effortlessbuilding.buildmode.buildmodes.DiagonalWall;
import nl.requios.effortlessbuilding.buildmode.buildmodes.Floor;
import nl.requios.effortlessbuilding.buildmode.buildmodes.Line;
import nl.requios.effortlessbuilding.buildmode.buildmodes.Normal;
import nl.requios.effortlessbuilding.buildmode.buildmodes.NormalPlus;
import nl.requios.effortlessbuilding.buildmode.buildmodes.SlopeFloor;
import nl.requios.effortlessbuilding.buildmode.buildmodes.Sphere;
import nl.requios.effortlessbuilding.buildmode.buildmodes.Wall;
import nl.requios.effortlessbuilding.buildmodifier.BuildModifiers;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.helper.ReachHelper;
import nl.requios.effortlessbuilding.helper.SurvivalHelper;
import nl.requios.effortlessbuilding.network.BlockBrokenMessage;
import nl.requios.effortlessbuilding.network.BlockPlacedMessage;

public class BuildModes {
    public static Dictionary<PlayerEntity, Boolean> currentlyBreakingClient = new Hashtable<PlayerEntity, Boolean>();
    public static Dictionary<PlayerEntity, Boolean> currentlyBreakingServer = new Hashtable<PlayerEntity, Boolean>();

    public static void onBlockPlacedMessage(PlayerEntity player, BlockPlacedMessage message) {
        Vector3d hitVec;
        Direction sideHit;
        List<BlockPos> coordinates;
        Dictionary<PlayerEntity, Boolean> currentlyBreaking;
        Dictionary<PlayerEntity, Boolean> dictionary = currentlyBreaking = player.field_70170_p.field_72995_K ? currentlyBreakingClient : currentlyBreakingServer;
        if (currentlyBreaking.get(player) != null && currentlyBreaking.get(player).booleanValue()) {
            BuildModes.initializeMode(player);
            return;
        }
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings(player);
        ModeSettingsManager.ModeSettings modeSettings = ModeSettingsManager.getModeSettings(player);
        BuildModeEnum buildMode = modeSettings.getBuildMode();
        BlockPos startPos = null;
        if (message.isBlockHit() && message.getBlockPos() != null) {
            startPos = message.getBlockPos();
            boolean replaceable = player.field_70170_p.func_180495_p(startPos).func_185904_a().func_76222_j();
            boolean becomesDoubleSlab = SurvivalHelper.doesBecomeDoubleSlab(player, startPos, message.getSideHit());
            if (!(modifierSettings.doQuickReplace() || replaceable || becomesDoubleSlab)) {
                startPos = startPos.func_177972_a(message.getSideHit());
            }
            if (modifierSettings.doQuickReplace() && replaceable) {
                startPos = startPos.func_177977_b();
            }
            int maxReach = ReachHelper.getMaxReach(player);
            if (buildMode != BuildModeEnum.NORMAL && player.func_233580_cy_().func_177951_i((Vector3i)startPos) > (double)(maxReach * maxReach)) {
                EffortlessBuilding.log(player, "Placement exceeds your reach.");
                return;
            }
        }
        if ((coordinates = buildMode.instance.onRightClick(player, startPos, message.getSideHit(), message.getHitVec(), modifierSettings.doQuickReplace())).isEmpty()) {
            currentlyBreaking.put(player, false);
            return;
        }
        int limit = ReachHelper.getMaxBlocksPlacedAtOnce(player);
        if (coordinates.size() > limit) {
            coordinates = coordinates.subList(0, limit);
        }
        if ((sideHit = buildMode.instance.getSideHit(player)) == null) {
            sideHit = message.getSideHit();
        }
        if ((hitVec = buildMode.instance.getHitVec(player)) == null) {
            hitVec = message.getHitVec();
        }
        BuildModifiers.onBlockPlaced(player, coordinates, sideHit, hitVec, message.getPlaceStartPos());
        currentlyBreaking.remove(player);
    }

    public static void onBlockBrokenMessage(PlayerEntity player, BlockBrokenMessage message) {
        BlockPos startPos = message.isBlockHit() ? message.getBlockPos() : null;
        BuildModes.onBlockBroken(player, startPos, true);
    }

    public static void onBlockBroken(PlayerEntity player, BlockPos startPos, boolean breakStartPos) {
        Dictionary<PlayerEntity, Boolean> currentlyBreaking;
        Dictionary<PlayerEntity, Boolean> dictionary = currentlyBreaking = player.field_70170_p.field_72995_K ? currentlyBreakingClient : currentlyBreakingServer;
        if (currentlyBreaking.get(player) != null && !currentlyBreaking.get(player).booleanValue()) {
            BuildModes.initializeMode(player);
            return;
        }
        if (currentlyBreaking.get(player) == null && startPos == null) {
            return;
        }
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings(player);
        ModeSettingsManager.ModeSettings modeSettings = ModeSettingsManager.getModeSettings(player);
        BuildModeEnum buildMode = modeSettings.getBuildMode();
        List<BlockPos> coordinates = buildMode.instance.onRightClick(player, startPos, Direction.UP, Vector3d.field_186680_a, true);
        if (coordinates.isEmpty()) {
            currentlyBreaking.put(player, true);
            return;
        }
        BuildModifiers.onBlockBroken(player, coordinates, breakStartPos);
        currentlyBreaking.remove(player);
    }

    public static List<BlockPos> findCoordinates(PlayerEntity player, BlockPos startPos, boolean skipRaytrace) {
        ArrayList<BlockPos> coordinates = new ArrayList<BlockPos>();
        ModeSettingsManager.ModeSettings modeSettings = ModeSettingsManager.getModeSettings(player);
        coordinates.addAll(modeSettings.getBuildMode().instance.findCoordinates(player, startPos, skipRaytrace));
        return coordinates;
    }

    public static void initializeMode(PlayerEntity player) {
        Dictionary<PlayerEntity, Boolean> currentlyBreaking = player.field_70170_p.field_72995_K ? currentlyBreakingClient : currentlyBreakingServer;
        currentlyBreaking.remove(player);
        ModeSettingsManager.getModeSettings((PlayerEntity)player).getBuildMode().instance.initialize(player);
    }

    public static boolean isCurrentlyPlacing(PlayerEntity player) {
        Dictionary<PlayerEntity, Boolean> currentlyBreaking = player.field_70170_p.field_72995_K ? currentlyBreakingClient : currentlyBreakingServer;
        return currentlyBreaking.get(player) != null && currentlyBreaking.get(player) == false;
    }

    public static boolean isCurrentlyBreaking(PlayerEntity player) {
        Dictionary<PlayerEntity, Boolean> currentlyBreaking = player.field_70170_p.field_72995_K ? currentlyBreakingClient : currentlyBreakingServer;
        return currentlyBreaking.get(player) != null && currentlyBreaking.get(player) != false;
    }

    public static boolean isActive(PlayerEntity player) {
        Dictionary<PlayerEntity, Boolean> currentlyBreaking = player.field_70170_p.field_72995_K ? currentlyBreakingClient : currentlyBreakingServer;
        return currentlyBreaking.get(player) != null;
    }

    public static Vector3d findXBound(double x, Vector3d start, Vector3d look) {
        double y = (x - start.field_72450_a) / look.field_72450_a * look.field_72448_b + start.field_72448_b;
        double z = (x - start.field_72450_a) / look.field_72450_a * look.field_72449_c + start.field_72449_c;
        return new Vector3d(x, y, z);
    }

    public static Vector3d findYBound(double y, Vector3d start, Vector3d look) {
        double x = (y - start.field_72448_b) / look.field_72448_b * look.field_72450_a + start.field_72450_a;
        double z = (y - start.field_72448_b) / look.field_72448_b * look.field_72449_c + start.field_72449_c;
        return new Vector3d(x, y, z);
    }

    public static Vector3d findZBound(double z, Vector3d start, Vector3d look) {
        double x = (z - start.field_72449_c) / look.field_72449_c * look.field_72450_a + start.field_72450_a;
        double y = (z - start.field_72449_c) / look.field_72449_c * look.field_72448_b + start.field_72448_b;
        return new Vector3d(x, y, z);
    }

    public static Vector3d getPlayerLookVec(PlayerEntity player) {
        Vector3d lookVec = player.func_70040_Z();
        double x = lookVec.field_72450_a;
        double y = lookVec.field_72448_b;
        double z = lookVec.field_72449_c;
        if (Math.abs(x) < 1.0E-4) {
            x = 1.0E-4;
        }
        if (Math.abs(x - 1.0) < 1.0E-4) {
            x = 0.9999;
        }
        if (Math.abs(x + 1.0) < 1.0E-4) {
            x = -0.9999;
        }
        if (Math.abs(y) < 1.0E-4) {
            y = 1.0E-4;
        }
        if (Math.abs(y - 1.0) < 1.0E-4) {
            y = 0.9999;
        }
        if (Math.abs(y + 1.0) < 1.0E-4) {
            y = -0.9999;
        }
        if (Math.abs(z) < 1.0E-4) {
            z = 1.0E-4;
        }
        if (Math.abs(z - 1.0) < 1.0E-4) {
            z = 0.9999;
        }
        if (Math.abs(z + 1.0) < 1.0E-4) {
            z = -0.9999;
        }
        return new Vector3d(x, y, z);
    }

    public static boolean isCriteriaValid(Vector3d start, Vector3d look, int reach, PlayerEntity player, boolean skipRaytrace, Vector3d lineBound, Vector3d planeBound, double distToPlayerSq) {
        boolean intersects = false;
        if (!skipRaytrace) {
            RayTraceContext rayTraceContext = new RayTraceContext(start, lineBound, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)player);
            BlockRayTraceResult rayTraceResult = player.field_70170_p.func_217299_a(rayTraceContext);
            intersects = rayTraceResult != null && rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK && planeBound.func_178788_d(rayTraceResult.func_216347_e()).func_189985_c() > 4.0;
        }
        return planeBound.func_178788_d(start).func_72430_b(look) > 0.0 && distToPlayerSq > 2.0 && distToPlayerSq < (double)(reach * reach) && !intersects;
    }

    public static enum BuildModeEnum {
        NORMAL("effortlessbuilding.mode.normal", new Normal(), new ModeOptions.OptionEnum[0]),
        NORMAL_PLUS("effortlessbuilding.mode.normal_plus", new NormalPlus(), ModeOptions.OptionEnum.BUILD_SPEED),
        LINE("effortlessbuilding.mode.line", new Line(), new ModeOptions.OptionEnum[0]),
        WALL("effortlessbuilding.mode.wall", new Wall(), ModeOptions.OptionEnum.FILL),
        FLOOR("effortlessbuilding.mode.floor", new Floor(), ModeOptions.OptionEnum.FILL),
        DIAGONAL_LINE("effortlessbuilding.mode.diagonal_line", new DiagonalLine(), new ModeOptions.OptionEnum[0]),
        DIAGONAL_WALL("effortlessbuilding.mode.diagonal_wall", new DiagonalWall(), new ModeOptions.OptionEnum[0]),
        SLOPE_FLOOR("effortlessbuilding.mode.slope_floor", new SlopeFloor(), ModeOptions.OptionEnum.RAISED_EDGE),
        CIRCLE("effortlessbuilding.mode.circle", new Circle(), ModeOptions.OptionEnum.CIRCLE_START, ModeOptions.OptionEnum.FILL),
        CYLINDER("effortlessbuilding.mode.cylinder", new Cylinder(), ModeOptions.OptionEnum.CIRCLE_START, ModeOptions.OptionEnum.FILL),
        SPHERE("effortlessbuilding.mode.sphere", new Sphere(), ModeOptions.OptionEnum.CIRCLE_START, ModeOptions.OptionEnum.FILL),
        CUBE("effortlessbuilding.mode.cube", new Cube(), ModeOptions.OptionEnum.CUBE_FILL);

        public String name;
        public IBuildMode instance;
        public ModeOptions.OptionEnum[] options;

        private BuildModeEnum(String name, IBuildMode instance, ModeOptions.OptionEnum ... options) {
            this.name = name;
            this.instance = instance;
            this.options = options;
        }
    }
}

