/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding;

import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import nl.requios.effortlessbuilding.BuildConfig;
import nl.requios.effortlessbuilding.buildmode.BuildModes;
import nl.requios.effortlessbuilding.buildmode.ModeSettingsManager;
import nl.requios.effortlessbuilding.buildmodifier.BuildModifiers;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.buildmodifier.UndoRedo;
import nl.requios.effortlessbuilding.capability.ModeCapabilityManager;
import nl.requios.effortlessbuilding.capability.ModifierCapabilityManager;
import nl.requios.effortlessbuilding.helper.ReachHelper;
import nl.requios.effortlessbuilding.helper.SurvivalHelper;
import nl.requios.effortlessbuilding.network.AddUndoMessage;
import nl.requios.effortlessbuilding.network.ClearUndoMessage;
import nl.requios.effortlessbuilding.network.PacketHandler;
import nl.requios.effortlessbuilding.network.RequestLookAtMessage;

@Mod.EventBusSubscriber
public class EventHandler {
    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof FakePlayer) {
            return;
        }
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(new ResourceLocation("effortlessbuilding", "build_modifier"), (ICapabilityProvider)new ModifierCapabilityManager.Provider());
            event.addCapability(new ResourceLocation("effortlessbuilding", "build_mode"), (ICapabilityProvider)new ModeCapabilityManager.Provider());
        }
    }

    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        if (event.getWorld().func_201670_d()) {
            return;
        }
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        if (event.getEntity() instanceof FakePlayer) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
        BuildModes.BuildModeEnum buildMode = ModeSettingsManager.getModeSettings((PlayerEntity)player).getBuildMode();
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings((PlayerEntity)player);
        if (buildMode != BuildModes.BuildModeEnum.NORMAL) {
            event.setCanceled(true);
        } else if (modifierSettings.doQuickReplace()) {
            event.setCanceled(true);
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new RequestLookAtMessage(true));
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new AddUndoMessage(event.getPos(), event.getBlockSnapshot().getReplacedBlock(), event.getState()));
        } else {
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new RequestLookAtMessage(false));
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new AddUndoMessage(event.getPos(), event.getBlockSnapshot().getReplacedBlock(), event.getState()));
        }
    }

    @SubscribeEvent
    public static void onBlockBroken(BlockEvent.BreakEvent event) {
        if (event.getWorld().func_201670_d()) {
            return;
        }
        if (event.getPlayer() instanceof FakePlayer) {
            return;
        }
        BuildModes.BuildModeEnum buildMode = ModeSettingsManager.getModeSettings(event.getPlayer()).getBuildMode();
        if (buildMode != BuildModes.BuildModeEnum.NORMAL && ReachHelper.canBreakFar(event.getPlayer())) {
            event.setCanceled(true);
        } else {
            PacketDistributor.PacketTarget packetTarget;
            BuildModes.onBlockBroken(event.getPlayer(), event.getPos(), false);
            if (event.getPlayer() instanceof ServerPlayerEntity && event.getState() != null && event.getPos() != null && (packetTarget = PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer())) != null) {
                PacketHandler.INSTANCE.send(packetTarget, (Object)new AddUndoMessage(event.getPos(), event.getState(), Blocks.field_150350_a.func_176223_P()));
            }
        }
    }

    @SubscribeEvent
    public static void breakSpeed(PlayerEvent.BreakSpeed event) {
        if (!((Boolean)BuildConfig.survivalBalancers.increasedMiningTime.get()).booleanValue()) {
            return;
        }
        if (event.getPlayer() instanceof FakePlayer) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        World world = player.field_70170_p;
        BlockPos pos = event.getPos();
        float originalBlockHardness = event.getState().func_185887_b((IBlockReader)world, pos);
        if (originalBlockHardness < 0.0f) {
            return;
        }
        float totalBlockHardness = 0.0f;
        List<BlockPos> coordinates = BuildModifiers.findCoordinates(player, pos);
        for (int i = 1; i < coordinates.size(); ++i) {
            BlockPos coordinate = coordinates.get(i);
            BlockState blockState = world.func_180495_p(coordinate);
            if (!SurvivalHelper.canBreak(world, player, coordinate)) continue;
            totalBlockHardness += blockState.func_185887_b((IBlockReader)world, coordinate);
        }
        float percentage = (float)((Integer)BuildConfig.survivalBalancers.miningTimePercentage.get()).intValue() / 100.0f;
        totalBlockHardness *= percentage;
        float newSpeed = event.getOriginalSpeed() / (totalBlockHardness += originalBlockHardness) * originalBlockHardness;
        if (Float.isNaN(newSpeed) || newSpeed == 0.0f) {
            newSpeed = 1.0f;
        }
        event.setNewSpeed(newSpeed);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() instanceof FakePlayer) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        ModifierSettingsManager.handleNewPlayer(player);
        ModeSettingsManager.handleNewPlayer(player);
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getPlayer() instanceof FakePlayer) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (player.func_130014_f_().field_72995_K) {
            return;
        }
        UndoRedo.clear(player);
        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new ClearUndoMessage());
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.getPlayer() instanceof FakePlayer) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        ModifierSettingsManager.handleNewPlayer(player);
        ModeSettingsManager.handleNewPlayer(player);
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getPlayer() instanceof FakePlayer) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (player.func_130014_f_().field_72995_K) {
            return;
        }
        ModeSettingsManager.ModeSettings modeSettings = ModeSettingsManager.getModeSettings(player);
        modeSettings.setBuildMode(BuildModes.BuildModeEnum.NORMAL);
        ModeSettingsManager.setModeSettings(player, modeSettings);
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings(player);
        modifierSettings.getMirrorSettings().enabled = false;
        modifierSettings.getRadialMirrorSettings().enabled = false;
        modifierSettings.getArraySettings().enabled = false;
        ModifierSettingsManager.setModifierSettings(player, modifierSettings);
        ModifierSettingsManager.handleNewPlayer(player);
        ModeSettingsManager.handleNewPlayer(player);
        UndoRedo.clear(player);
        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new ClearUndoMessage());
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.getPlayer() instanceof FakePlayer) {
            return;
        }
        PlayerEntity oldPlayer = event.getOriginal();
        oldPlayer.revive();
        PlayerEntity newPlayer = event.getPlayer();
        ModifierSettingsManager.setModifierSettings(newPlayer, ModifierSettingsManager.getModifierSettings(oldPlayer));
        ModeSettingsManager.setModeSettings(newPlayer, ModeSettingsManager.getModeSettings(oldPlayer));
    }
}

