/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.world;

import com.google.common.collect.Maps;
import com.infinityraider.infinitylib.world.IInfStructure;
import com.infinityraider.infinitylib.world.StructureInjector;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;

public class StructureRegistry {
    private static final StructureRegistry INSTANCE = new StructureRegistry();
    private final Map<ResourceLocation, StructureInjector> injectors = Maps.newHashMap();

    public static StructureRegistry getInstance() {
        return INSTANCE;
    }

    private StructureRegistry() {
    }

    public void registerStructure(IInfStructure structure) {
        structure.targetPools().forEach(target -> this.injectors.computeIfAbsent((ResourceLocation)target, StructureInjector::new).addStructure(structure));
    }

    public void injectStructures(DynamicRegistries registries) {
        this.injectors.values().forEach(injector -> injector.inject(registries));
    }
}

