/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.world;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.infinityraider.infinitylib.InfinityLib;
import com.infinityraider.infinitylib.world.IInfStructure;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.LegacySingleJigsawPiece;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class StructureInjector {
    private final Set<IInfStructure> structures = Sets.newIdentityHashSet();
    private final ResourceLocation target;

    protected StructureInjector(ResourceLocation target) {
        this.target = target;
    }

    protected void addStructure(IInfStructure structure) {
        this.structures.add(structure);
    }

    protected void inject(DynamicRegistries registries) {
        JigsawPattern pool = registries.func_243612_b(Registry.field_243555_ax).func_241873_b(this.target).orElse(null);
        if (pool == null) {
            InfinityLib.instance.getLogger().error("Could not inject structures into {0}, pool not found", this.target);
            return;
        }
        try {
            Field field = ObfuscationReflectionHelper.findField(JigsawPattern.class, (String)"field_214953_e");
            field.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            ArrayList pieces = Lists.newArrayList((Iterable)((List)field.get(pool)));
            this.structures.forEach(structure -> {
                InfinityLib.instance.getLogger().info("Injecting structure {0} into {1}", structure.id(), this.target);
                LegacySingleJigsawPiece piece = (LegacySingleJigsawPiece)JigsawPiece.func_242849_a((String)structure.id().toString()).apply(structure.placement());
                for (int i = 0; i < structure.weight(); ++i) {
                    pieces.add(piece);
                }
            });
            field.set(pool, pieces);
        }
        catch (Exception e) {
            InfinityLib.instance.getLogger().error("Failed to inject structures into {0}, exception was thrown", this.target);
            InfinityLib.instance.getLogger().printStackTrace(e);
        }
    }
}

