/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.render.tessellation;

import com.google.common.collect.ImmutableList;
import com.infinityraider.infinitylib.render.tessellation.TessellatorAbstractBase;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TessellatorVertexBuffer
extends TessellatorAbstractBase {
    private final IRenderTypeBuffer.Impl buffer;
    private final RenderType renderType;
    private IVertexBuilder builder;

    public TessellatorVertexBuffer(IRenderTypeBuffer.Impl buffer, RenderType renderType) {
        this.buffer = buffer;
        this.renderType = renderType;
    }

    public IRenderTypeBuffer.Impl getVertexBuffer() {
        return this.buffer;
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    @Override
    protected void onStartDrawingQuadsCall() {
        this.builder = this.getVertexBuffer().getBuffer(this.getRenderType());
    }

    @Override
    public ImmutableList<BakedQuad> getQuads() {
        return ImmutableList.of();
    }

    @Override
    public VertexFormat getVertexFormat() {
        return this.getRenderType().func_228663_p_();
    }

    @Override
    protected void onDrawCall() {
        if (this.builder != null) {
            this.getVertexBuffer().func_228462_a_(this.getRenderType());
            this.builder = null;
        }
    }

    @Override
    public TessellatorVertexBuffer addQuads(List<BakedQuad> quads) {
        quads.forEach(quad -> this.builder.func_227889_a_(this.getMatrixStackEntry(), quad, this.getRed(), this.getBlue(), this.getGreen(), this.getBrightness(), OverlayTexture.field_229196_a_));
        return this;
    }

    @Override
    public TessellatorVertexBuffer addVertexWithUV(float x, float y, float z, float u, float v) {
        Vector4f pos = new Vector4f(x, y, z, 1.0f);
        this.transform(pos);
        ImmutableList elements = this.getVertexFormat().func_227894_c_();
        if (elements.contains(DefaultVertexFormats.field_181713_m)) {
            this.builder.func_225582_a_((double)pos.func_195910_a(), (double)pos.func_195913_b(), (double)pos.func_195914_c());
        }
        if (elements.contains(DefaultVertexFormats.field_181714_n)) {
            this.builder.func_225586_a_((int)(this.getRed() * 255.0f), (int)(this.getGreen() * 255.0f), (int)(this.getBlue() * 255.0f), (int)(this.getAlpha() * 255.0f));
        }
        if (elements.contains(DefaultVertexFormats.field_181715_o)) {
            this.builder.func_225583_a_(u, v);
        }
        if (elements.contains(DefaultVertexFormats.field_181716_p)) {
            this.builder.func_227891_b_(this.getOverlay());
        }
        if (elements.contains(DefaultVertexFormats.field_227848_e_)) {
            this.builder.func_227886_a_(this.getBrightness());
        }
        if (elements.contains(DefaultVertexFormats.field_181717_q)) {
            this.builder.func_225584_a_(this.getNormal().func_195899_a(), this.getNormal().func_195900_b(), this.getNormal().func_195902_c());
        }
        this.builder.func_181675_d();
        return this;
    }

    @Override
    protected void applyColorMultiplier(Direction side) {
        float preMultiplier = this.getMultiplier(side);
        this.setColorRGB(preMultiplier * this.getRed(), preMultiplier * this.getGreen(), preMultiplier * this.getBlue());
    }

    private float getMultiplier(Direction side) {
        switch (side) {
            case DOWN: {
                return 0.5f;
            }
            case NORTH: 
            case SOUTH: {
                return 0.8f;
            }
            case EAST: 
            case WEST: {
                return 0.6f;
            }
        }
        return 1.0f;
    }
}

