/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.render.model;

import com.infinityraider.infinitylib.InfinityLib;
import java.lang.reflect.Field;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.BlockPartRotation;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.QuadTransformer;

@OnlyIn(value=Dist.CLIENT)
public class TransformingFaceBakery
extends FaceBakery {
    private static final TransformingFaceBakery INSTANCE = TransformingFaceBakery.hijackVanillaFaceBakery();
    private final FaceBakery pilot;
    private final ThreadLocal<TransformStack> transforms;
    private static final TransformingFaceBakery DUMMY = new TransformingFaceBakery(null){

        @Override
        public void pushQuadTransform(TransformationMatrix matrix) {
            InfinityLib.instance.getLogger().error("Can not apply transform, Face Bakery has not been successfully hijacked", new Object[0]);
        }

        @Override
        public void popQuadTransform() {
        }

        @Override
        public BakedQuad func_228824_a_(Vector3f p1, Vector3f p2, BlockPartFace face, TextureAtlasSprite sprite, Direction facing, IModelTransform transform, @Nullable BlockPartRotation partRotation, boolean shade, ResourceLocation location) {
            return super.func_228824_a_(p1, p2, face, sprite, facing, transform, partRotation, shade, location);
        }

        @Override
        public void func_228822_a_(Vector3f posIn, TransformationMatrix transformIn) {
            super.func_228822_a_(posIn, transformIn);
        }
    };

    public static TransformingFaceBakery getInstance() {
        return INSTANCE;
    }

    public static void init() {
    }

    private TransformingFaceBakery(FaceBakery pilot) {
        this.pilot = pilot;
        this.transforms = ThreadLocal.withInitial(() -> new TransformStack());
    }

    public void pushQuadTransform(TransformationMatrix matrix) {
        this.transforms.get().push(matrix);
    }

    public void popQuadTransform() {
        this.transforms.get().pop();
    }

    public BakedQuad func_228824_a_(Vector3f p1, Vector3f p2, BlockPartFace face, TextureAtlasSprite sprite, Direction facing, IModelTransform transform, @Nullable BlockPartRotation partRotation, boolean shade, ResourceLocation location) {
        return this.transforms.get().transform(this.pilot.func_228824_a_(p1, p2, face, sprite, facing, transform, partRotation, shade, location));
    }

    public void func_228822_a_(Vector3f posIn, TransformationMatrix transformIn) {
        this.pilot.func_228822_a_(posIn, transformIn);
    }

    private static TransformingFaceBakery hijackVanillaFaceBakery() {
        InfinityLib.instance.getLogger().info("Trying to hijack Vanilla Face Bakery", new Object[0]);
        return Arrays.stream(BlockModel.class.getDeclaredFields()).filter(field -> field.getType().isAssignableFrom(FaceBakery.class)).findAny().map(field -> {
            try {
                field.setAccessible(true);
                Field modifiers = Field.class.getDeclaredField("modifiers");
                modifiers.setAccessible(true);
                modifiers.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                FaceBakery captain = (FaceBakery)field.get(null);
                TransformingFaceBakery lookAtMeImTheCaptainNow = new TransformingFaceBakery(captain);
                field.set(null, (Object)lookAtMeImTheCaptainNow);
                InfinityLib.instance.getLogger().info("Hijacking successful, new destination: Blockhamas", new Object[0]);
                return lookAtMeImTheCaptainNow;
            }
            catch (Exception e) {
                InfinityLib.instance.getLogger().info("Hijacking failed, one ticket to prison obtained", new Object[0]);
                e.printStackTrace();
                return DUMMY;
            }
        }).orElseGet(() -> {
            InfinityLib.instance.getLogger().info("Missed the plane, try catching the next flight", new Object[0]);
            return DUMMY;
        });
    }

    private static class TransformStack {
        private Layer layer = BASE_LAYER;
        private static final Layer BASE_LAYER = new Layer(null, TransformationMatrix.func_227983_a_()){

            @Override
            public TransformationMatrix getCurrentMatrix() {
                return TransformationMatrix.func_227983_a_();
            }

            @Override
            protected Layer getPreviousLayer() {
                return this;
            }
        };

        private TransformStack() {
        }

        public TransformStack push(TransformationMatrix matrix) {
            this.layer = new Layer(this.layer, matrix);
            return this;
        }

        public TransformStack pop() {
            this.layer = this.layer.getPreviousLayer();
            return this;
        }

        public BakedQuad transform(BakedQuad quad) {
            return this.layer.transform(quad);
        }

        private static class Layer {
            private final Layer previous;
            private final TransformationMatrix currentMatrix;
            private final QuadTransformer currentTransformer;

            private Layer(Layer previous, TransformationMatrix matrix) {
                this.previous = previous;
                this.currentMatrix = this.getPreviousLayer().getCurrentMatrix().compose(matrix);
                this.currentTransformer = this.getCurrentMatrix().isIdentity() ? null : new QuadTransformer(this.getCurrentMatrix());
            }

            protected Layer getPreviousLayer() {
                return this.previous;
            }

            public TransformationMatrix getCurrentMatrix() {
                return this.currentMatrix;
            }

            public BakedQuad transform(BakedQuad quad) {
                return this.currentTransformer == null ? quad : this.currentTransformer.processOne(quad);
            }
        }
    }
}

